/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.Scheduling;
import com.google.jenkins.plugins.computeengine.CloudNotFoundException;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import com.google.jenkins.plugins.computeengine.ComputeEngineInstance;
import com.google.jenkins.plugins.computeengine.InstanceConfiguration;
import com.google.jenkins.plugins.computeengine.PreemptedCheckCallable;
import hudson.model.Executor;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;

public class ComputeEngineComputer
extends AbstractCloudComputer<ComputeEngineInstance> {
    private static final Logger log = Logger.getLogger(ComputeEngineComputer.class.getName());
    private volatile Instance instance;
    private CompletableFuture<Boolean> preemptedFuture;

    public ComputeEngineComputer(ComputeEngineInstance slave) {
        super((AbstractCloudSlave)slave);
    }

    void onConnected(TaskListener listener) {
        ComputeEngineInstance node = (ComputeEngineInstance)this.getNode();
        if (node != null) {
            node.onConnected();
            if (this.getPreemptible()) {
                String nodeName = node.getNodeName();
                String msg = "Instance " + nodeName + " is preemptive, setting up preemption listener";
                log.log(Level.INFO, msg);
                listener.getLogger().println(msg);
                this.preemptedFuture = CompletableFuture.supplyAsync(() -> this.getPreemptedStatus(listener, nodeName), threadPoolForRemoting);
            }
        }
    }

    private Boolean getPreemptedStatus(TaskListener listener, String nodeName) {
        try {
            boolean value = (Boolean)this.getChannel().call((Callable)new PreemptedCheckCallable(listener));
            log.log(Level.FINE, "Got information that node was preempted with value [" + value + "]");
            if (value) {
                log.log(Level.FINE, "Preempted node was preempted, terminating all executors");
                this.getChannel().close();
                this.getExecutors().forEach(executor -> this.interruptExecutor((Executor)executor, nodeName));
            }
            return value;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void interruptExecutor(Executor executor, String nodeName) {
        log.log(Level.INFO, "Terminating executor " + executor + " node " + nodeName);
        executor.abortResult();
    }

    public boolean getPreemptible() {
        try {
            Scheduling scheduling = this.getInstance().getScheduling();
            return scheduling != null && scheduling.getPreemptible() != false;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error when getting preemptible status", e);
            return false;
        }
    }

    public boolean getPreempted() {
        try {
            return this.preemptedFuture != null && this.preemptedFuture.isDone() && this.preemptedFuture.get() != false;
        }
        catch (InterruptedException | ExecutionException e) {
            log.log(Level.WARNING, "Error when getting preempted status", e);
            return false;
        }
    }

    public String getNumExecutorsStr() {
        return String.valueOf(super.getNumExecutors());
    }

    @DataBoundSetter
    public void setNumExecutorsStr(String value) {
        Integer v = InstanceConfiguration.intOrDefault(value, InstanceConfiguration.DEFAULT_NUM_EXECUTORS);
        ComputeEngineInstance node = (ComputeEngineInstance)this.getNode();
        if (node != null) {
            node.setNumExecutors(v);
        }
    }

    public Instance getInstance() throws IOException {
        if (this.instance == null) {
            this.instance = this._getInstance();
        }
        return this.instance;
    }

    public Instance refreshInstance() throws IOException {
        this.instance = this._getInstance();
        return this.instance;
    }

    public String getInstanceStatus() throws IOException {
        this.instance = this._getInstance();
        return this.instance.getStatus();
    }

    private Instance _getInstance() throws IOException {
        try {
            ComputeEngineInstance node = (ComputeEngineInstance)this.getNode();
            ComputeEngineCloud cloud = this.getCloud();
            if (node != null) {
                return cloud.getClient().getInstance(cloud.getProjectId(), node.getZone(), node.getNodeName());
            }
            return null;
        }
        catch (CloudNotFoundException cnfe) {
            return null;
        }
    }

    protected ComputeEngineCloud getCloud() {
        ComputeEngineInstance node = (ComputeEngineInstance)this.getNode();
        if (node == null) {
            throw new CloudNotFoundException("Could not retrieve cloud from empty node");
        }
        return node.getCloud();
    }

    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        ComputeEngineInstance node = (ComputeEngineInstance)this.getNode();
        if (node != null) {
            try {
                node.terminate();
            }
            catch (InterruptedException ie) {
                log.log(Level.WARNING, "Node Termination Error", ie);
            }
        }
        return new HttpRedirect("..");
    }
}

