/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.common.base.Strings;
import com.google.jenkins.plugins.computeengine.CloudNotFoundException;
import com.google.jenkins.plugins.computeengine.ComputeEngineCloud;
import com.google.jenkins.plugins.computeengine.ComputeEngineComputer;
import com.google.jenkins.plugins.computeengine.Messages;
import com.google.jenkins.plugins.computeengine.WindowsConfiguration;
import com.google.jenkins.plugins.computeengine.ssh.GoogleKeyPair;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;

public class ComputeEngineInstance
extends AbstractCloudSlave {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ComputeEngineInstance.class.getName());
    private static final long CREATE_SNAPSHOT_TIMEOUT_LINUX = 120000L;
    private static final long CREATE_SNAPSHOT_TIMEOUT_WINDOWS = 600000L;
    private final String zone;
    private final String cloudName;
    private final String sshUser;
    private final WindowsConfiguration windowsConfig;
    private final boolean createSnapshot;
    private final boolean oneShot;
    private final boolean ignoreProxy;
    private final String javaExecPath;
    private final GoogleKeyPair sshKeyPair;
    private Integer launchTimeout;
    private Boolean connected;

    private ComputeEngineInstance(String cloudName, String name, String zone, String nodeDescription, String sshUser, String remoteFS, @Nullable WindowsConfiguration windowsConfig, boolean createSnapshot, boolean oneShot, boolean ignoreProxy, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, Integer launchTimeout, @Nullable String javaExecPath, @Nullable GoogleKeyPair sshKeyPair) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, Collections.emptyList());
        this.launchTimeout = launchTimeout;
        this.zone = zone;
        this.cloudName = cloudName;
        this.sshUser = sshUser;
        this.windowsConfig = windowsConfig;
        this.createSnapshot = createSnapshot;
        this.oneShot = oneShot;
        this.ignoreProxy = ignoreProxy;
        this.javaExecPath = javaExecPath;
        this.sshKeyPair = sshKeyPair;
    }

    public AbstractCloudComputer createComputer() {
        return new ComputeEngineComputer(this);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        try {
            ComputeEngineCloud cloud = this.getCloud();
            Computer computer = this.toComputer();
            if (this.oneShot && this.createSnapshot && computer != null && !computer.getBuilds().failureOnly().isEmpty()) {
                LOGGER.log(Level.INFO, "Creating snapshot for node ... " + this.getNodeName());
                long createSnapshotTimeout = this.windowsConfig != null ? 600000L : 120000L;
                cloud.getClient().createSnapshotSync(cloud.getProjectId(), this.zone, this.getNodeName(), createSnapshotTimeout);
            }
            cloud.getClient().terminateInstanceAsync(cloud.getProjectId(), this.zone, this.name);
        }
        catch (CloudNotFoundException cnfe) {
            listener.error(cnfe.getMessage());
        }
        catch (ComputeClient.OperationException oe) {
            listener.error(oe.getError().toPrettyString());
        }
    }

    public void onConnected() {
        this.connected = true;
    }

    public long getLaunchTimeoutMillis() {
        return (long)this.launchTimeout.intValue() * 1000L;
    }

    public String getJavaExecPathOrDefault() {
        return !Strings.isNullOrEmpty((String)this.javaExecPath) ? this.javaExecPath : "java";
    }

    public Optional<GoogleKeyPair> getSSHKeyPair() {
        return Optional.ofNullable(this.sshKeyPair);
    }

    public ComputeEngineCloud getCloud() throws CloudNotFoundException {
        ComputeEngineCloud cloud = (ComputeEngineCloud)Jenkins.get().getCloud(this.cloudName);
        if (cloud == null) {
            throw new CloudNotFoundException(String.format("Could not find cloud %s in Jenkins configuration", this.cloudName));
        }
        return cloud;
    }

    public static ComputeEngineInstanceBuilder builder() {
        return new ComputeEngineInstanceBuilder();
    }

    public String getZone() {
        return this.zone;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String getSshUser() {
        return this.sshUser;
    }

    public WindowsConfiguration getWindowsConfig() {
        return this.windowsConfig;
    }

    public boolean isCreateSnapshot() {
        return this.createSnapshot;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public boolean isIgnoreProxy() {
        return this.ignoreProxy;
    }

    public String getJavaExecPath() {
        return this.javaExecPath;
    }

    public Integer getLaunchTimeout() {
        return this.launchTimeout;
    }

    public Boolean getConnected() {
        return this.connected;
    }

    public static class ComputeEngineInstanceBuilder {
        private String cloudName;
        private String name;
        private String zone;
        private String nodeDescription;
        private String sshUser;
        private String remoteFS;
        private WindowsConfiguration windowsConfig;
        private boolean createSnapshot;
        private boolean oneShot;
        private boolean ignoreProxy;
        private int numExecutors;
        private Node.Mode mode;
        private String labelString;
        private ComputerLauncher launcher;
        private RetentionStrategy retentionStrategy;
        private Integer launchTimeout;
        private String javaExecPath;
        private GoogleKeyPair sshKeyPair;

        ComputeEngineInstanceBuilder() {
        }

        public ComputeEngineInstanceBuilder cloudName(String cloudName) {
            this.cloudName = cloudName;
            return this;
        }

        public ComputeEngineInstanceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ComputeEngineInstanceBuilder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public ComputeEngineInstanceBuilder nodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
            return this;
        }

        public ComputeEngineInstanceBuilder sshUser(String sshUser) {
            this.sshUser = sshUser;
            return this;
        }

        public ComputeEngineInstanceBuilder remoteFS(String remoteFS) {
            this.remoteFS = remoteFS;
            return this;
        }

        public ComputeEngineInstanceBuilder windowsConfig(@Nullable WindowsConfiguration windowsConfig) {
            this.windowsConfig = windowsConfig;
            return this;
        }

        public ComputeEngineInstanceBuilder createSnapshot(boolean createSnapshot) {
            this.createSnapshot = createSnapshot;
            return this;
        }

        public ComputeEngineInstanceBuilder oneShot(boolean oneShot) {
            this.oneShot = oneShot;
            return this;
        }

        public ComputeEngineInstanceBuilder ignoreProxy(boolean ignoreProxy) {
            this.ignoreProxy = ignoreProxy;
            return this;
        }

        public ComputeEngineInstanceBuilder numExecutors(int numExecutors) {
            this.numExecutors = numExecutors;
            return this;
        }

        public ComputeEngineInstanceBuilder mode(Node.Mode mode) {
            this.mode = mode;
            return this;
        }

        public ComputeEngineInstanceBuilder labelString(String labelString) {
            this.labelString = labelString;
            return this;
        }

        public ComputeEngineInstanceBuilder launcher(ComputerLauncher launcher) {
            this.launcher = launcher;
            return this;
        }

        public ComputeEngineInstanceBuilder retentionStrategy(RetentionStrategy retentionStrategy) {
            this.retentionStrategy = retentionStrategy;
            return this;
        }

        public ComputeEngineInstanceBuilder launchTimeout(Integer launchTimeout) {
            this.launchTimeout = launchTimeout;
            return this;
        }

        public ComputeEngineInstanceBuilder javaExecPath(@Nullable String javaExecPath) {
            this.javaExecPath = javaExecPath;
            return this;
        }

        public ComputeEngineInstanceBuilder sshKeyPair(@Nullable GoogleKeyPair sshKeyPair) {
            this.sshKeyPair = sshKeyPair;
            return this;
        }

        public ComputeEngineInstance build() throws Descriptor.FormException, IOException {
            return new ComputeEngineInstance(this.cloudName, this.name, this.zone, this.nodeDescription, this.sshUser, this.remoteFS, this.windowsConfig, this.createSnapshot, this.oneShot, this.ignoreProxy, this.numExecutors, this.mode, this.labelString, this.launcher, this.retentionStrategy, this.launchTimeout, this.javaExecPath, this.sshKeyPair);
        }

        public String toString() {
            return "ComputeEngineInstance.ComputeEngineInstanceBuilder(cloudName=" + this.cloudName + ", name=" + this.name + ", zone=" + this.zone + ", nodeDescription=" + this.nodeDescription + ", sshUser=" + this.sshUser + ", remoteFS=" + this.remoteFS + ", windowsConfig=" + this.windowsConfig + ", createSnapshot=" + this.createSnapshot + ", oneShot=" + this.oneShot + ", ignoreProxy=" + this.ignoreProxy + ", numExecutors=" + this.numExecutors + ", mode=" + this.mode + ", labelString=" + this.labelString + ", launcher=" + this.launcher + ", retentionStrategy=" + this.retentionStrategy + ", launchTimeout=" + this.launchTimeout + ", javaExecPath=" + this.javaExecPath + ", sshKeyPair=" + this.sshKeyPair + ")";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return Messages.ComputeEngineAgent_DisplayName();
        }
    }
}

