/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.Subnetwork;
import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.computeengine.NetworkConfiguration;
import hudson.Extension;
import hudson.RelativePath;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AutofilledNetworkConfiguration
extends NetworkConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AutofilledNetworkConfiguration.class.getName());

    @DataBoundConstructor
    public AutofilledNetworkConfiguration(String network, String subnetwork) {
        super(network, subnetwork);
    }

    public AutofilledNetworkConfiguration() {
        super("", "");
    }

    @Extension
    public static final class DescriptorImpl
    extends NetworkConfiguration.NetworkConfigurationDescriptor {
        @Override
        public String getDisplayName() {
            return "Available networks";
        }

        public ListBoxModel doFillNetworkItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") @RelativePath(value="../..") String projectId, @QueryParameter(value="credentialsId") @RelativePath(value="../..") String credentialsId) {
            ListBoxModel items = new ListBoxModel();
            items.add("");
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList networks = compute.listNetworks(projectId);
                for (Network n : networks) {
                    items.add(n.getName(), n.getSelfLink());
                }
                return items;
            }
            catch (IOException | IllegalArgumentException e) {
                String message = "Error retrieving networks";
                LOGGER.log(Level.SEVERE, message, e);
                items.clear();
                items.add((Object)new ListBoxModel.Option(message, "", true));
                return items;
            }
        }

        public FormValidation doCheckNetwork(@QueryParameter String value) {
            if (value.equals("")) {
                return FormValidation.error((String)"Please select a network...");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillSubnetworkItems(@AncestorInPath Jenkins context, @QueryParameter(value="network") String network, @QueryParameter(value="region") @RelativePath(value="..") String region, @QueryParameter(value="projectId") @RelativePath(value="../..") String projectId, @QueryParameter(value="credentialsId") @RelativePath(value="../..") String credentialsId) {
            ListBoxModel items = new ListBoxModel();
            if (Strings.isNullOrEmpty((String)region)) {
                return items;
            }
            try {
                ComputeClient compute = DescriptorImpl.computeClient(context, credentialsId);
                ImmutableList subnetworks = compute.listSubnetworks(projectId, network, region);
                if (subnetworks.size() == 0) {
                    items.add((Object)new ListBoxModel.Option("default", "default", true));
                    return items;
                }
                for (Subnetwork s : subnetworks) {
                    items.add(s.getName(), s.getSelfLink());
                }
                return items;
            }
            catch (IOException | IllegalArgumentException e) {
                String message = "Error retrieving subnetworks";
                LOGGER.log(Level.SEVERE, message, e);
                items.clear();
                items.add((Object)new ListBoxModel.Option(message, "", true));
                return items;
            }
        }

        public FormValidation doCheckSubnetwork(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Please select a subnetwork...");
            }
            return FormValidation.ok();
        }
    }
}

