/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.volume.zip;

import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

class ZipCreator
implements Volume.Creator {
    private static final Logger logger = Logger.getLogger(ZipCreator.class.getName());
    private static final String UTF_8 = "UTF-8";
    private final ZipArchiveOutputStream zipStream;
    private final Path zipPath;
    private boolean closed = false;
    private int fileCount = 0;

    ZipCreator(Path zip) throws IOException {
        this.zipPath = (Path)Preconditions.checkNotNull((Object)zip);
        Preconditions.checkArgument((!Files.exists(this.zipPath, new LinkOption[0]) ? 1 : 0) != 0, (Object)"zip file exists");
        String string = String.valueOf(this.zipPath);
        logger.finer(new StringBuilder(30 + String.valueOf(string).length()).append("Creating zip volume for path: ").append(string).toString());
        this.zipStream = new ZipArchiveOutputStream(Files.newOutputStream(this.zipPath, StandardOpenOption.CREATE_NEW));
        this.zipStream.setEncoding(UTF_8);
        this.zipStream.setUseZip64(Zip64Mode.AsNeeded);
    }

    @Override
    public void addFile(Path file, String pathInVolume, @Nullable BasicFileAttributes attrs) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Volume closed");
        if (attrs == null) {
            attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        }
        if (attrs.isSymbolicLink()) {
            this.copySymlink(file, pathInVolume);
        } else if (attrs.isDirectory()) {
            this.copyDirectory(pathInVolume);
        } else {
            this.copyRegularFile(file, pathInVolume);
        }
        ++this.fileCount;
    }

    private void copySymlink(Path file, String filenameInZip) throws IOException {
        String string = String.valueOf(file);
        logger.finer(new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(filenameInZip).length()).append("Adding symlink: ").append(string).append(" with filename: ").append(filenameInZip).toString());
        Path symlinkTarget = Files.readSymbolicLink(file);
        ZipArchiveEntry entry = new ZipArchiveEntry(filenameInZip);
        entry.setUnixMode(entry.getUnixMode() | 0xA000);
        this.zipStream.putArchiveEntry((ArchiveEntry)entry);
        this.zipStream.write(symlinkTarget.toString().getBytes(StandardCharsets.UTF_8));
        this.zipStream.closeArchiveEntry();
    }

    private void copyDirectory(String filenameInZip) throws IOException {
        String string = String.valueOf(filenameInZip);
        logger.finer(string.length() != 0 ? "Adding directory: ".concat(string) : new String("Adding directory: "));
        ZipArchiveEntry entry = new ZipArchiveEntry(String.valueOf(filenameInZip).concat("/"));
        entry.setUnixMode(entry.getUnixMode() | 0x4000);
        this.zipStream.putArchiveEntry((ArchiveEntry)entry);
        this.zipStream.closeArchiveEntry();
    }

    private void copyRegularFile(Path file, String filenameInZip) throws IOException {
        String string = String.valueOf(file);
        logger.finer(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(filenameInZip).length()).append("Adding file: ").append(string).append(" with filename: ").append(filenameInZip).toString());
        ZipArchiveEntry entry = new ZipArchiveEntry(filenameInZip);
        this.zipStream.putArchiveEntry((ArchiveEntry)entry);
        Files.copy(file, (OutputStream)this.zipStream);
        this.zipStream.closeArchiveEntry();
    }

    @Override
    public int getFileCount() {
        return this.fileCount;
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Volume already closed");
        String string = String.valueOf(this.zipPath);
        logger.finer(new StringBuilder(30 + String.valueOf(string).length()).append("Closing zip creator for path: ").append(string).toString());
        this.zipStream.close();
        this.closed = true;
    }
}

