/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.scope;

import com.google.jenkins.plugins.persistentmaster.scope.Scope;
import com.google.jenkins.plugins.persistentmaster.volume.ForwardingVolumeCreator;
import com.google.jenkins.plugins.persistentmaster.volume.ForwardingVolumeEntry;
import com.google.jenkins.plugins.persistentmaster.volume.ForwardingVolumeExtractor;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiScope
implements Scope {
    private final List<SubScope> subScopes = new LinkedList<SubScope>();

    public void addSubScope(Scope scope, String volumePrefix) {
        this.subScopes.add(new SubScope(scope, volumePrefix));
    }

    @Override
    public void addFiles(Path jenkinsHome, Volume.Creator creator, Set<String> existingFileMetadata) throws IOException {
        for (final SubScope subScope : this.subScopes) {
            subScope.getScope().addFiles(jenkinsHome, new ForwardingVolumeCreator(creator){

                @Override
                public void addFile(Path file, String pathInVolume, BasicFileAttributes attrs) throws IOException {
                    String string = String.valueOf(subScope.getVolumePrefix());
                    String string2 = String.valueOf(pathInVolume);
                    super.addFile(file, string2.length() != 0 ? string.concat(string2) : new String(string), attrs);
                }
            }, existingFileMetadata);
        }
    }

    @Override
    public void extractFiles(Path jenkinsHome, Volume.Extractor extractor, boolean overwrite, Map<String, Boolean> existingFileMetadataMap) throws IOException {
        for (final SubScope subScope : this.subScopes) {
            subScope.getScope().extractFiles(jenkinsHome, new ForwardingVolumeExtractor(extractor){

                @Override
                public Iterator<Volume.Entry> iterator() {
                    return new SubScopeIterator(subScope, super.iterator());
                }
            }, overwrite, existingFileMetadataMap);
        }
    }

    private static class SubScope {
        private final Scope scope;
        private final String volumePrefix;

        private SubScope(Scope scope, String volumePrefix) {
            this.scope = scope;
            this.volumePrefix = volumePrefix;
        }

        public Scope getScope() {
            return this.scope;
        }

        public String getVolumePrefix() {
            return this.volumePrefix;
        }
    }

    private static class SubScopeIterator
    implements Iterator<Volume.Entry> {
        private final SubScope subScope;
        private final Iterator<Volume.Entry> extractorIterator;
        private Volume.Entry next = null;

        private SubScopeIterator(SubScope subScope, Iterator<Volume.Entry> extractorIterator) {
            this.subScope = subScope;
            this.extractorIterator = extractorIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.extractorIterator.hasNext()) {
                this.next = this.extractorIterator.next();
                if (!this.next.getName().startsWith(this.subScope.getVolumePrefix())) continue;
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public Volume.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.next != null);
            try {
                ForwardingVolumeEntry forwardingVolumeEntry = new ForwardingVolumeEntry(this.next){

                    @Override
                    public String getName() {
                        int volumePrefixLength = SubScopeIterator.this.subScope.getVolumePrefix().length();
                        return super.getName().substring(volumePrefixLength);
                    }
                };
                return forwardingVolumeEntry;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
            this.extractorIterator.remove();
        }
    }
}

