/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster;

import com.google.jenkins.plugins.persistentmaster.PersistentMasterAsyncPeriodicWork;
import com.google.jenkins.plugins.persistentmaster.PersistentMasterPlugin;
import hudson.Extension;
import hudson.model.RestartListener;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class PersistentMasterRestartListener
extends RestartListener {
    private static final Logger LOGGER = Logger.getLogger(PersistentMasterRestartListener.class.getName());
    private PersistentMasterPlugin plugin = null;
    private PersistentMasterAsyncPeriodicWork work = null;

    public static PersistentMasterRestartListener getInstance() {
        return (PersistentMasterRestartListener)((Object)Jenkins.getActiveInstance().getExtensionList(RestartListener.class).get(PersistentMasterRestartListener.class));
    }

    public void onRestart() {
        this.plugin = PersistentMasterPlugin.getInstance();
        if (this.plugin == null) {
            LOGGER.warning("Persistent Master Plugin instance missing when attempting backup at restart time.");
            return;
        }
        this.work = PersistentMasterAsyncPeriodicWork.getInstance();
        if (this.work == null) {
            LOGGER.warning("Persistent Master Backup Worker instance missing when attempting backup at restart time.");
            return;
        }
        if (this.plugin.isLoaded() && this.plugin.getEnableBackup() && !this.plugin.isSkipBackupOnNextRestart()) {
            this.work.createBackup(this.plugin, this.work.shouldCreateFullBackup(this.plugin));
        }
    }

    public boolean isReadyToRestart() {
        return true;
    }
}

