/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster;

import com.google.jenkins.plugins.persistentmaster.PersistentMasterAsyncPeriodicWork;
import com.google.jenkins.plugins.persistentmaster.PersistentMasterJenkinsModule;
import com.google.jenkins.plugins.persistentmaster.PersistentMasterMainModule;
import com.google.jenkins.plugins.persistentmaster.backup.BackupProcedure;
import com.google.jenkins.plugins.persistentmaster.history.KeepAllBackupHistory;
import com.google.jenkins.plugins.persistentmaster.scope.ConfigurableScope;
import com.google.jenkins.plugins.persistentmaster.scope.DefaultBackupScope;
import com.google.jenkins.plugins.persistentmaster.scope.FilteringScope;
import com.google.jenkins.plugins.persistentmaster.scope.IncrementalScope;
import com.google.jenkins.plugins.persistentmaster.scope.MultiScope;
import com.google.jenkins.plugins.persistentmaster.storage.AbstractStorageProvider;
import com.google.jenkins.plugins.persistentmaster.storage.IncrementalBackupStorage;
import com.google.jenkins.plugins.persistentmaster.storage.LocalFileStorageProvider;
import com.google.jenkins.plugins.persistentmaster.storage.Storage;
import com.google.jenkins.plugins.persistentmaster.trigger.BackupTrigger;
import hudson.DescriptorExtensionList;
import hudson.Plugin;
import hudson.StructuredForm;
import hudson.model.Descriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.kohsuke.stapler.StaplerRequest;

public class PersistentMasterPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(PersistentMasterPlugin.class.getName());
    private static final String SCRATCH_DIRECTORY = "backup-tmp";
    private static final String INCREMENTAL_BACKUP_NAME_SUFFIX = "-incremental";
    private static final int DEFAULT_FULL_BACKUP_INTERVAL_HOURS = 1;
    private static final int DEFAULT_INCREMENTAL_BACKUP_INTERVAL_MINUTES = 3;
    private boolean enableBackup = false;
    private boolean enableAutoRestore = false;
    private boolean restoreOverwritesData = false;
    private int fullBackupIntervalHours = 1;
    private int incrementalBackupIntervalMinutes = 3;
    private AbstractStorageProvider storageProvider = new LocalFileStorageProvider();
    private List<ConfigurableScope> backupScopes = new ArrayList<ConfigurableScope>(Arrays.asList(new DefaultBackupScope()));
    private final transient AtomicBoolean backupOrRestoreInProgress = new AtomicBoolean(true);
    private final transient AtomicBoolean manualBackupRequested = new AtomicBoolean(false);
    private final transient PersistentMasterJenkinsModule module = new PersistentMasterJenkinsModule();
    private transient BackupProcedure fullBackupProcedure;
    private transient boolean loaded = false;
    private transient DateTime lastBackupTime;
    private transient DateTime lastFullBackupTime;
    private transient boolean lastBackupFailed = false;
    private transient boolean skipBackupOnNextRestart = false;

    public static PersistentMasterPlugin getInstance() {
        return (PersistentMasterPlugin)Jenkins.getActiveInstance().getPlugin(PersistentMasterPlugin.class);
    }

    public PersistentMasterPlugin() {
        this.updateBackupProcedure();
    }

    public boolean getRestoreOverwritesData() {
        return this.restoreOverwritesData;
    }

    public DescriptorExtensionList<AbstractStorageProvider, AbstractStorageProvider.StorageProviderDescriptor> getAllProviders() {
        return AbstractStorageProvider.getAllDescriptors();
    }

    public DescriptorExtensionList<ConfigurableScope, ConfigurableScope.ConfigurableScopeDescriptor> getAllScopes() {
        return ConfigurableScope.getAllDescriptors();
    }

    public Iterable<ConfigurableScope> getBackupScopes() {
        return this.backupScopes;
    }

    private void updateBackupProcedure() {
        this.module.setFullBackupIntervalHours(this.fullBackupIntervalHours);
        this.module.setIncrementalBackupIntervalMinutes(this.incrementalBackupIntervalMinutes);
        this.module.setStorage(this.storageProvider.getStorage());
        MultiScope combinedScope = new MultiScope();
        for (ConfigurableScope scope : this.backupScopes) {
            combinedScope.addSubScope(scope, String.valueOf(scope.getScopeName()).concat("/"));
        }
        this.module.setScope(combinedScope);
        if (this.enableBackup) {
            this.fullBackupProcedure = new BackupProcedure(this.module.getVolume(), this.module.getScope(), this.module.getStorage(), this.module.getBackupHistory(), this.calculateJenkinsHome(), this.getScratchDirectory(), null);
            this.lastBackupTime = PersistentMasterPlugin.calculateLastBackupTime(this.module.getStorage());
        }
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        boolean shouldEnableBackup = formData.optBoolean("enableBackup", false);
        boolean shouldEnableAutoRestore = formData.optBoolean("enableAutoRestore", false);
        this.restoreOverwritesData = formData.optBoolean("restoreOverwritesData", false);
        this.fullBackupIntervalHours = formData.optInt("fullBackupIntervalHours", 1);
        this.incrementalBackupIntervalMinutes = formData.optInt("incrementalBackupIntervalMinutes", 3);
        String providerClazz = formData.optJSONObject("storageProvider").getString("stapler-class");
        Descriptor descriptor = Jenkins.getActiveInstance().getDescriptor(providerClazz);
        AbstractStorageProvider previousStorageProvider = this.storageProvider;
        this.storageProvider = (AbstractStorageProvider)descriptor.newInstance(req, formData.optJSONObject("storageProvider"));
        ArrayList<ConfigurableScope> newScopes = new ArrayList<ConfigurableScope>();
        for (JSONObject o : StructuredForm.toList((JSONObject)formData, (String)"backupScopeList")) {
            Descriptor scopeDescriptor = Jenkins.getActiveInstance().getDescriptor(o.getString("stapler-class"));
            ConfigurableScope scope = (ConfigurableScope)scopeDescriptor.newInstance(req, o);
            newScopes.add(scope);
        }
        this.backupScopes = newScopes;
        if ((shouldEnableBackup || shouldEnableAutoRestore) && !this.storageProvider.isValid()) {
            String string = String.valueOf(this.storageProvider.getDescriptor().getDisplayName());
            logger.severe(string.length() != 0 ? "Storage provider configuration incorrect, not enabling: ".concat(string) : new String("Storage provider configuration incorrect, not enabling: "));
            shouldEnableBackup = false;
            shouldEnableAutoRestore = false;
        }
        if (!previousStorageProvider.equals(this.storageProvider)) {
            this.lastBackupTime = null;
            this.lastFullBackupTime = null;
            this.lastBackupFailed = false;
        }
        this.enableBackup = shouldEnableBackup;
        this.enableAutoRestore = shouldEnableAutoRestore;
        this.updateBackupProcedure();
        this.save();
    }

    public void start() throws Exception {
        this.load();
        this.updateBackupProcedure();
        this.save();
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isSkipBackupOnNextRestart() {
        return this.skipBackupOnNextRestart;
    }

    public void setSkipBackupOnNextRestart(boolean skipBackup) {
        this.skipBackupOnNextRestart = skipBackup;
    }

    public AbstractStorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    public boolean getEnableBackup() {
        return this.enableBackup;
    }

    public boolean getEnableAutoRestore() {
        return this.enableAutoRestore;
    }

    public int getFullBackupIntervalHours() {
        return this.fullBackupIntervalHours;
    }

    public int getIncrementalBackupIntervalMinutes() {
        return this.incrementalBackupIntervalMinutes;
    }

    public Path calculateJenkinsHome() {
        return Jenkins.getActiveInstance().getRootDir().toPath();
    }

    public BackupTrigger getFullBackupTrigger() {
        return this.module.getFullBackupTrigger();
    }

    public BackupTrigger getIncrementalBackupTrigger() {
        return this.module.getIncrementalBackupTrigger();
    }

    public boolean isBackupOrRestoreInProgress() {
        return this.backupOrRestoreInProgress.get();
    }

    public synchronized boolean beginBackupOrRestore() {
        return this.backupOrRestoreInProgress.compareAndSet(false, true);
    }

    public synchronized void endBackupOrRestore() {
        this.backupOrRestoreInProgress.set(false);
    }

    @Nullable
    public DateTime getLastBackupTime() {
        return this.lastBackupTime;
    }

    public void setLastBackupTime(DateTime lastBackupTime) {
        this.lastBackupTime = lastBackupTime;
    }

    @Nullable
    public DateTime getLastFullBackupTime() {
        return this.lastFullBackupTime;
    }

    public void setLastFullBackupTime(DateTime lastFullBackupTime) {
        this.lastFullBackupTime = lastFullBackupTime;
    }

    public boolean isManualBackupRequested() {
        return this.manualBackupRequested.get();
    }

    public void setManualBackupRequested(boolean requested) {
        this.manualBackupRequested.set(requested);
    }

    public BackupProcedure getFullBackupProcedure() {
        return this.fullBackupProcedure;
    }

    public PersistentMasterMainModule getPersistentMasterMainModule() {
        return this.module;
    }

    public Path getScratchDirectory() {
        return this.calculateJenkinsHome().resolve(SCRATCH_DIRECTORY);
    }

    public BackupProcedure getIncrementalBackupProcedure() {
        FilteringScope filteringScope = new FilteringScope(new IncrementalScope(this.module.getScope(), FileTime.fromMillis(this.lastBackupTime.getMillis())));
        filteringScope.addExclusion(PersistentMasterAsyncPeriodicWork.getLogFileName());
        return new BackupProcedure(this.module.getVolume(), filteringScope, new IncrementalBackupStorage(this.module.getStorage()), new KeepAllBackupHistory(), this.calculateJenkinsHome(), this.getScratchDirectory(), INCREMENTAL_BACKUP_NAME_SUFFIX);
    }

    public void setLastBackupFailed(boolean lastBackupFailed) {
        this.lastBackupFailed = lastBackupFailed;
    }

    public boolean isLastBackupFailed() {
        return this.lastBackupFailed;
    }

    private static DateTime calculateLastBackupTime(Storage storage) {
        List<String> lastBackupFiles;
        try {
            lastBackupFiles = storage.findLatestBackup();
        }
        catch (IOException e) {
            return null;
        }
        if (lastBackupFiles != null && !lastBackupFiles.isEmpty()) {
            return new DateTime(DateTimeZone.UTC);
        }
        return null;
    }

    public String toString() {
        String string = String.valueOf("PersistentMasterPlugin{enableBackup=");
        boolean bl = this.enableBackup;
        String string2 = String.valueOf(this.storageProvider);
        return new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(bl).append(", storageProvider=").append(string2).append("}").toString();
    }
}

