/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster;

import com.google.jenkins.plugins.persistentmaster.PersistentMasterMainModule;
import com.google.jenkins.plugins.persistentmaster.history.BackupHistory;
import com.google.jenkins.plugins.persistentmaster.history.KeepLatestBackupHistory;
import com.google.jenkins.plugins.persistentmaster.trigger.BackupTrigger;
import com.google.jenkins.plugins.persistentmaster.trigger.BackupTriggers;
import com.google.jenkins.plugins.persistentmaster.trigger.ConfigFileChangedBackupTrigger;
import com.google.jenkins.plugins.persistentmaster.trigger.FailureBackupTrigger;
import com.google.jenkins.plugins.persistentmaster.trigger.PeriodicBackupTrigger;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.ReadablePeriod;

public class PersistentMasterJenkinsModule
extends PersistentMasterMainModule {
    private ReadablePeriod fullBackupInterval = Hours.hours((int)1);
    private ReadablePeriod incrementalBackupInterval = Minutes.minutes((int)3);
    private final BackupHistory backupHistory = new KeepLatestBackupHistory();
    private final BackupTrigger fullBackupTrigger = BackupTriggers.or(new FailureBackupTrigger(), new PeriodicBackupTrigger(this.fullBackupInterval), new BackupTrigger[0]);
    private final BackupTrigger incrementalBackupTrigger = BackupTriggers.or(new ConfigFileChangedBackupTrigger(), new PeriodicBackupTrigger(this.incrementalBackupInterval), new BackupTrigger[0]);

    public BackupHistory getBackupHistory() {
        return this.backupHistory;
    }

    public BackupTrigger getFullBackupTrigger() {
        return this.fullBackupTrigger;
    }

    public BackupTrigger getIncrementalBackupTrigger() {
        return this.incrementalBackupTrigger;
    }

    public void setFullBackupIntervalHours(int hours) {
        this.fullBackupInterval = Hours.hours((int)hours);
    }

    public int getFullBackupIntervalHours() {
        return this.fullBackupInterval.get(DurationFieldType.hours());
    }

    public void setIncrementalBackupIntervalMinutes(int minutes) {
        this.incrementalBackupInterval = Minutes.minutes((int)minutes);
    }

    public int getIncrementalBackupIntervalMinutes() {
        return this.incrementalBackupInterval.get(DurationFieldType.minutes());
    }
}

