/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_variable_string_parameter;

import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.plugins.global_variable_string_parameter.GlobalNodeProperties;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GlobalVariableStringParameterDefinition
extends StringParameterDefinition {
    private static final long serialVersionUID = 1L;
    private static final Pattern pattern = Pattern.compile("\\$\\{(.+)\\}|\\$(.+)\\s?");

    @DataBoundConstructor
    public GlobalVariableStringParameterDefinition(String name, String defaultValue, String description) {
        super(name, defaultValue, description);
    }

    public ParameterValue createValue(String value) {
        return new StringParameterValue(super.getName(), GlobalVariableStringParameterDefinition.replaceGlobalVars(value), super.getDescription());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        jo.put("value", (Object)GlobalVariableStringParameterDefinition.replaceGlobalVars(jo.getString("value")));
        return (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
    }

    public StringParameterValue getDefaultParameterValue() {
        return new StringParameterValue(super.getName(), GlobalVariableStringParameterDefinition.replaceGlobalVars(super.getDefaultValue()), super.getDescription());
    }

    public static boolean globalVarExists(String str) {
        Matcher m = pattern.matcher(str);
        while (m.find()) {
            String globalVariable = m.group(1) != null ? m.group(1) : m.group(2);
            String globalValue = GlobalNodeProperties.getValue(globalVariable);
            if (globalValue == null) continue;
            return true;
        }
        return false;
    }

    public static String replaceGlobalVars(String str) {
        Matcher m = pattern.matcher(str);
        while (m.find()) {
            String globalVariable = m.group(1) != null ? m.group(1) : m.group(2);
            String globalValue = GlobalNodeProperties.getValue(globalVariable);
            if (globalValue == null) continue;
            str = str.replace(m.group(0), globalValue);
        }
        return str;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Global Variable String Parameter";
        }

        public FormValidation doCheckGlobalName(@QueryParameter String value) throws IOException, ServletException {
            if (!value.contains("$") || GlobalVariableStringParameterDefinition.globalVarExists(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("Global Variable " + value.replaceAll("\\$|\\{|\\}", "") + " does not exist"));
        }

        public AutoCompletionCandidates doAutoCompleteGlobalName(@QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            Set<String> propNames = GlobalNodeProperties.getProperties().keySet();
            for (String name : propNames) {
                if (!name.startsWith(value.replaceAll("\\$|\\{|\\}", "")) && !name.startsWith(value)) continue;
                candidates.add("${" + name + "}");
            }
            return candidates;
        }
    }
}

