/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.jenkins.plugin.globalpostscript;

import com.orctom.jenkins.plugin.globalpostscript.GlobalPostScript;
import com.orctom.jenkins.plugin.globalpostscript.runner.GroovyScriptRunner;
import com.orctom.jenkins.plugin.globalpostscript.runner.ShellScriptRunner;
import hudson.model.TaskListener;
import java.io.File;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptExecutor {
    private TaskListener listener;
    private GlobalPostScript.BadgeManager manager;

    public ScriptExecutor(TaskListener listener, GlobalPostScript.BadgeManager manager) {
        this.listener = listener;
        this.manager = manager;
    }

    public void execute(File scriptFile, Map<String, String> variables) {
        this.println("[INFO]");
        this.println("[INFO] -----------------------------------------------------");
        this.println("[INFO] Global Post Script");
        this.println("[INFO] -----------------------------------------------------");
        String ext = FileUtils.getExtension((String)scriptFile.getAbsolutePath());
        if ("groovy".equalsIgnoreCase(ext) || "gvy".equalsIgnoreCase(ext) || "gs".equalsIgnoreCase(ext) || "gsh".equalsIgnoreCase(ext)) {
            new GroovyScriptRunner().run(scriptFile, variables, this.manager, this.listener);
        } else if ("sh".equalsIgnoreCase(ext) || "bat".equalsIgnoreCase(ext)) {
            new ShellScriptRunner().run(scriptFile, variables, this.manager, this.listener);
        } else {
            this.println("[ERROR] Script type not supported: " + ext + " | " + scriptFile.getName());
        }
        this.println("[INFO] -----------------------------------------------------");
    }

    private void println(String message) {
        this.listener.getLogger().println(message);
    }
}

