/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.workflow;

import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.util.CommitStatusUpdater;
import com.dabsquared.gitlabjenkins.workflow.PendingBuildsAction;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class GitLabBuildsStep
extends Step {
    private List<String> builds;

    @DataBoundConstructor
    public GitLabBuildsStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new GitLabBuildStepExecution(context, this);
    }

    @DataBoundSetter
    public void setBuilds(List<String> builds) {
        if (builds != null && builds.size() == 1) {
            this.builds = new ArrayList<String>();
            for (String build : builds.get(0).split(",")) {
                if (build.isEmpty()) continue;
                this.builds.add(build.trim());
            }
        } else {
            this.builds = builds;
        }
    }

    public List<String> getBuilds() {
        return this.builds;
    }

    public static class GitLabBuildStepExecution
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private final transient Run<?, ?> run;
        private final transient GitLabBuildsStep step;
        private BodyExecution body;

        GitLabBuildStepExecution(StepContext context, GitLabBuildsStep step) throws Exception {
            super(context);
            this.step = step;
            this.run = (Run)context.get(Run.class);
        }

        public boolean start() throws Exception {
            this.body = this.getContext().newBodyInvoker().withCallback(new BodyExecutionCallback(){

                public void onStart(StepContext context) {
                    for (String name : step.builds) {
                        CommitStatusUpdater.updateCommitStatus(run, this.getTaskListener(context), BuildState.pending, name);
                    }
                    run.addAction((Action)new PendingBuildsAction(new ArrayList<String>(step.builds)));
                }

                public void onSuccess(StepContext context, Object result) {
                    TaskListener taskListener;
                    PendingBuildsAction action = (PendingBuildsAction)run.getAction(PendingBuildsAction.class);
                    if (action != null && !action.getBuilds().isEmpty() && (taskListener = this.getTaskListener(context)) != null) {
                        taskListener.getLogger().println("There are still pending GitLab builds. Please check your configuration");
                    }
                    context.onSuccess(result);
                }

                public void onFailure(StepContext context, Throwable t) {
                    PendingBuildsAction action = (PendingBuildsAction)run.getAction(PendingBuildsAction.class);
                    if (action != null) {
                        BuildState state = t instanceof FlowInterruptedException ? BuildState.canceled : BuildState.failed;
                        for (String name : action.getBuilds()) {
                            CommitStatusUpdater.updateCommitStatus(run, this.getTaskListener(context), state, name);
                        }
                    }
                    context.onFailure(t);
                }
            }).start();
            return false;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            if (this.body != null) {
                PendingBuildsAction action = (PendingBuildsAction)this.run.getAction(PendingBuildsAction.class);
                if (action != null) {
                    for (String name : action.getBuilds()) {
                        CommitStatusUpdater.updateCommitStatus(this.run, null, BuildState.canceled, name);
                    }
                }
                this.body.cancel(cause);
            }
        }

        private TaskListener getTaskListener(StepContext context) {
            if (!context.isReady()) {
                return null;
            }
            try {
                return (TaskListener)context.get(TaskListener.class);
            }
            catch (Exception x) {
                return null;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Notify gitlab about pending builds";
        }

        public String getFunctionName() {
            return "gitlabBuilds";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, TaskListener.class, Run.class);
            return Collections.unmodifiableSet(context);
        }
    }
}

