/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.publisher;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Awardable;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import com.dabsquared.gitlabjenkins.publisher.MergeRequestNotifier;
import com.dabsquared.gitlabjenkins.publisher.Messages;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitLabVotePublisher
extends MergeRequestNotifier {
    private static final Logger LOGGER = Logger.getLogger(GitLabVotePublisher.class.getName());

    @DataBoundConstructor
    public GitLabVotePublisher() {
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Override
    protected void perform(Run<?, ?> build, TaskListener listener, GitLabClient client, MergeRequest mergeRequest) {
        boolean alreadyAwarded = false;
        try {
            Integer userId = client.getCurrentUser().getId();
            for (Awardable award : client.getMergeRequestEmoji(mergeRequest)) {
                if (award.getName().equals(this.getResultIcon(!this.isSuccessful(build.getResult())))) {
                    if (!award.getUser().getId().equals(userId)) continue;
                    client.deleteMergeRequestEmoji(mergeRequest, award.getId());
                    continue;
                }
                if (!award.getName().equals(this.getResultIcon(this.isSuccessful(build.getResult()))) || !award.getUser().getId().equals(userId)) continue;
                alreadyAwarded = true;
            }
        }
        catch (ProcessingException | WebApplicationException e) {
            listener.getLogger().printf("Failed to remove vote on Merge Request for project '%s': %s%n", mergeRequest.getProjectId(), e.getMessage());
            LOGGER.log(Level.SEVERE, String.format("Failed to remove vote on Merge Request for project '%s'", mergeRequest.getProjectId()), e);
        }
        try {
            if (!alreadyAwarded) {
                client.awardMergeRequestEmoji(mergeRequest, this.getResultIcon(build.getResult()));
            }
        }
        catch (NotFoundException e) {
            String message = String.format("Failed to add vote on Merge Request for project '%s'%nGot unexpected 404, are you using the wrong API version or trying to vote on your own merge request?", mergeRequest.getProjectId());
            listener.getLogger().println(message);
            LOGGER.log(Level.WARNING, message, e);
        }
        catch (ProcessingException | WebApplicationException e) {
            listener.getLogger().printf("Failed to add vote on Merge Request for project '%s': %s%n", mergeRequest.getProjectId(), e.getMessage());
            LOGGER.log(Level.SEVERE, String.format("Failed to add vote on Merge Request for project '%s'", mergeRequest.getProjectId()), e);
        }
    }

    private boolean isSuccessful(Result result) {
        return result == Result.SUCCESS;
    }

    private String getResultIcon(Result result) {
        return this.getResultIcon(this.isSuccessful(result));
    }

    private String getResultIcon(boolean success) {
        if (success) {
            return "thumbsup";
        }
        return "thumbsdown";
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GitLabVotePublisher_DisplayName();
        }
    }
}

