/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.publisher;

import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.publisher.Messages;
import com.dabsquared.gitlabjenkins.util.CommitStatusUpdater;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GitLabCommitStatusPublisher
extends Notifier
implements MatrixAggregatable {
    private String name;
    private boolean markUnstableAsSuccess;

    @DataBoundConstructor
    public GitLabCommitStatusPublisher(String name, boolean markUnstableAsSuccess) {
        this.name = name;
        this.markUnstableAsSuccess = markUnstableAsSuccess;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        CommitStatusUpdater.updateCommitStatus(build, (TaskListener)listener, BuildState.running, this.name);
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Result buildResult = build.getResult();
        if (buildResult == Result.SUCCESS || buildResult == Result.UNSTABLE && this.markUnstableAsSuccess) {
            CommitStatusUpdater.updateCommitStatus(build, (TaskListener)listener, BuildState.success, this.name);
        } else if (buildResult == Result.ABORTED) {
            CommitStatusUpdater.updateCommitStatus(build, (TaskListener)listener, BuildState.canceled, this.name);
        } else {
            CommitStatusUpdater.updateCommitStatus(build, (TaskListener)listener, BuildState.failed, this.name);
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMarkUnstableAsSuccess() {
        return this.markUnstableAsSuccess;
    }

    protected GitLabCommitStatusPublisher readResolve() {
        if (this.name == null) {
            this.name = "jenkins";
        }
        return this;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                GitLabCommitStatusPublisher.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                return super.endBuild();
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GitLabCommitStatusPublisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/gitlab-plugin/help/help-send-result-to-gitlab.html";
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)Messages.name_required());
            }
            return FormValidation.ok();
        }
    }
}

