/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.gitlab.api.impl;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.impl.GitLabApiProxy;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Awardable;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Branch;
import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Group;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Label;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import com.dabsquared.gitlabjenkins.gitlab.api.model.OrderType;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Pipeline;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Project;
import com.dabsquared.gitlabjenkins.gitlab.api.model.ProjectHook;
import com.dabsquared.gitlabjenkins.gitlab.api.model.ProjectVisibilityType;
import com.dabsquared.gitlabjenkins.gitlab.api.model.SortType;
import com.dabsquared.gitlabjenkins.gitlab.api.model.User;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.State;
import java.util.List;
import java.util.function.Function;

final class ResteasyGitLabClient
implements GitLabClient {
    private final String hostUrl;
    private final GitLabApiProxy api;
    private final Function<MergeRequest, Integer> mergeRequestIdProvider;

    ResteasyGitLabClient(String hostUrl, GitLabApiProxy api, Function<MergeRequest, Integer> mergeRequestIdProvider) {
        this.hostUrl = hostUrl;
        this.api = api;
        this.mergeRequestIdProvider = mergeRequestIdProvider;
    }

    @Override
    public final String getHostUrl() {
        return this.hostUrl;
    }

    @Override
    public List<Group> getGroups() {
        return this.api.getGroups(true, false, OrderType.path.name(), SortType.asc.name());
    }

    @Override
    public List<Group> getGroups(Boolean allAvailable, Boolean topLevelOnly, OrderType orderBy, SortType sort) {
        return this.api.getGroups(allAvailable, topLevelOnly, orderBy == null ? OrderType.path.name() : orderBy.name(), sort == null ? SortType.asc.name() : sort.name());
    }

    @Override
    public List<Project> getGroupProjects(String groupId) {
        return this.api.getGroupProjects(groupId, Boolean.FALSE, null, OrderType.path.name(), SortType.asc.name());
    }

    @Override
    public List<Project> getGroupProjects(String groupId, Boolean includeSubgroups, ProjectVisibilityType visibility, OrderType orderBy, SortType sort) {
        return this.api.getGroupProjects(groupId, includeSubgroups == null ? Boolean.FALSE : includeSubgroups, visibility == null ? null : visibility.getValue(), orderBy == null ? OrderType.path.name() : orderBy.name(), sort == null ? SortType.asc.name() : sort.name());
    }

    @Override
    public Project createProject(String projectName) {
        return this.api.createProject(projectName);
    }

    @Override
    public MergeRequest createMergeRequest(Integer projectId, String sourceBranch, String targetBranch, String title) {
        return this.api.createMergeRequest(projectId, sourceBranch, targetBranch, title);
    }

    @Override
    public Project getProject(String projectName) {
        return this.api.getProject(projectName);
    }

    @Override
    public Project updateProject(String projectId, String name, String path) {
        return this.api.updateProject(projectId, name, path);
    }

    @Override
    public void deleteProject(String projectId) {
        this.api.deleteProject(projectId);
    }

    @Override
    public List<ProjectHook> getProjectHooks(String projectName) {
        return this.api.getProjectHooks(projectName);
    }

    @Override
    public void addProjectHook(String projectId, String url, Boolean pushEvents, Boolean mergeRequestEvents, Boolean noteEvents) {
        this.api.addProjectHook(projectId, url, pushEvents, mergeRequestEvents, noteEvents);
    }

    @Override
    public void addProjectHook(String projectId, String url, String secretToken, Boolean pushEvents, Boolean mergeRequestEvents, Boolean noteEvents) {
        this.api.addProjectHook(projectId, url, secretToken, pushEvents, mergeRequestEvents, noteEvents);
    }

    @Override
    public void changeBuildStatus(String projectId, String sha, BuildState state, String ref, String context, String targetUrl, String description) {
        this.api.changeBuildStatus(projectId, sha, state, ref, context, targetUrl, description);
    }

    @Override
    public void changeBuildStatus(Integer projectId, String sha, BuildState state, String ref, String context, String targetUrl, String description) {
        this.api.changeBuildStatus(projectId, sha, state, ref, context, targetUrl, description);
    }

    @Override
    public void getCommit(String projectId, String sha) {
        this.api.getCommit(projectId, sha);
    }

    @Override
    public void acceptMergeRequest(MergeRequest mr, String mergeCommitMessage, Boolean shouldRemoveSourceBranch) {
        this.api.acceptMergeRequest(mr.getProjectId(), this.mergeRequestIdProvider.apply(mr), mergeCommitMessage, shouldRemoveSourceBranch);
    }

    @Override
    public void createMergeRequestNote(MergeRequest mr, String body) {
        this.api.createMergeRequestNote(mr.getProjectId(), this.mergeRequestIdProvider.apply(mr), body);
    }

    @Override
    public List<Awardable> getMergeRequestEmoji(MergeRequest mr) {
        return this.api.getMergeRequestEmoji(mr.getProjectId(), this.mergeRequestIdProvider.apply(mr));
    }

    @Override
    public void awardMergeRequestEmoji(MergeRequest mr, String name) {
        this.api.awardMergeRequestEmoji(mr.getProjectId(), this.mergeRequestIdProvider.apply(mr), name);
    }

    @Override
    public void deleteMergeRequestEmoji(MergeRequest mr, Integer awardId) {
        this.api.deleteMergeRequestEmoji(mr.getProjectId(), this.mergeRequestIdProvider.apply(mr), awardId);
    }

    @Override
    public List<MergeRequest> getMergeRequests(String projectId, State state, int page, int perPage) {
        return this.api.getMergeRequests(projectId, state, page, perPage);
    }

    @Override
    public List<Branch> getBranches(String projectId) {
        return this.api.getBranches(projectId);
    }

    @Override
    public Branch getBranch(String projectId, String branch) {
        return this.api.getBranch(projectId, branch);
    }

    @Override
    public User getCurrentUser() {
        return this.api.getCurrentUser();
    }

    @Override
    public User addUser(String email, String username, String name, String password) {
        return this.api.addUser(email, username, name, password);
    }

    @Override
    public User updateUser(String userId, String email, String username, String name, String password) {
        return this.api.updateUser(userId, email, username, name, password);
    }

    @Override
    public List<Label> getLabels(String projectId) {
        return this.api.getLabels(projectId);
    }

    @Override
    public List<Pipeline> getPipelines(String projectName) {
        return this.api.getPipelines(projectName);
    }
}

