/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.handler.note;

import com.dabsquared.gitlabjenkins.cause.CauseData;
import com.dabsquared.gitlabjenkins.cause.CauseDataBuilder;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.MergeRequestLabel;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.NoteHook;
import com.dabsquared.gitlabjenkins.trigger.exception.NoRevisionToBuildException;
import com.dabsquared.gitlabjenkins.trigger.filter.BranchFilter;
import com.dabsquared.gitlabjenkins.trigger.filter.MergeRequestLabelFilter;
import com.dabsquared.gitlabjenkins.trigger.handler.AbstractWebHookTriggerHandler;
import com.dabsquared.gitlabjenkins.trigger.handler.builder.generated.BuildStatusUpdateBuilder;
import com.dabsquared.gitlabjenkins.trigger.handler.note.NoteHookTriggerHandler;
import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

class NoteHookTriggerHandlerImpl
extends AbstractWebHookTriggerHandler<NoteHook>
implements NoteHookTriggerHandler {
    private static final Logger LOGGER = Logger.getLogger(NoteHookTriggerHandlerImpl.class.getName());
    private final String noteRegex;

    NoteHookTriggerHandlerImpl(String noteRegex) {
        this.noteRegex = noteRegex;
    }

    @Override
    public void handle(Job<?, ?> job, NoteHook hook, boolean ciSkip, BranchFilter branchFilter, MergeRequestLabelFilter mergeRequestLabelFilter) {
        if (this.isValidTriggerPhrase(hook.getObjectAttributes().getNote())) {
            super.handle(job, hook, ciSkip, branchFilter, mergeRequestLabelFilter);
        }
    }

    @Override
    protected boolean isCiSkip(NoteHook hook) {
        return hook.getMergeRequest() != null && hook.getMergeRequest().getDescription() != null && hook.getMergeRequest().getDescription().contains("[ci-skip]");
    }

    @Override
    protected String getSourceBranch(NoteHook hook) {
        return hook.getMergeRequest() == null ? null : hook.getMergeRequest().getSourceBranch();
    }

    @Override
    protected String getTargetBranch(NoteHook hook) {
        return hook.getMergeRequest() == null ? null : hook.getMergeRequest().getTargetBranch();
    }

    @Override
    protected String getTriggerType() {
        return "note";
    }

    @Override
    protected CauseData retrieveCauseData(NoteHook hook) {
        return CauseDataBuilder.causeData().withActionType(CauseData.ActionType.NOTE).withSourceProjectId(hook.getMergeRequest().getSourceProjectId()).withTargetProjectId(hook.getMergeRequest().getTargetProjectId()).withBranch(hook.getMergeRequest().getSourceBranch()).withSourceBranch(hook.getMergeRequest().getSourceBranch()).withUserName(hook.getMergeRequest().getLastCommit().getAuthor().getName()).withUserEmail(hook.getMergeRequest().getLastCommit().getAuthor().getEmail()).withSourceRepoHomepage(hook.getMergeRequest().getSource().getHomepage()).withSourceRepoName(hook.getMergeRequest().getSource().getName()).withSourceNamespace(hook.getMergeRequest().getSource().getNamespace()).withSourceRepoUrl(hook.getMergeRequest().getSource().getUrl()).withSourceRepoSshUrl(hook.getMergeRequest().getSource().getSshUrl()).withSourceRepoHttpUrl(hook.getMergeRequest().getSource().getHttpUrl()).withMergeRequestTitle(hook.getMergeRequest().getTitle()).withMergeRequestDescription(hook.getMergeRequest().getDescription()).withMergeRequestId(hook.getMergeRequest().getId()).withMergeRequestIid(hook.getMergeRequest().getIid()).withMergeRequestTargetProjectId(hook.getMergeRequest().getTargetProjectId()).withTargetBranch(hook.getMergeRequest().getTargetBranch()).withTargetRepoName(hook.getMergeRequest().getTarget().getName()).withTargetNamespace(hook.getMergeRequest().getTarget().getNamespace()).withTargetRepoSshUrl(hook.getMergeRequest().getTarget().getSshUrl()).withTargetRepoHttpUrl(hook.getMergeRequest().getTarget().getHttpUrl()).withTriggeredByUser(hook.getMergeRequest().getLastCommit().getAuthor().getName()).withLastCommit(hook.getMergeRequest().getLastCommit().getId()).withTargetProjectUrl(hook.getMergeRequest().getTarget().getWebUrl()).withTriggerPhrase(hook.getObjectAttributes().getNote()).withCommentAuthor(hook.getUser() == null ? null : hook.getUser().getUsername()).withMergeRequestLabels(hook.getMergeRequest().getLabels() == null ? null : hook.getMergeRequest().getLabels().stream().map(MergeRequestLabel::getTitle).collect(Collectors.toList())).build();
    }

    @Override
    protected RevisionParameterAction createRevisionParameter(NoteHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        return new RevisionParameterAction(this.retrieveRevisionToBuild(hook), this.retrieveUrIish(hook));
    }

    @Override
    protected AbstractWebHookTriggerHandler.BuildStatusUpdate retrieveBuildStatusUpdate(NoteHook hook) {
        return BuildStatusUpdateBuilder.buildStatusUpdate().withProjectId(hook.getMergeRequest().getSourceProjectId()).withSha(hook.getMergeRequest().getLastCommit().getId()).withRef(hook.getMergeRequest().getSourceBranch()).build();
    }

    private String retrieveRevisionToBuild(NoteHook hook) throws NoRevisionToBuildException {
        if (hook.getMergeRequest() != null && hook.getMergeRequest().getLastCommit() != null && hook.getMergeRequest().getLastCommit().getId() != null) {
            return hook.getMergeRequest().getLastCommit().getId();
        }
        throw new NoRevisionToBuildException();
    }

    private boolean isValidTriggerPhrase(String note) {
        if (StringUtils.isEmpty((String)this.noteRegex)) {
            return false;
        }
        Pattern pattern = Pattern.compile(this.noteRegex);
        return pattern.matcher(note).matches();
    }
}

