/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.service;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Label;
import com.dabsquared.gitlabjenkins.util.LoggerUtil;
import com.dabsquared.gitlabjenkins.util.ProjectIdUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GitLabProjectLabelsService {
    private static final Logger LOGGER = Logger.getLogger(GitLabProjectLabelsService.class.getName());
    private static transient GitLabProjectLabelsService instance;
    private final Cache<String, List<String>> projectLabelsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.SECONDS).build();

    GitLabProjectLabelsService() {
    }

    public static GitLabProjectLabelsService instance() {
        if (instance == null) {
            instance = new GitLabProjectLabelsService();
        }
        return instance;
    }

    public List<String> getLabels(GitLabClient client, String sourceRepositoryString) {
        Cache<String, List<String>> cache = this.projectLabelsCache;
        synchronized (cache) {
            try {
                return (List)this.projectLabelsCache.get((Object)sourceRepositoryString, (Callable)new LabelNamesLoader(client, sourceRepositoryString));
            }
            catch (ExecutionException e) {
                throw new LabelLoadingException(e);
            }
        }
    }

    private static class LabelNamesLoader
    implements Callable<List<String>> {
        private final GitLabClient client;
        private final String sourceRepository;

        private LabelNamesLoader(GitLabClient client, String sourceRepository) {
            this.client = client;
            this.sourceRepository = sourceRepository;
        }

        @Override
        public List<String> call() throws Exception {
            ArrayList<String> result = new ArrayList<String>();
            String projectId = ProjectIdUtil.retrieveProjectId(this.client, this.sourceRepository);
            for (Label label : this.client.getLabels(projectId)) {
                result.add(label.getName());
            }
            LOGGER.log(Level.FINEST, "found these labels for repo {0} : {1}", LoggerUtil.toArray(this.sourceRepository, result));
            return result;
        }
    }

    public static class LabelLoadingException
    extends RuntimeException {
        LabelLoadingException(Throwable cause) {
            super(cause);
        }
    }
}

