/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.handler;

import com.dabsquared.gitlabjenkins.cause.CauseData;
import com.dabsquared.gitlabjenkins.cause.GitLabWebHookCause;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.WebHook;
import com.dabsquared.gitlabjenkins.trigger.exception.NoRevisionToBuildException;
import com.dabsquared.gitlabjenkins.trigger.filter.BranchFilter;
import com.dabsquared.gitlabjenkins.trigger.filter.MergeRequestLabelFilter;
import com.dabsquared.gitlabjenkins.trigger.handler.PendingBuildsHandler;
import com.dabsquared.gitlabjenkins.trigger.handler.WebHookTriggerHandler;
import com.dabsquared.gitlabjenkins.util.LoggerUtil;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import hudson.scm.SCM;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public abstract class AbstractWebHookTriggerHandler<H extends WebHook>
implements WebHookTriggerHandler<H> {
    private static final Logger LOGGER = Logger.getLogger(AbstractWebHookTriggerHandler.class.getName());
    protected PendingBuildsHandler pendingBuildsHandler = new PendingBuildsHandler();

    @Override
    public void handle(Job<?, ?> job, H hook, boolean ciSkip, BranchFilter branchFilter, MergeRequestLabelFilter mergeRequestLabelFilter) {
        String targetBranch;
        if (ciSkip && this.isCiSkip(hook)) {
            LOGGER.log(Level.INFO, "Skipping due to ci-skip.");
            return;
        }
        String sourceBranch = this.getSourceBranch(hook);
        if (branchFilter.isBranchAllowed(sourceBranch, targetBranch = this.getTargetBranch(hook))) {
            LOGGER.log(Level.INFO, "{0} triggered for {1}.", LoggerUtil.toArray(job.getFullName(), this.getTriggerType()));
            this.cancelPendingBuildsIfNecessary(job, hook);
            this.setCommitStatusPendingIfNecessary(job, hook);
            this.scheduleBuild(job, this.createActions(job, hook));
        } else {
            LOGGER.log(Level.INFO, "Source branch {0} or target branch {1} is not allowed", new Object[]{sourceBranch, targetBranch});
        }
    }

    protected abstract String getTriggerType();

    protected abstract boolean isCiSkip(H var1);

    private void setCommitStatusPendingIfNecessary(Job<?, ?> job, H hook) {
        String buildName = PendingBuildsHandler.resolvePendingBuildName(job);
        if (StringUtils.isNotBlank((String)buildName)) {
            GitLabClient client = ((GitLabConnectionProperty)job.getProperty(GitLabConnectionProperty.class)).getClient();
            BuildStatusUpdate buildStatusUpdate = this.retrieveBuildStatusUpdate(hook);
            try {
                if (client == null) {
                    LOGGER.log(Level.SEVERE, "No GitLab connection configured");
                } else {
                    String targetUrl = DisplayURLProvider.get().getJobURL(job);
                    client.changeBuildStatus(buildStatusUpdate.getProjectId(), buildStatusUpdate.getSha(), BuildState.pending, buildStatusUpdate.getRef(), buildName, targetUrl, BuildState.pending.name());
                }
            }
            catch (ProcessingException | WebApplicationException e) {
                LOGGER.log(Level.SEVERE, "Failed to set build state to pending", e);
            }
        }
    }

    protected Action[] createActions(Job<?, ?> job, H hook) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new CauseAction((Cause)new GitLabWebHookCause(this.retrieveCauseData(hook))));
        try {
            SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
            GitSCM gitSCM = this.getGitSCM(item);
            actions.add(this.createRevisionParameter(hook, gitSCM));
        }
        catch (NoRevisionToBuildException e) {
            LOGGER.log(Level.WARNING, "unknown handled situation, dont know what revision to build for req {0} for job {1}", new Object[]{hook, job != null ? job.getFullName() : null});
        }
        return actions.toArray(new Action[actions.size()]);
    }

    protected void cancelPendingBuildsIfNecessary(Job<?, ?> job, H hook) {
    }

    protected abstract CauseData retrieveCauseData(H var1);

    protected abstract String getSourceBranch(H var1);

    protected abstract String getTargetBranch(H var1);

    protected abstract RevisionParameterAction createRevisionParameter(H var1, GitSCM var2) throws NoRevisionToBuildException;

    protected abstract BuildStatusUpdate retrieveBuildStatusUpdate(H var1);

    protected URIish retrieveUrIish(WebHook hook) {
        try {
            if (hook.getRepository() != null) {
                return new URIish(hook.getRepository().getUrl());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "could not parse URL");
        }
        return null;
    }

    protected void scheduleBuild(Job<?, ?> job, Action[] actions) {
        ParameterizedJobMixIn.ParameterizedJob abstractProject;
        int projectBuildDelay = 0;
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob && (abstractProject = (ParameterizedJobMixIn.ParameterizedJob)job).getQuietPeriod() > projectBuildDelay) {
            projectBuildDelay = abstractProject.getQuietPeriod();
        }
        this.retrieveScheduleJob(job).scheduleBuild2(projectBuildDelay, actions);
    }

    private ParameterizedJobMixIn retrieveScheduleJob(final Job<?, ?> job) {
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        };
    }

    private GitSCM getGitSCM(SCMTriggerItem item) {
        if (item != null) {
            for (SCM scm : item.getSCMs()) {
                if (!(scm instanceof GitSCM)) continue;
                return (GitSCM)scm;
            }
        }
        return null;
    }

    public static class BuildStatusUpdate {
        private final Integer projectId;
        private final String sha;
        private final String ref;

        @GeneratePojoBuilder(intoPackage="*.builder.generated", withFactoryMethod="*")
        public BuildStatusUpdate(Integer projectId, String sha, String ref) {
            this.projectId = projectId;
            this.sha = sha;
            this.ref = ref;
        }

        public Integer getProjectId() {
            return this.projectId;
        }

        public String getSha() {
            return this.sha;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

