/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.gitlab.api.impl;

import com.dabsquared.gitlabjenkins.gitlab.JacksonConfig;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClientBuilder;
import com.dabsquared.gitlabjenkins.gitlab.api.impl.GitLabApiProxy;
import com.dabsquared.gitlabjenkins.gitlab.api.impl.ResteasyGitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import com.dabsquared.gitlabjenkins.util.JsonUtil;
import com.dabsquared.gitlabjenkins.util.LoggerUtil;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import hudson.ProxyConfiguration;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.plugins.providers.JaxrsFormProvider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ResteasyGitLabClientBuilder
extends GitLabClientBuilder {
    private static final Logger LOGGER = Logger.getLogger(ResteasyGitLabClientBuilder.class.getName());
    private static final String PRIVATE_TOKEN = "PRIVATE-TOKEN";
    private final Class<? extends GitLabApiProxy> apiProxyClass;
    private final Function<MergeRequest, Integer> mergeRequestIdProvider;

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void setRuntimeDelegate() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new ResteasyProviderFactory());
    }

    ResteasyGitLabClientBuilder(String id, int ordinal, Class<? extends GitLabApiProxy> apiProxyClass, Function<MergeRequest, Integer> mergeRequestIdProvider) {
        super(id, ordinal);
        this.apiProxyClass = apiProxyClass;
        this.mergeRequestIdProvider = mergeRequestIdProvider;
    }

    @Override
    @Nonnull
    public final GitLabClient buildClient(String url, String apiToken, boolean ignoreCertificateErrors, int connectionTimeout, int readTimeout) {
        return this.buildClient(url, apiToken, Jenkins.getActiveInstance().proxy, ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    private GitLabClient buildClient(String url, String apiToken, ProxyConfiguration httpProxyConfig, boolean ignoreCertificateErrors, int connectionTimeout, int readTimeout) {
        Proxy proxy;
        ResteasyClientBuilder builder = new ResteasyClientBuilder();
        if (ignoreCertificateErrors) {
            builder.hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.ANY);
            builder.disableTrustManager();
        }
        if (httpProxyConfig != null && (proxy = httpProxyConfig.createProxy(this.getHost(url))).type() == Proxy.Type.HTTP) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            builder.defaultProxy(address.getHostString().replaceFirst("^.*://", ""), address.getPort(), address.getHostName().startsWith("https") ? "https" : "http", httpProxyConfig.getUserName(), httpProxyConfig.getPassword());
        }
        GitLabApiProxy apiProxy = (GitLabApiProxy)builder.connectionPoolSize(60).maxPooledPerRoute(30).establishConnectionTimeout((long)connectionTimeout, TimeUnit.SECONDS).socketTimeout((long)readTimeout, TimeUnit.SECONDS).register((Object)new JacksonJsonProvider()).register((Object)new JacksonConfig()).register((Object)new ApiHeaderTokenFilter(apiToken)).register((Object)new LoggingFilter()).register((Object)new RemoveAcceptEncodingFilter()).register((Object)new JaxrsFormProvider()).build().target(url).proxyBuilder(this.apiProxyClass).classloader(this.apiProxyClass.getClassLoader()).build();
        return new ResteasyGitLabClient(url, apiProxy, this.mergeRequestIdProvider);
    }

    private String getHost(String url) {
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static class ResteasyClientBuilder
    extends org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder {
        private CredentialsProvider proxyCredentials;

        private ResteasyClientBuilder() {
        }

        ResteasyClientBuilder defaultProxy(String hostname, int port, String scheme, String username, String password) {
            super.defaultProxy(hostname, port, scheme);
            if (username != null && password != null) {
                this.proxyCredentials = new BasicCredentialsProvider();
                this.proxyCredentials.setCredentials(new AuthScope(hostname, port), (Credentials)new UsernamePasswordCredentials(username, password));
            }
            return this;
        }

        protected ClientHttpEngine initDefaultEngine() {
            ApacheHttpClient4Engine httpEngine = (ApacheHttpClient4Engine)super.initDefaultEngine();
            if (this.proxyCredentials != null) {
                ((DefaultHttpClient)httpEngine.getHttpClient()).setCredentialsProvider(this.proxyCredentials);
            }
            return httpEngine;
        }
    }

    @Priority(value=3000)
    private static class RemoveAcceptEncodingFilter
    implements ClientRequestFilter {
        RemoveAcceptEncodingFilter() {
        }

        public void filter(ClientRequestContext clientRequestContext) {
            clientRequestContext.getHeaders().remove((Object)"Accept-Encoding");
        }
    }

    @Priority(value=5000)
    private static class LoggingFilter
    implements ClientRequestFilter,
    ClientResponseFilter {
        private LoggingFilter() {
        }

        public void filter(ClientRequestContext context) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Call GitLab:\nHTTP method: {0}\nURL: {1}\nRequest headers: [\n{2}\n]", LoggerUtil.toArray(context.getMethod(), context.getUri(), this.toFilteredString((MultivaluedMap<String, Object>)context.getHeaders())));
            }
        }

        public void filter(ClientRequestContext request, ClientResponseContext response) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Got response from GitLab:\nURL: {0}\nStatus: {1} {2}\nResponse headers: [\n{3}\n]\nResponse body: {4}", LoggerUtil.toArray(request.getUri(), response.getStatus(), response.getStatusInfo(), this.toString((MultivaluedMap<String, String>)response.getHeaders()), this.getPrettyPrintResponseBody(response)));
            }
        }

        private String toFilteredString(MultivaluedMap<String, Object> headers) {
            return FluentIterable.from((Iterable)headers.entrySet()).transform((Function)new HeaderToFilteredString()).join(Joiner.on((String)",\n"));
        }

        private String toString(MultivaluedMap<String, String> headers) {
            return FluentIterable.from((Iterable)headers.entrySet()).transform((Function)new HeaderToString()).join(Joiner.on((String)",\n"));
        }

        private String getPrettyPrintResponseBody(ClientResponseContext responseContext) {
            String responseBody = this.getResponseBody(responseContext);
            if (StringUtils.isNotEmpty((String)responseBody) && responseContext.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                return JsonUtil.toPrettyPrint(responseBody);
            }
            return responseBody;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getResponseBody(ClientResponseContext context) {
            try (InputStream entityStream = context.getEntityStream();){
                if (entityStream == null) return "";
                byte[] bytes = IOUtils.toByteArray((InputStream)entityStream);
                context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
                String string = new String(bytes);
                return string;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failure during reading the response body", e);
                context.setEntityStream((InputStream)new ByteArrayInputStream(new byte[0]));
            }
            return "";
        }

        private static class HeaderToString
        implements Function<Map.Entry<String, List<String>>, String> {
            private HeaderToString() {
            }

            @Nullable
            public String apply(@Nullable Map.Entry<String, List<String>> input) {
                return input == null ? null : input.getKey() + " = [" + Joiner.on((String)", ").join((Iterable)input.getValue()) + "]";
            }
        }

        private static class HeaderToFilteredString
        implements Function<Map.Entry<String, List<Object>>, String> {
            private HeaderToFilteredString() {
            }

            @Nullable
            public String apply(@Nullable Map.Entry<String, List<Object>> input) {
                if (input == null) {
                    return null;
                }
                if (input.getKey().equals(ResteasyGitLabClientBuilder.PRIVATE_TOKEN)) {
                    return input.getKey() + " = [****FILTERED****]";
                }
                return input.getKey() + " = [" + Joiner.on((String)", ").join((Iterable)input.getValue()) + "]";
            }
        }
    }

    @Priority(value=3000)
    private static class ApiHeaderTokenFilter
    implements ClientRequestFilter {
        private final String gitlabApiToken;

        ApiHeaderTokenFilter(String gitlabApiToken) {
            this.gitlabApiToken = gitlabApiToken;
        }

        public void filter(ClientRequestContext requestContext) {
            requestContext.getHeaders().putSingle((Object)ResteasyGitLabClientBuilder.PRIVATE_TOKEN, (Object)this.gitlabApiToken);
        }
    }
}

