/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.webhook.build;

import com.dabsquared.gitlabjenkins.GitLabPushTrigger;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.NoteHook;
import com.dabsquared.gitlabjenkins.util.JsonUtil;
import com.dabsquared.gitlabjenkins.webhook.WebHookAction;
import com.dabsquared.gitlabjenkins.webhook.build.BuildWebHookAction;
import com.fasterxml.jackson.databind.JsonNode;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.StaplerResponse;

public class NoteBuildAction
implements WebHookAction {
    private static final Logger LOGGER = Logger.getLogger(NoteBuildAction.class.getName());
    private Item project;
    private NoteHook noteHook;
    private final String secretToken;

    public NoteBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.FINE, "Note: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.noteHook = JsonUtil.read(json, NoteHook.class);
        this.secretToken = secretToken;
    }

    public NoteBuildAction(Item project, JsonNode json, String secretToken) {
        LOGGER.log(Level.FINE, "Note: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.noteHook = JsonUtil.read(json, NoteHook.class);
        this.secretToken = secretToken;
    }

    @Override
    public void execute(StaplerResponse response) {
        if (!(this.project instanceof Job)) {
            throw HttpResponses.errorWithoutStack((int)409, (String)"Note Hook is not supported for this project");
        }
        ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new BuildWebHookAction.TriggerNotifier(this.project, this.secretToken, Jenkins.getAuthentication()){

            @Override
            protected void performOnPost(GitLabPushTrigger trigger) {
                trigger.onPost(NoteBuildAction.this.noteHook);
            }
        });
        throw HttpResponses.ok();
    }
}

