/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.branch;

import com.dabsquared.gitlabjenkins.Messages;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.service.GitLabProjectBranchesService;
import com.dabsquared.gitlabjenkins.trigger.branch.AntPathMatcherSet;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public final class ProjectBranchesProvider {
    private static final Logger LOGGER = Logger.getLogger(ProjectBranchesProvider.class.getName());
    private static final ProjectBranchesProvider INSTANCE = new ProjectBranchesProvider();

    private ProjectBranchesProvider() {
    }

    public static ProjectBranchesProvider instance() {
        return INSTANCE;
    }

    private List<String> getProjectBranches(Job<?, ?> project) {
        URIish sourceRepository = this.getSourceRepoURLDefault(project);
        GitLabConnectionProperty connectionProperty = (GitLabConnectionProperty)project.getProperty(GitLabConnectionProperty.class);
        if (connectionProperty != null && connectionProperty.getClient() != null) {
            return GitLabProjectBranchesService.instance().getBranches(connectionProperty.getClient(), sourceRepository.toString());
        }
        LOGGER.log(Level.WARNING, "getProjectBranches: gitlabHostUrl hasn't been configured globally. Job {0}.", project.getFullName());
        return Collections.emptyList();
    }

    public AutoCompletionCandidates doAutoCompleteBranchesSpec(Job<?, ?> job, String query) {
        AutoCompletionCandidates result = new AutoCompletionCandidates();
        if (query.length() < 2) {
            result.add(this.getProjectBranchesAsArray(job));
        } else {
            for (String branch : this.getProjectBranchesAsArray(job)) {
                if (!branch.toLowerCase().contains(query.toLowerCase())) continue;
                result.add(branch);
            }
        }
        return result;
    }

    public FormValidation doCheckBranchesSpec(@AncestorInPath Job<?, ?> project, @QueryParameter String value) {
        if (!project.hasPermission(Item.CONFIGURE) || this.containsNoBranches(value)) {
            return FormValidation.ok();
        }
        try {
            return this.checkMatchingBranches(value, this.getProjectBranches(project));
        }
        catch (GitLabProjectBranchesService.BranchLoadingException e) {
            return FormValidation.warning((Throwable)(project.hasPermission(Jenkins.ADMINISTER) ? e : null), (String)Messages.GitLabPushTrigger_CannotCheckBranches());
        }
    }

    private FormValidation checkMatchingBranches(@QueryParameter String value, List<String> projectBranches) {
        HashSet<String> matchingSpecs = new HashSet<String>();
        HashSet<String> unknownSpecs = new HashSet<String>();
        AntPathMatcherSet projectBranchesMatcherSet = new AntPathMatcherSet((Collection<? extends String>)projectBranches);
        for (String branchSpec : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
            if (projectBranchesMatcherSet.contains(branchSpec)) {
                matchingSpecs.add(branchSpec);
                continue;
            }
            unknownSpecs.add(branchSpec);
        }
        if (unknownSpecs.isEmpty()) {
            return FormValidation.ok((String)Messages.GitLabPushTrigger_BranchesMatched(matchingSpecs.size()));
        }
        return FormValidation.warning((String)Messages.GitLabPushTrigger_BranchesNotFound(Joiner.on((String)", ").join(unknownSpecs)));
    }

    private boolean containsNoBranches(@QueryParameter String value) {
        return StringUtils.isEmpty((String)value) || StringUtils.containsOnly((String)value, (char[])new char[]{',', ' '});
    }

    private String[] getProjectBranchesAsArray(Job<?, ?> job) {
        try {
            List<String> branches = this.getProjectBranches(job);
            return branches.toArray(new String[branches.size()]);
        }
        catch (GitLabProjectBranchesService.BranchLoadingException e) {
            LOGGER.log(Level.FINEST, "Failed to load branch names from GitLab. Please check the logs and your configuration.", e);
            return new String[0];
        }
    }

    private URIish getSourceRepoURLDefault(Job<?, ?> job) {
        SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
        GitSCM gitSCM = this.getGitSCM(item);
        if (gitSCM == null) {
            LOGGER.log(Level.WARNING, "Could not find GitSCM for project. Project = {1}, next build = {2}", this.array(job.getName(), String.valueOf(job.getNextBuildNumber())));
            throw new IllegalStateException("This project does not use git:" + job.getName());
        }
        return this.getFirstRepoURL(gitSCM.getRepositories());
    }

    private URIish getFirstRepoURL(List<RemoteConfig> repositories) {
        List uris;
        if (!repositories.isEmpty() && !(uris = repositories.get(repositories.size() - 1).getURIs()).isEmpty()) {
            return (URIish)uris.get(uris.size() - 1);
        }
        throw new IllegalStateException(Messages.GitLabPushTrigger_NoSourceRepository());
    }

    private GitSCM getGitSCM(SCMTriggerItem item) {
        if (item != null) {
            for (SCM scm : item.getSCMs()) {
                if (!(scm instanceof GitSCM)) continue;
                return (GitSCM)scm;
            }
        }
        return null;
    }

    private Object[] array(Object ... objects) {
        return objects;
    }
}

