/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jenkinsci.plugins.GitLabRequireOrganizationMembershipACL;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitLabAuthorizationStrategy
extends AuthorizationStrategy {
    private final GitLabRequireOrganizationMembershipACL rootACL;

    @DataBoundConstructor
    public GitLabAuthorizationStrategy(String adminUserNames, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, boolean authenticatedUserStopBuildPermission, String organizationNames, boolean allowGitlabWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission) {
        this.rootACL = new GitLabRequireOrganizationMembershipACL(adminUserNames, organizationNames, authenticatedUserReadPermission, useRepositoryPermissions, authenticatedUserCreateJobPermission, authenticatedUserStopBuildPermission, allowGitlabWebHookPermission, allowCcTrayPermission, allowAnonymousReadPermission, allowAnonymousJobStatusPermission);
    }

    public ACL getRootACL() {
        return this.rootACL;
    }

    public ACL getACL(Job<?, ?> job) {
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            GitLabRequireOrganizationMembershipACL gitlabACL = (GitLabRequireOrganizationMembershipACL)this.getRootACL();
            return gitlabACL.cloneForProject(project);
        }
        return this.getRootACL();
    }

    public Collection<String> getGroups() {
        return new ArrayList<String>(0);
    }

    private Object readResolve() {
        return this;
    }

    public String getOrganizationNames() {
        return StringUtils.join(this.rootACL.getOrganizationNameList().iterator(), (String)", ");
    }

    public String getAdminUserNames() {
        return StringUtils.join(this.rootACL.getAdminUserNameList().iterator(), (String)", ");
    }

    public boolean isUseRepositoryPermissions() {
        return this.rootACL.isUseRepositoryPermissions();
    }

    public boolean isAuthenticatedUserCreateJobPermission() {
        return this.rootACL.isAuthenticatedUserCreateJobPermission();
    }

    public boolean isAuthenticatedUserStopBuildPermission() {
        return this.rootACL.isAuthenticatedUserStopBuildPermission();
    }

    public boolean isAuthenticatedUserReadPermission() {
        return this.rootACL.isAuthenticatedUserReadPermission();
    }

    public boolean isAllowGitlabWebHookPermission() {
        return this.rootACL.isAllowGitlabWebHookPermission();
    }

    public boolean isAllowCcTrayPermission() {
        return this.rootACL.isAllowCcTrayPermission();
    }

    public boolean isAllowAnonymousReadPermission() {
        return this.rootACL.isAllowAnonymousReadPermission();
    }

    public boolean isAllowAnonymousJobStatusPermission() {
        return this.rootACL.isAllowAnonymousJobStatusPermission();
    }

    public boolean equals(Object object) {
        if (object instanceof GitLabAuthorizationStrategy) {
            GitLabAuthorizationStrategy obj = (GitLabAuthorizationStrategy)((Object)object);
            return this.getOrganizationNames().equals(obj.getOrganizationNames()) && this.getAdminUserNames().equals(obj.getAdminUserNames()) && this.isUseRepositoryPermissions() == obj.isUseRepositoryPermissions() && this.isAuthenticatedUserCreateJobPermission() == obj.isAuthenticatedUserCreateJobPermission() && this.isAuthenticatedUserStopBuildPermission() == obj.isAuthenticatedUserStopBuildPermission() && this.isAuthenticatedUserReadPermission() == obj.isAuthenticatedUserReadPermission() && this.isAllowGitlabWebHookPermission() == obj.isAllowGitlabWebHookPermission() && this.isAllowCcTrayPermission() == obj.isAllowCcTrayPermission() && this.isAllowAnonymousReadPermission() == obj.isAllowAnonymousReadPermission() && this.isAllowAnonymousJobStatusPermission() == obj.isAllowAnonymousJobStatusPermission();
        }
        return false;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (boolean)false);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        public String getDisplayName() {
            return "Gitlab Commiter Authorization Strategy";
        }

        public String getHelpFile() {
            return "/plugin/gitlab-oauth/help/help-authorization-strategy.html";
        }
    }
}

