/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitlabRepositoryName {
    private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("git@(.+):([^/]+)/([^/]+)\\.git"), Pattern.compile("https?://[^/]+@([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("git://([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("ssh://git@([^/]+)/([^/]+)/([^/]+)\\.git"), Pattern.compile("git@(.+):([^/]+)/([^/]+)/?"), Pattern.compile("https?://[^/]+@([^/]+)/([^/]+)/([^/]+)/?"), Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)/?"), Pattern.compile("git://([^/]+)/([^/]+)/([^/]+)/?"), Pattern.compile("ssh://git@([^/]+)/([^/]+)/([^/]+)/?")};
    public final String host;
    public final String userName;
    public final String repositoryName;
    private static final Logger LOGGER = Logger.getLogger(GitlabRepositoryName.class.getName());

    public static GitlabRepositoryName create(String url) {
        LOGGER.log(Level.FINE, "Constructing from URL {0}", url);
        for (Pattern p : URL_PATTERNS) {
            Matcher m = p.matcher(url.trim());
            if (!m.matches()) continue;
            LOGGER.log(Level.FINE, "URL matches {0}", m);
            GitlabRepositoryName ret = new GitlabRepositoryName(m.group(1), m.group(2), m.group(3));
            LOGGER.log(Level.FINE, "Object is {0}", ret);
            return ret;
        }
        LOGGER.log(Level.WARNING, "Could not match URL {0}", url);
        return null;
    }

    public GitlabRepositoryName(String host, String userName, String repositoryName) {
        this.host = host;
        this.userName = userName;
        this.repositoryName = repositoryName;
    }

    public String toString() {
        return "GitLabRepository[host=" + this.host + ",username=" + this.userName + ",repository=" + this.repositoryName + "]";
    }
}

