/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.Permission;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.GitLabAuthenticationToken;
import org.jenkinsci.plugins.GitlabRepositoryName;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class GitLabRequireOrganizationMembershipACL
extends ACL {
    private static final Logger log = Logger.getLogger(GitLabRequireOrganizationMembershipACL.class.getName());
    private final List<String> organizationNameList;
    private final List<String> adminUserNameList;
    private final boolean authenticatedUserReadPermission;
    private final boolean useRepositoryPermissions;
    private final boolean authenticatedUserCreateJobPermission;
    private final boolean allowGitlabWebHookPermission;
    private final boolean allowCcTrayPermission;
    private final boolean allowAnonymousReadPermission;
    private final boolean allowAnonymousJobStatusPermission;
    private final AbstractProject project;

    public boolean hasPermission(Authentication a, Permission permission) {
        if (a != null && a instanceof GitLabAuthenticationToken) {
            if (!a.isAuthenticated()) {
                return false;
            }
            GitLabAuthenticationToken authenticationToken = (GitLabAuthenticationToken)a;
            String candidateName = a.getName();
            if (this.adminUserNameList.contains(candidateName)) {
                log.finest("Granting Admin rights to user " + candidateName);
                return true;
            }
            if (this.project != null) {
                if (this.useRepositoryPermissions) {
                    if (this.hasRepositoryPermission(authenticationToken, permission)) {
                        log.finest("Granting Authenticated User " + permission.getId() + " permission on project " + this.project.getName() + "to user " + candidateName);
                        return true;
                    }
                } else if (this.authenticatedUserReadPermission && this.checkReadPermission(permission)) {
                    log.finest("Granting Authenticated User read permission on project " + this.project.getName() + "to user " + candidateName);
                    return true;
                }
            } else if (this.authenticatedUserReadPermission && this.checkReadPermission(permission)) {
                log.finest("Granting Authenticated User read permission to user " + candidateName);
                return true;
            }
            if (this.authenticatedUserCreateJobPermission && permission.equals((Object)Item.CREATE)) {
                return true;
            }
            for (String organizationName : this.organizationNameList) {
                if (!authenticationToken.hasOrganizationPermission(candidateName, organizationName) || !this.checkReadPermission(permission) && !this.testBuildPermission(permission)) continue;
                log.finest("Granting READ and BUILD rights to user " + candidateName + " a member of " + organizationName);
                return true;
            }
            return false;
        }
        String authenticatedUserName = a.getName();
        if (authenticatedUserName.equals(SYSTEM.getPrincipal())) {
            log.finest("Granting Full rights to SYSTEM user.");
            return true;
        }
        if (authenticatedUserName.equals("anonymous")) {
            if (this.checkJobStatusPermission(permission) && this.allowAnonymousJobStatusPermission) {
                return true;
            }
            if (this.checkReadPermission(permission)) {
                if (this.allowAnonymousReadPermission) {
                    return true;
                }
                if (this.allowGitlabWebHookPermission && (this.currentUriPathStartsWith("/project/") || this.currentUriPathEquals("gitlab-webhook") || this.currentUriPathEquals("gitlab-webhook/"))) {
                    log.finest("Granting READ access for gitlab-webhook url: " + this.requestURI());
                    return true;
                }
                if (this.allowCcTrayPermission && this.currentUriPathEquals("cc.xml")) {
                    log.finest("Granting READ access for cctray url: " + this.requestURI());
                    return true;
                }
                log.finer("Denying anonymous READ permission to url: " + this.requestURI());
            }
            if (this.testBuildPermission(permission) && this.allowGitlabWebHookPermission && (this.currentUriPathStartsWith("/project/") || this.currentUriPathEquals("gitlab-webhook") || this.currentUriPathEquals("gitlab-webhook/"))) {
                log.finest("Granting BUILD access for gitlab-webhook url: " + this.requestURI());
                return true;
            }
            return false;
        }
        if (this.adminUserNameList.contains(authenticatedUserName)) {
            log.finest("Granting Admin rights to user " + a.getName());
            return true;
        }
        return false;
    }

    private boolean currentUriPathStartsWith(String specificPath) {
        String requestUri = this.requestURI();
        return requestUri == null ? false : requestUri.startsWith(specificPath);
    }

    private boolean currentUriPathEquals(String specificPath) {
        String requestUri = this.requestURI();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && requestUri != null) {
            String basePath = URI.create(jenkins.getRootUrl()).getPath();
            return URI.create(requestUri).getPath().equals(basePath + specificPath);
        }
        return false;
    }

    private String requestURI() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        return currentRequest == null ? null : currentRequest.getOriginalRequestURI();
    }

    private boolean testBuildPermission(Permission permission) {
        return permission.getId().equals("hudson.model.Hudson.Build") || permission.getId().equals("hudson.model.Item.Build");
    }

    private boolean checkReadPermission(Permission permission) {
        return permission.getId().equals("hudson.model.Hudson.Read") || permission.getId().equals("hudson.model.Item.Workspace") || permission.getId().equals("hudson.model.Item.Read");
    }

    private boolean checkJobStatusPermission(Permission permission) {
        return permission.getId().equals("hudson.model.Item.ViewStatus");
    }

    public boolean hasRepositoryPermission(GitLabAuthenticationToken authenticationToken, Permission permission) {
        String repositoryName = this.getRepositoryName();
        if (repositoryName == null) {
            if (this.authenticatedUserCreateJobPermission) {
                return permission.equals((Object)Item.READ) || permission.equals((Object)Item.CONFIGURE) || permission.equals((Object)Item.DELETE) || permission.equals((Object)Item.EXTENDED_READ);
            }
            return false;
        }
        if (this.checkReadPermission(permission) && authenticationToken.isPublicRepository(repositoryName)) {
            return true;
        }
        return authenticationToken.hasRepositoryPermission(repositoryName);
    }

    private String getRepositoryName() {
        GitlabRepositoryName gitlabRepositoryName;
        String repoUrl;
        GitSCM git;
        List userRemoteConfigs;
        String repositoryName = null;
        SCM scm = this.project.getScm();
        if (scm instanceof GitSCM && !(userRemoteConfigs = (git = (GitSCM)scm).getUserRemoteConfigs()).isEmpty() && (repoUrl = ((UserRemoteConfig)userRemoteConfigs.get(0)).getUrl()) != null && (gitlabRepositoryName = GitlabRepositoryName.create(repoUrl)) != null) {
            repositoryName = gitlabRepositoryName.userName + "/" + gitlabRepositoryName.repositoryName;
        }
        return repositoryName;
    }

    public GitLabRequireOrganizationMembershipACL(String adminUserNames, String organizationNames, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, boolean allowGitlabWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission) {
        String[] parts;
        this.authenticatedUserReadPermission = authenticatedUserReadPermission;
        this.useRepositoryPermissions = useRepositoryPermissions;
        this.authenticatedUserCreateJobPermission = authenticatedUserCreateJobPermission;
        this.allowGitlabWebHookPermission = allowGitlabWebHookPermission;
        this.allowCcTrayPermission = allowCcTrayPermission;
        this.allowAnonymousReadPermission = allowAnonymousReadPermission;
        this.allowAnonymousJobStatusPermission = allowAnonymousJobStatusPermission;
        this.adminUserNameList = new LinkedList<String>();
        for (String part : parts = adminUserNames.split(",")) {
            this.adminUserNameList.add(part.trim());
        }
        this.organizationNameList = new LinkedList<String>();
        for (String part : parts = organizationNames.split(",")) {
            this.organizationNameList.add(part.trim());
        }
        this.project = null;
    }

    public GitLabRequireOrganizationMembershipACL(List<String> adminUserNameList, List<String> organizationNameList, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, boolean allowGitlabWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission, AbstractProject project) {
        this.adminUserNameList = adminUserNameList;
        this.organizationNameList = organizationNameList;
        this.authenticatedUserReadPermission = authenticatedUserReadPermission;
        this.useRepositoryPermissions = useRepositoryPermissions;
        this.authenticatedUserCreateJobPermission = authenticatedUserCreateJobPermission;
        this.allowGitlabWebHookPermission = allowGitlabWebHookPermission;
        this.allowCcTrayPermission = allowCcTrayPermission;
        this.allowAnonymousReadPermission = allowAnonymousReadPermission;
        this.allowAnonymousJobStatusPermission = allowAnonymousJobStatusPermission;
        this.project = project;
    }

    public GitLabRequireOrganizationMembershipACL cloneForProject(AbstractProject project) {
        return new GitLabRequireOrganizationMembershipACL(this.adminUserNameList, this.organizationNameList, this.authenticatedUserReadPermission, this.useRepositoryPermissions, this.authenticatedUserCreateJobPermission, this.allowGitlabWebHookPermission, this.allowCcTrayPermission, this.allowAnonymousReadPermission, this.allowAnonymousJobStatusPermission, project);
    }

    public List<String> getOrganizationNameList() {
        return this.organizationNameList;
    }

    public List<String> getAdminUserNameList() {
        return this.adminUserNameList;
    }

    public boolean isUseRepositoryPermissions() {
        return this.useRepositoryPermissions;
    }

    public boolean isAuthenticatedUserCreateJobPermission() {
        return this.authenticatedUserCreateJobPermission;
    }

    public boolean isAuthenticatedUserReadPermission() {
        return this.authenticatedUserReadPermission;
    }

    public boolean isAllowGitlabWebHookPermission() {
        return this.allowGitlabWebHookPermission;
    }

    public boolean isAllowCcTrayPermission() {
        return this.allowCcTrayPermission;
    }

    public boolean isAllowAnonymousReadPermission() {
        return this.allowAnonymousReadPermission;
    }

    public boolean isAllowAnonymousJobStatusPermission() {
        return this.allowAnonymousJobStatusPermission;
    }
}

