/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.apache.commons.collections.CollectionUtils;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.TokenType;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabUser;
import org.jenkinsci.plugins.GitLabOAuthUserDetails;
import org.jenkinsci.plugins.GitLabSecurityRealm;

public class GitLabAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String userName;
    private final transient GitlabAPI gitLabAPI;
    private final transient GitlabUser me;
    private transient GitLabSecurityRealm myRealm = null;
    private static final Cache<String, Set<String>> userOrganizationCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Set<String>> repositoryCollaboratorsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Set<String>> repositoriesByUserCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Boolean> publicRepositoryCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, List<GitlabProject>> groupRepositoriesCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    private static final Logger LOGGER = Logger.getLogger(GitLabAuthenticationToken.class.getName());

    public GitLabAuthenticationToken(String accessToken, String gitlabServer, TokenType tokenType) throws IOException {
        super(new GrantedAuthority[0]);
        this.accessToken = accessToken;
        this.gitLabAPI = GitlabAPI.connect((String)gitlabServer, (String)accessToken, (TokenType)tokenType);
        this.me = this.gitLabAPI.getUser();
        assert (this.me != null);
        this.setAuthenticated(true);
        this.userName = this.me.getUsername();
        this.authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && jenkins.getSecurityRealm() instanceof GitLabSecurityRealm) {
            if (this.myRealm == null) {
                this.myRealm = (GitLabSecurityRealm)jenkins.getSecurityRealm();
            }
            List myTeams = this.gitLabAPI.getGroups();
            for (GitlabGroup group : myTeams) {
                LOGGER.log(Level.FINE, "Fetch teams for user " + this.userName + " in organization " + group.getName());
                this.authorities.add((GrantedAuthority)new GrantedAuthorityImpl(group.getName()));
                this.authorities.add((GrantedAuthority)new GrantedAuthorityImpl(group + "*" + group.getName()));
            }
        }
    }

    public static void clearCaches() {
        userOrganizationCache.invalidateAll();
        repositoryCollaboratorsCache.invalidateAll();
        repositoriesByUserCache.invalidateAll();
        groupRepositoriesCache.invalidateAll();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public GitlabAPI getGitLabAPI() {
        return this.gitLabAPI;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities.toArray(new GrantedAuthority[this.authorities.size()]);
    }

    public Object getCredentials() {
        return "";
    }

    public String getPrincipal() {
        return this.userName;
    }

    public GitlabUser getMyself() {
        return this.me;
    }

    public boolean hasOrganizationPermission(String candidateName, String organization) {
        try {
            Set v = (Set)userOrganizationCache.get((Object)candidateName, (Callable)new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    List groups = GitLabAuthenticationToken.this.gitLabAPI.getGroups();
                    HashSet<String> groupsNames = new HashSet<String>();
                    for (GitlabGroup group : groups) {
                        groupsNames.add(group.getName());
                    }
                    return groupsNames;
                }
            });
            return v.contains(organization);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("authorization failed for user = " + candidateName, e);
        }
    }

    public boolean hasRepositoryPermission(String repositoryName) {
        return this.myRepositories().contains(repositoryName);
    }

    public Set<String> myRepositories() {
        try {
            Set myRepositories = (Set)repositoriesByUserCache.get((Object)this.getName(), (Callable)new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    List userRepositoryList = GitLabAuthenticationToken.this.gitLabAPI.getProjects();
                    Set<String> repositoryNames = Collections.emptySet();
                    if (userRepositoryList != null) {
                        repositoryNames = GitLabAuthenticationToken.this.listToNames(userRepositoryList);
                    }
                    return repositoryNames;
                }
            });
            return myRepositories;
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "an exception was thrown", e);
            throw new RuntimeException("authorization failed for user = " + this.getName(), e);
        }
    }

    public Set<String> listToNames(Collection<GitlabProject> repositories) throws IOException {
        HashSet<String> names = new HashSet<String>();
        for (GitlabProject repository : repositories) {
            names.add(repository.getPathWithNamespace());
        }
        return names;
    }

    public boolean isPublicRepository(final String repositoryName) {
        try {
            Boolean isPublic = (Boolean)publicRepositoryCache.get((Object)repositoryName, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    GitlabProject repository = GitLabAuthenticationToken.this.loadRepository(repositoryName);
                    if (repository == null) {
                        return Boolean.FALSE;
                    }
                    return repository.isPublic();
                }
            });
            return isPublic;
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "an exception was thrown", e);
            throw new RuntimeException("authorization failed for user = " + this.getName(), e);
        }
    }

    public GitlabUser loadUser(String username) {
        try {
            List users;
            if (this.gitLabAPI != null && this.isAuthenticated() && CollectionUtils.isNotEmpty((Collection)(users = this.gitLabAPI.findUsers(username)))) {
                return (GitlabUser)users.get(0);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public GitlabGroup loadOrganization(String organization) {
        try {
            if (this.gitLabAPI != null && this.isAuthenticated() && !this.gitLabAPI.getGroups().isEmpty()) {
                return (GitlabGroup)this.gitLabAPI.getGroups().get(0);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public GitlabProject loadRepository(String repositoryName) {
        try {
            if (this.gitLabAPI != null && this.isAuthenticated()) {
                return this.gitLabAPI.getProject((Serializable)((Object)repositoryName));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Looks like a bad GitLab URL OR the Jenkins user does not have access to the repository{0}", repositoryName);
        }
        return null;
    }

    public GitLabOAuthUserDetails getUserDetails(String username) {
        GitlabUser user = this.loadUser(username);
        if (user != null) {
            ArrayList<GrantedAuthorityImpl> groups = new ArrayList<GrantedAuthorityImpl>();
            try {
                List gitLabGroups = this.gitLabAPI.getGroups();
                for (GitlabGroup gitlabGroup : gitLabGroups) {
                    groups.add(new GrantedAuthorityImpl(gitlabGroup.getName()));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
            return new GitLabOAuthUserDetails(user, groups.toArray(new GrantedAuthority[groups.size()]));
        }
        return null;
    }

    public List<GitlabProject> getGroupProjects(final GitlabGroup group) {
        try {
            List groupProjects = (List)groupRepositoriesCache.get((Object)group.getPath(), (Callable)new Callable<List<GitlabProject>>(){

                @Override
                public List<GitlabProject> call() throws Exception {
                    return GitLabAuthenticationToken.this.gitLabAPI.getGroupProjects(group);
                }
            });
            return groupProjects;
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "an exception was thrown", e);
            throw new RuntimeException("authorization failed for user = " + this.getName(), e);
        }
    }
}

