/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.Mailer;
import hudson.util.Secret;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Group;
import org.jenkinsci.plugins.GitLabAuthenticationToken;
import org.jenkinsci.plugins.GitLabOAuthGroupDetails;
import org.jenkinsci.plugins.GitLabOAuthUserDetails;
import org.jfree.util.Log;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class GitLabSecurityRealm
extends SecurityRealm
implements UserDetailsService {
    private String gitlabWebUri;
    private String gitlabApiUri;
    private String clientID;
    private Secret clientSecret;
    private static final Logger LOGGER = Logger.getLogger(GitLabSecurityRealm.class.getName());
    private static final String REFERER_ATTRIBUTE = GitLabSecurityRealm.class.getName() + ".referer";

    @DataBoundConstructor
    public GitLabSecurityRealm(String gitlabWebUri, String gitlabApiUri, String clientID, String clientSecret) {
        this.gitlabWebUri = Util.fixEmptyAndTrim((String)gitlabWebUri);
        this.gitlabApiUri = Util.fixEmptyAndTrim((String)gitlabApiUri);
        this.clientID = Util.fixEmptyAndTrim((String)clientID);
        this.setClientSecret(Util.fixEmptyAndTrim((String)clientSecret));
    }

    private GitLabSecurityRealm() {
    }

    private void setGitlabWebUri(String gitlabWebUri) {
        this.gitlabWebUri = gitlabWebUri;
    }

    private void setClientID(String clientID) {
        this.clientID = clientID;
    }

    private void setClientSecret(String clientSecret) {
        this.clientSecret = Secret.fromString((String)clientSecret);
    }

    public String getGitlabApiUri() {
        return this.gitlabApiUri;
    }

    private void setGitlabApiUri(String gitlabApiUri) {
        this.gitlabApiUri = gitlabApiUri;
    }

    public String getGitlabWebUri() {
        return this.gitlabWebUri;
    }

    public String getClientID() {
        return this.clientID;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public HttpResponse doCommenceLogin(StaplerRequest request, @QueryParameter String from, @Header(value="Referer") String referer) throws IOException {
        String redirectOnFinish = from != null && Util.isSafeToRedirectTo((String)from) ? from : (referer != null && (referer.startsWith(Jenkins.get().getRootUrl()) || Util.isSafeToRedirectTo((String)referer)) ? referer : Jenkins.get().getRootUrl());
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)redirectOnFinish);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("redirect_uri", this.buildRedirectUrl(request)));
        parameters.add(new BasicNameValuePair("response_type", "code"));
        parameters.add(new BasicNameValuePair("client_id", this.clientID));
        parameters.add(new BasicNameValuePair("scope", "api"));
        return new HttpRedirect(this.gitlabWebUri + "/oauth/authorize?" + URLEncodedUtils.format(parameters, (Charset)StandardCharsets.UTF_8));
    }

    private String buildRedirectUrl(StaplerRequest request) throws MalformedURLException {
        URL currentUrl = new URL(Jenkins.get().getRootUrl());
        URL redirect_uri = new URL(currentUrl.getProtocol(), currentUrl.getHost(), currentUrl.getPort(), request.getContextPath() + "/securityRealm/finishLogin");
        return redirect_uri.toString();
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        String code = request.getParameter("code");
        if (StringUtils.isBlank((String)code)) {
            Log.info((Object)"doFinishLogin: missing code or private_token.");
            return HttpResponses.redirectToContextRoot();
        }
        if (this.clientSecret == null) {
            Log.info((Object)"doFinishLogin: missing client secret.");
            return HttpResponses.redirectToContextRoot();
        }
        String referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE);
        HttpPost httpPost = new HttpPost(this.gitlabWebUri + "/oauth/token");
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("client_id", this.clientID));
        parameters.add(new BasicNameValuePair("client_secret", this.clientSecret.getPlainText()));
        parameters.add(new BasicNameValuePair("code", code));
        parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
        parameters.add(new BasicNameValuePair("redirect_uri", this.buildRedirectUrl(request)));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpHost proxy = this.getProxy((HttpUriRequest)httpPost);
        if (proxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            httpPost.setConfig(config);
        }
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        String content = EntityUtils.toString((HttpEntity)entity);
        httpclient.close();
        String accessToken = this.extractToken(content);
        if (StringUtils.isNotBlank((String)accessToken)) {
            try {
                GitLabAuthenticationToken auth = new GitLabAuthenticationToken(accessToken, this.getGitlabApiUri(), Constants.TokenType.OAUTH2_ACCESS);
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                request.getSession(true);
                SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                org.gitlab4j.api.models.User self = auth.getMyself();
                User user = User.current();
                if (user != null) {
                    user.setFullName(self.getName());
                    if (!((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).hasExplicitlyConfiguredAddress()) {
                        user.addProperty((UserProperty)new Mailer.UserProperty(auth.getMyself().getEmail()));
                    }
                }
                SecurityListener.fireAuthenticated((UserDetails)new GitLabOAuthUserDetails(self, auth.getAuthorities()));
            }
            catch (GitLabApiException e) {
                throw new RuntimeException(e);
            }
        } else {
            Log.info((Object)"GitLab did not return an access token.");
        }
        if (StringUtils.isNotBlank((String)referer)) {
            return HttpResponses.redirectTo((String)referer);
        }
        return HttpResponses.redirectToContextRoot();
    }

    private HttpHost getProxy(HttpUriRequest method) {
        Jenkins jenkins = Jenkins.get();
        ProxyConfiguration proxy = jenkins.proxy;
        if (proxy == null) {
            return null;
        }
        Proxy p = proxy.createProxy(method.getURI().getHost());
        switch (p.type()) {
            case DIRECT: {
                return null;
            }
            case HTTP: {
                InetSocketAddress sa = (InetSocketAddress)p.address();
                return new HttpHost(sa.getHostName(), sa.getPort());
            }
        }
        return null;
    }

    private String extractToken(String content) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonTree = mapper.readTree(content);
            JsonNode node = jsonTree.get("access_token");
            if (node != null) {
                return node.asText();
            }
        }
        catch (IOException e) {
            Log.error((Object)e.getMessage(), (Exception)e);
        }
        return null;
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof GitLabAuthenticationToken) {
                    return authentication;
                }
                if (authentication instanceof UsernamePasswordAuthenticationToken) {
                    try {
                        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)authentication;
                        GitLabAuthenticationToken gitlab = new GitLabAuthenticationToken(token.getCredentials().toString(), GitLabSecurityRealm.this.getGitlabApiUri(), Constants.TokenType.PRIVATE);
                        SecurityContextHolder.getContext().setAuthentication((Authentication)gitlab);
                        return gitlab;
                    }
                    catch (GitLabApiException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        }, new UserDetailsService(){

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                return GitLabSecurityRealm.this.loadUserByUsername(username);
            }
        });
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        Jenkins jenkins = Jenkins.get();
        if (jenkins.hasPermission(Jenkins.READ)) {
            return req.getContextPath() + "/";
        }
        return req.getContextPath() + "/gitlabLogout";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (!(SecurityContextHolder.getContext().getAuthentication() instanceof GitLabAuthenticationToken)) {
            throw new UserMayOrMayNotExistException("Could not get auth token.");
        }
        GitLabAuthenticationToken authToken = (GitLabAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        try {
            GitLabOAuthUserDetails userDetails = authToken.getUserDetails(username);
            if (userDetails == null) {
                throw new UsernameNotFoundException("Unknown user: " + username);
            }
            Group ghOrg = authToken.loadOrganization(username);
            if (ghOrg != null) {
                throw new UsernameNotFoundException("user(" + username + ") is also an organization");
            }
            return userDetails;
        }
        catch (Error e) {
            throw new DataRetrievalFailureException("loadUserByUsername (username=" + username + ")", (Throwable)e);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof GitLabSecurityRealm) {
            GitLabSecurityRealm obj = (GitLabSecurityRealm)((Object)object);
            return this.getGitlabWebUri().equals(obj.getGitlabWebUri()) && this.getGitlabApiUri().equals(obj.getGitlabApiUri()) && this.getClientID().equals(obj.getClientID()) && this.clientSecret.equals((Object)obj.clientSecret);
        }
        return false;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (boolean)false);
    }

    public GroupDetails loadGroupByGroupname(String groupName) throws UsernameNotFoundException, DataAccessException {
        GitLabAuthenticationToken authToken = (GitLabAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        if (authToken == null) {
            throw new UsernameNotFoundException("No known group: " + groupName);
        }
        Group gitlabGroup = authToken.loadOrganization(groupName);
        return new GitLabOAuthGroupDetails(gitlabGroup);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/gitlab-oauth/help/help-security-realm.html";
        }

        public String getDisplayName() {
            return "GitLab Authentication Plugin";
        }

        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == GitLabSecurityRealm.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GitLabSecurityRealm realm = (GitLabSecurityRealm)((Object)source);
            writer.startNode("gitlabWebUri");
            writer.setValue(realm.getGitlabWebUri());
            writer.endNode();
            writer.startNode("gitlabApiUri");
            writer.setValue(realm.getGitlabApiUri());
            writer.endNode();
            writer.startNode("clientID");
            writer.setValue(realm.getClientID());
            writer.endNode();
            writer.startNode("clientSecret");
            writer.setValue(realm.clientSecret.getEncryptedValue());
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            GitLabSecurityRealm realm = new GitLabSecurityRealm();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String node = reader.getNodeName();
                String value = reader.getValue();
                this.setValue(realm, node, value);
                reader.moveUp();
            }
            return realm;
        }

        private void setValue(GitLabSecurityRealm realm, String node, String value) {
            switch (node.toLowerCase()) {
                case "clientid": {
                    realm.setClientID(value);
                    break;
                }
                case "clientsecret": {
                    realm.setClientSecret(value);
                    break;
                }
                case "gitlabweburi": {
                    realm.setGitlabWebUri(value);
                    break;
                }
                case "gitlabapiuri": {
                    realm.setGitlabApiUri(value);
                    break;
                }
                default: {
                    throw new ConversionException("Invalid node value = " + node);
                }
            }
        }
    }
}

