/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.jenkinsci.plugins.GitLabOAuthGroupDetails;
import org.jenkinsci.plugins.GitLabOAuthUserDetails;
import org.jenkinsci.plugins.GitLabSecurityRealm;

public class GitLabAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String userName;
    private final transient GitLabApi gitLabAPI;
    private final transient User me;
    private transient GitLabSecurityRealm myRealm = null;
    private static final Cache<String, Set<String>> userOrganizationCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Set<String>> repositoryCollaboratorsCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Set<String>> repositoriesByUserCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Boolean> publicRepositoryCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, List<Project>> groupRepositoriesCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    private static final Logger LOGGER = Logger.getLogger(GitLabAuthenticationToken.class.getName());

    public GitLabAuthenticationToken(String accessToken, String gitlabServer, Constants.TokenType tokenType) throws GitLabApiException {
        super(new GrantedAuthority[0]);
        this.accessToken = accessToken;
        this.gitLabAPI = new GitLabApi(gitlabServer, tokenType, accessToken);
        this.me = Objects.requireNonNull(this.gitLabAPI.getUserApi().getCurrentUser());
        this.setAuthenticated(true);
        this.userName = this.me.getUsername();
        this.authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && jenkins.getSecurityRealm() instanceof GitLabSecurityRealm) {
            this.myRealm = (GitLabSecurityRealm)jenkins.getSecurityRealm();
            List myTeams = this.gitLabAPI.getGroupApi().getGroups();
            for (Group group : myTeams) {
                LOGGER.log(Level.FINE, "Fetch teams for user " + this.userName + " in organization " + group.getName());
                GitLabOAuthGroupDetails gitLabOAuthGroupDetails = new GitLabOAuthGroupDetails(group);
                this.authorities.add(gitLabOAuthGroupDetails.getAuth());
            }
        }
    }

    public static void clearCaches() {
        userOrganizationCache.invalidateAll();
        repositoryCollaboratorsCache.invalidateAll();
        repositoriesByUserCache.invalidateAll();
        groupRepositoriesCache.invalidateAll();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public GitLabApi getGitLabAPI() {
        return this.gitLabAPI;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities.toArray(new GrantedAuthority[0]);
    }

    public Object getCredentials() {
        return "";
    }

    public String getPrincipal() {
        return this.userName;
    }

    public User getMyself() {
        return this.me;
    }

    public boolean hasOrganizationPermission(String candidateName, String organization) {
        Set v = (Set)userOrganizationCache.get((Object)candidateName, unused -> {
            try {
                List groups = this.gitLabAPI.getGroupApi().getGroups();
                HashSet<String> groupsNames = new HashSet<String>();
                for (Group group : groups) {
                    groupsNames.add(group.getName());
                }
                return groupsNames;
            }
            catch (GitLabApiException e) {
                throw new RuntimeException("authorization failed for user = " + candidateName, e);
            }
        });
        return v != null && v.contains(organization);
    }

    public boolean hasRepositoryPermission(String repositoryName) {
        return this.myRepositories().contains(repositoryName);
    }

    public Set<String> myRepositories() {
        Set myRepositories = (Set)repositoriesByUserCache.get((Object)this.getName(), unused -> {
            try {
                List userRepositoryList = this.gitLabAPI.getProjectApi().getProjects();
                Set<Object> repositoryNames = Collections.emptySet();
                if (userRepositoryList != null) {
                    repositoryNames = this.listToNames(userRepositoryList);
                }
                return repositoryNames;
            }
            catch (GitLabApiException e) {
                throw new RuntimeException(e);
            }
        });
        return myRepositories;
    }

    public Set<String> listToNames(Collection<Project> repositories) {
        HashSet<String> names = new HashSet<String>();
        for (Project repository : repositories) {
            names.add(repository.getPathWithNamespace());
        }
        return names;
    }

    public boolean isPublicRepository(String repositoryName) {
        Boolean isPublic = (Boolean)publicRepositoryCache.get((Object)repositoryName, unused -> {
            Project repository = this.loadRepository(repositoryName);
            if (repository == null) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE.equals(repository.getPublic());
        });
        return isPublic != null && isPublic != false;
    }

    public User loadUser(String username) {
        try {
            List users;
            if (this.gitLabAPI != null && this.isAuthenticated() && CollectionUtils.isNotEmpty((Collection)(users = this.gitLabAPI.getUserApi().findUsers(username)))) {
                return (User)users.get(0);
            }
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public Group loadOrganization(String organization) {
        if (StringUtils.isEmpty((String)organization)) {
            return null;
        }
        try {
            List gitLabGroups;
            if (this.gitLabAPI != null && this.isAuthenticated() && !(gitLabGroups = this.gitLabAPI.getGroupApi().getGroups()).isEmpty()) {
                return gitLabGroups.stream().filter(group -> group.getName().equalsIgnoreCase(organization)).findFirst().orElse(null);
            }
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public Project loadRepository(String repositoryName) {
        try {
            if (this.gitLabAPI != null && this.isAuthenticated()) {
                return this.gitLabAPI.getProjectApi().getProject((Object)repositoryName);
            }
        }
        catch (GitLabApiException e) {
            LOGGER.log(Level.WARNING, "Looks like a bad GitLab URL OR the Jenkins user does not have access to the repository{0}", repositoryName);
        }
        return null;
    }

    public GitLabOAuthUserDetails getUserDetails(String username) {
        User user = this.loadUser(username);
        if (user != null) {
            ArrayList<GrantedAuthorityImpl> groups = new ArrayList<GrantedAuthorityImpl>();
            try {
                List gitLabGroups = this.gitLabAPI.getGroupApi().getGroups();
                for (Group gitlabGroup : gitLabGroups) {
                    groups.add(new GrantedAuthorityImpl(gitlabGroup.getName()));
                }
            }
            catch (GitLabApiException e) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
            return new GitLabOAuthUserDetails(user, groups.toArray(new GrantedAuthority[0]));
        }
        return null;
    }

    public List<Project> getGroupProjects(Group group) {
        List groupProjects = (List)groupRepositoriesCache.get((Object)group.getFullPath(), unused -> {
            try {
                return this.gitLabAPI.getGroupApi().getProjects((Object)group);
            }
            catch (GitLabApiException e) {
                throw new RuntimeException(e);
            }
        });
        return groupProjects;
    }
}

