/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitlablogo.api;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.jenkinsci.plugins.gitlablogo.api.Project;

public class GitlabApi {
    private final String endpointUrl;
    private final String privateToken;
    private final HttpClient httpClient = new HttpClient();
    private static final Map<String, Project> PROJECT_CACHE = new HashMap<String, Project>();

    public GitlabApi(String endpointUrl, String privateToken) {
        this.endpointUrl = endpointUrl;
        this.privateToken = privateToken;
    }

    public Project getProject(String repositoryName) {
        try {
            String url = this.endpointUrl + "/projects/" + this.urlEncode(repositoryName);
            String json = this.getContent(url);
            ObjectMapper mapper = new ObjectMapper();
            return (Project)mapper.readValue(json, Project.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Project getCachedProject(String repositoryName) {
        Project cache = PROJECT_CACHE.get(repositoryName);
        if (cache != null) {
            return cache;
        }
        Project project = this.getProject(repositoryName);
        PROJECT_CACHE.put(repositoryName, project);
        return project;
    }

    private String urlEncode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContent(String url) throws IOException {
        GetMethod method = new GetMethod(url);
        method.addRequestHeader("PRIVATE-TOKEN", this.privateToken);
        int statusCode = this.httpClient.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            throw new RuntimeException("statusCode is " + statusCode);
        }
        try {
            String string = method.getResponseBodyAsString();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    public static void clearCache() {
        PROJECT_CACHE.clear();
    }
}

