/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.Permission;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.GitHubRepositoryName;
import org.jenkinsci.plugins.GithubAuthenticationToken;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class GithubRequireOrganizationMembershipACL
extends ACL {
    private static final Logger log = Logger.getLogger(GithubRequireOrganizationMembershipACL.class.getName());
    private final List<String> organizationNameList;
    private final List<String> adminUserNameList;
    private final boolean authenticatedUserReadPermission;
    private final boolean useRepositoryPermissions;
    private final boolean authenticatedUserCreateJobPermission;
    private final boolean allowGithubWebHookPermission;
    private final boolean allowCcTrayPermission;
    private final boolean allowAnonymousReadPermission;
    private final boolean allowAnonymousJobStatusPermission;
    private final AbstractItem item;

    public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
        if (a instanceof GithubAuthenticationToken) {
            if (!a.isAuthenticated()) {
                return false;
            }
            GithubAuthenticationToken authenticationToken = (GithubAuthenticationToken)a;
            String candidateName = a.getName();
            if (this.adminUserNameList.contains(candidateName)) {
                log.finest("Granting Admin rights to user " + candidateName);
                return true;
            }
            if (this.item != null) {
                if (this.useRepositoryPermissions) {
                    if (this.hasRepositoryPermission(authenticationToken, permission)) {
                        log.finest("Granting Authenticated User " + permission.getId() + " permission on project " + this.item.getName() + "to user " + candidateName);
                        return true;
                    }
                } else if (this.authenticatedUserReadPermission && this.checkReadPermission(permission)) {
                    log.finest("Granting Authenticated User read permission on project " + this.item.getName() + "to user " + candidateName);
                    return true;
                }
            } else if (this.authenticatedUserReadPermission && this.checkReadPermission(permission)) {
                log.finest("Granting Authenticated User read permission to user " + candidateName);
                return true;
            }
            if (this.authenticatedUserCreateJobPermission && permission.equals((Object)Item.CREATE)) {
                return true;
            }
            for (String organizationName : this.organizationNameList) {
                if (!authenticationToken.hasOrganizationPermission(candidateName, organizationName)) continue;
                String[] parts = permission.getId().split("\\.");
                String test = parts[parts.length - 1].toLowerCase();
                if (!this.checkReadPermission(permission) && !this.testBuildPermission(permission)) continue;
                log.finest("Granting READ and BUILD rights to user " + candidateName + " a member of " + organizationName);
                return true;
            }
            return false;
        }
        String authenticatedUserName = a.getName();
        if (authenticatedUserName == null) {
            throw new IllegalArgumentException("Authentication must have a valid name");
        }
        if (authenticatedUserName.equals(SYSTEM.getPrincipal())) {
            log.finest("Granting Full rights to SYSTEM user.");
            return true;
        }
        if (authenticatedUserName.equals("anonymous")) {
            if (this.checkJobStatusPermission(permission) && this.allowAnonymousJobStatusPermission) {
                return true;
            }
            if (this.checkReadPermission(permission)) {
                if (this.allowAnonymousReadPermission) {
                    return true;
                }
                if (this.allowGithubWebHookPermission && (this.currentUriPathEquals("github-webhook") || this.currentUriPathEquals("github-webhook/"))) {
                    log.finest("Granting READ access for github-webhook url: " + this.requestURI());
                    return true;
                }
                if (this.allowCcTrayPermission && this.currentUriPathEndsWithSegment("cc.xml")) {
                    log.finest("Granting READ access for cctray url: " + this.requestURI());
                    return true;
                }
                log.finer("Denying anonymous READ permission to url: " + this.requestURI());
            }
            return false;
        }
        if (this.adminUserNameList.contains(authenticatedUserName)) {
            log.finest("Granting Admin rights to user " + a.getName());
            return true;
        }
        return false;
    }

    private boolean currentUriPathEquals(String specificPath) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        String rootUrl = jenkins.getRootUrl();
        if (rootUrl == null) {
            throw new IllegalStateException("Could not determine Jenkins URL");
        }
        String requestUri = this.requestURI();
        if (requestUri != null) {
            String basePath = URI.create(rootUrl).getPath();
            return URI.create(requestUri).getPath().equals(basePath + specificPath);
        }
        return false;
    }

    private boolean currentUriPathEndsWithSegment(String segment) {
        String requestUri = this.requestURI();
        if (requestUri != null) {
            return requestUri.substring(requestUri.lastIndexOf(47) + 1).equals(segment);
        }
        return false;
    }

    private String requestURI() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        return currentRequest == null ? null : currentRequest.getOriginalRequestURI();
    }

    private boolean testBuildPermission(Permission permission) {
        return permission.getId().equals("hudson.model.Hudson.Build") || permission.getId().equals("hudson.model.Item.Build");
    }

    private boolean checkReadPermission(Permission permission) {
        return permission.getId().equals("hudson.model.Hudson.Read") || permission.getId().equals("hudson.model.Item.Workspace") || permission.getId().equals("hudson.model.Item.Discover") || permission.getId().equals("hudson.model.Item.Read");
    }

    private boolean checkJobStatusPermission(Permission permission) {
        return permission.getId().equals("hudson.model.Item.ViewStatus");
    }

    public boolean hasRepositoryPermission(GithubAuthenticationToken authenticationToken, Permission permission) {
        String repositoryName = this.getRepositoryName();
        if (repositoryName == null) {
            if (this.authenticatedUserCreateJobPermission) {
                return permission.equals((Object)Item.DISCOVER) || permission.equals((Object)Item.READ) || permission.equals((Object)Item.CONFIGURE) || permission.equals((Object)Item.DELETE) || permission.equals((Object)Item.EXTENDED_READ) || permission.equals((Object)Item.CANCEL);
            }
            return false;
        }
        if (this.checkReadPermission(permission) && authenticationToken.isPublicRepository(repositoryName)) {
            return true;
        }
        return authenticationToken.hasRepositoryPermission(repositoryName, permission);
    }

    private String getRepositoryName() {
        GitHubRepositoryName githubRepositoryName;
        List userRemoteConfigs;
        GitHubSCMSource git;
        WorkflowJob project;
        String repositoryName = null;
        String repoUrl = null;
        SCM scm = null;
        if (this.item instanceof WorkflowJob) {
            project = (WorkflowJob)this.item;
            scm = ((BranchJobProperty)project.getProperty(BranchJobProperty.class)).getBranch().getScm();
        } else if (this.item instanceof MultiBranchProject) {
            project = (MultiBranchProject)this.item;
            scm = (SCMSource)project.getSCMSources().get(0);
        } else if (this.item instanceof AbstractProject) {
            project = (AbstractProject)this.item;
            scm = project.getScm();
        }
        if (scm instanceof GitHubSCMSource) {
            git = (GitHubSCMSource)scm;
            repoUrl = git.getRemote();
        } else if (scm instanceof GitSCM && !(userRemoteConfigs = (git = (GitSCM)scm).getUserRemoteConfigs()).isEmpty()) {
            repoUrl = ((UserRemoteConfig)userRemoteConfigs.get(0)).getUrl();
        }
        if (repoUrl != null && (githubRepositoryName = GitHubRepositoryName.create(repoUrl)) != null) {
            repositoryName = githubRepositoryName.userName + "/" + githubRepositoryName.repositoryName;
        }
        return repositoryName;
    }

    public GithubRequireOrganizationMembershipACL(String adminUserNames, String organizationNames, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, boolean allowGithubWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission) {
        String[] parts;
        this.authenticatedUserReadPermission = authenticatedUserReadPermission;
        this.useRepositoryPermissions = useRepositoryPermissions;
        this.authenticatedUserCreateJobPermission = authenticatedUserCreateJobPermission;
        this.allowGithubWebHookPermission = allowGithubWebHookPermission;
        this.allowCcTrayPermission = allowCcTrayPermission;
        this.allowAnonymousReadPermission = allowAnonymousReadPermission;
        this.allowAnonymousJobStatusPermission = allowAnonymousJobStatusPermission;
        this.adminUserNameList = new LinkedList<String>();
        for (String part : parts = adminUserNames.split(",")) {
            this.adminUserNameList.add(part.trim());
        }
        this.organizationNameList = new LinkedList<String>();
        for (String part : parts = organizationNames.split(",")) {
            this.organizationNameList.add(part.trim());
        }
        this.item = null;
    }

    public GithubRequireOrganizationMembershipACL cloneForProject(AbstractItem item) {
        return new GithubRequireOrganizationMembershipACL(this.adminUserNameList, this.organizationNameList, this.authenticatedUserReadPermission, this.useRepositoryPermissions, this.authenticatedUserCreateJobPermission, this.allowGithubWebHookPermission, this.allowCcTrayPermission, this.allowAnonymousReadPermission, this.allowAnonymousJobStatusPermission, item);
    }

    public GithubRequireOrganizationMembershipACL(List<String> adminUserNameList, List<String> organizationNameList, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, boolean allowGithubWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission, AbstractItem item) {
        this.adminUserNameList = adminUserNameList;
        this.organizationNameList = organizationNameList;
        this.authenticatedUserReadPermission = authenticatedUserReadPermission;
        this.useRepositoryPermissions = useRepositoryPermissions;
        this.authenticatedUserCreateJobPermission = authenticatedUserCreateJobPermission;
        this.allowGithubWebHookPermission = allowGithubWebHookPermission;
        this.allowCcTrayPermission = allowCcTrayPermission;
        this.allowAnonymousReadPermission = allowAnonymousReadPermission;
        this.allowAnonymousJobStatusPermission = allowAnonymousJobStatusPermission;
        this.item = item;
    }

    public List<String> getOrganizationNameList() {
        return this.organizationNameList;
    }

    public List<String> getAdminUserNameList() {
        return this.adminUserNameList;
    }

    public boolean isUseRepositoryPermissions() {
        return this.useRepositoryPermissions;
    }

    public boolean isAuthenticatedUserCreateJobPermission() {
        return this.authenticatedUserCreateJobPermission;
    }

    public boolean isAuthenticatedUserReadPermission() {
        return this.authenticatedUserReadPermission;
    }

    public boolean isAllowGithubWebHookPermission() {
        return this.allowGithubWebHookPermission;
    }

    public boolean isAllowCcTrayPermission() {
        return this.allowCcTrayPermission;
    }

    public boolean isAllowAnonymousReadPermission() {
        return this.allowAnonymousReadPermission;
    }

    public boolean isAllowAnonymousJobStatusPermission() {
        return this.allowAnonymousJobStatusPermission;
    }
}

