/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Extension;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.CliAuthenticator;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.Mailer;
import hudson.util.Secret;
import java.io.Console;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.GitHubOAuthScope;
import org.jenkinsci.plugins.GithubAuthenticationToken;
import org.jenkinsci.plugins.GithubOAuthGroupDetails;
import org.jenkinsci.plugins.GithubOAuthUserDetails;
import org.jenkinsci.plugins.GithubSecretStorage;
import org.jfree.util.Log;
import org.kohsuke.args4j.Option;
import org.kohsuke.github.GHEmail;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHTeam;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class GithubSecurityRealm
extends AbstractPasswordBasedSecurityRealm
implements UserDetailsService {
    private static final String DEFAULT_WEB_URI = "https://github.com";
    private static final String DEFAULT_API_URI = "https://api.github.com";
    private static final String DEFAULT_ENTERPRISE_API_SUFFIX = "/api/v3";
    private static final String DEFAULT_OAUTH_SCOPES = "read:org,user:email";
    private String githubWebUri;
    private String githubApiUri;
    private String clientID;
    private Secret clientSecret;
    private String oauthScopes;
    private String[] myScopes;
    private static final Logger LOGGER = Logger.getLogger(GithubSecurityRealm.class.getName());
    private static final String REFERER_ATTRIBUTE = GithubSecurityRealm.class.getName() + ".referer";

    @DataBoundConstructor
    public GithubSecurityRealm(String githubWebUri, String githubApiUri, String clientID, String clientSecret, String oauthScopes) {
        this.githubWebUri = Util.fixEmptyAndTrim((String)githubWebUri);
        this.githubApiUri = Util.fixEmptyAndTrim((String)githubApiUri);
        this.clientID = Util.fixEmptyAndTrim((String)clientID);
        this.setClientSecret(Util.fixEmptyAndTrim((String)clientSecret));
        this.oauthScopes = Util.fixEmptyAndTrim((String)oauthScopes);
    }

    private GithubSecurityRealm() {
    }

    private String determineApiUri(String githubWebUri) {
        if (githubWebUri.equals(DEFAULT_WEB_URI)) {
            return DEFAULT_API_URI;
        }
        return githubWebUri + DEFAULT_ENTERPRISE_API_SUFFIX;
    }

    private void setGithubWebUri(String githubWebUri) {
        this.githubWebUri = githubWebUri;
    }

    private void setClientID(String clientID) {
        this.clientID = clientID;
    }

    private void setClientSecret(String clientSecret) {
        this.clientSecret = Secret.fromString((String)clientSecret);
    }

    private void setOauthScopes(String oauthScopes) {
        this.oauthScopes = oauthScopes;
    }

    public boolean hasScope(String scope) {
        if (this.myScopes == null) {
            this.myScopes = this.oauthScopes.split(",");
            Arrays.sort(this.myScopes);
        }
        return Arrays.binarySearch(this.myScopes, scope) >= 0;
    }

    public String getGithubApiUri() {
        return this.githubApiUri;
    }

    private void setGithubApiUri(String githubApiUri) {
        this.githubApiUri = githubApiUri;
    }

    public String getGithubWebUri() {
        return this.githubWebUri;
    }

    @Deprecated
    public String getGithubUri() {
        return this.getGithubWebUri();
    }

    public String getClientID() {
        return this.clientID;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public String getOauthScopes() {
        return this.oauthScopes;
    }

    public HttpResponse doCommenceLogin(StaplerRequest request, @Header(value="Referer") String referer) throws IOException {
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)referer);
        HashSet<String> scopes = new HashSet<String>();
        for (GitHubOAuthScope s : GithubSecurityRealm.getJenkins().getExtensionList(GitHubOAuthScope.class)) {
            scopes.addAll(s.getScopesToRequest());
        }
        String suffix = "";
        suffix = !scopes.isEmpty() ? "&scope=" + Util.join(scopes, (String)",") : "&scope=" + this.oauthScopes;
        return new HttpRedirect(this.githubWebUri + "/login/oauth/authorize?client_id=" + this.clientID + suffix);
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        String code = request.getParameter("code");
        if (code == null || code.trim().length() == 0) {
            Log.info((Object)"doFinishLogin: missing code.");
            return HttpResponses.redirectToContextRoot();
        }
        String accessToken = this.getAccessToken(code);
        if (accessToken != null && accessToken.trim().length() > 0) {
            GithubAuthenticationToken auth = new GithubAuthenticationToken(accessToken, this.getGithubApiUri());
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            GHMyself self = auth.getMyself();
            User u = User.current();
            if (u == null) {
                throw new IllegalStateException("Can't find user");
            }
            GithubSecretStorage.put(u, accessToken);
            u.setFullName(self.getName());
            if (!((Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class)).hasExplicitlyConfiguredAddress()) {
                if (this.hasScope("user") || this.hasScope("user:email")) {
                    String primary_email = null;
                    for (GHEmail e : self.getEmails2()) {
                        if (!e.isPrimary()) continue;
                        primary_email = e.getEmail();
                    }
                    if (primary_email != null) {
                        u.addProperty((UserProperty)new Mailer.UserProperty(primary_email));
                    }
                } else {
                    u.addProperty((UserProperty)new Mailer.UserProperty(auth.getGitHub().getMyself().getEmail()));
                }
            }
            SecurityListener.fireAuthenticated((UserDetails)new GithubOAuthUserDetails(self.getLogin(), auth.getAuthorities()));
        } else {
            Log.info((Object)"Github did not return an access token.");
        }
        String referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE);
        if (referer != null) {
            return HttpResponses.redirectTo((String)referer);
        }
        return HttpResponses.redirectToContextRoot();
    }

    @Nullable
    private String getAccessToken(@Nonnull String code) throws IOException {
        String[] parts;
        String content;
        String[] stringArray = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpost = new HttpPost(this.githubWebUri + "/login/oauth/access_token?client_id=" + this.clientID + "&client_secret=" + this.clientSecret + "&code=" + code);
            HttpHost proxy = this.getProxy((HttpUriRequest)httpost);
            if (proxy != null) {
                RequestConfig requestConfig = RequestConfig.custom().setProxy(proxy).build();
                httpost.setConfig(requestConfig);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpost);
            HttpEntity entity = response.getEntity();
            content = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Throwable object) {
            stringArray = object;
            throw object;
        }
        for (String part : parts = content.split("&")) {
            if (!part.startsWith("access_token=")) continue;
            String[] tokenParts = part.split("=");
            return tokenParts[1];
        }
        return null;
    }

    private HttpHost getProxy(HttpUriRequest method) throws URIException {
        ProxyConfiguration proxy = GithubSecurityRealm.getJenkins().proxy;
        if (proxy == null) {
            return null;
        }
        Proxy p = proxy.createProxy(method.getURI().getHost());
        switch (p.type()) {
            case DIRECT: {
                return null;
            }
            case HTTP: {
                InetSocketAddress sa = (InetSocketAddress)p.address();
                return new HttpHost(sa.getHostName(), sa.getPort());
            }
        }
        return null;
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof GithubAuthenticationToken) {
                    return authentication;
                }
                if (authentication instanceof UsernamePasswordAuthenticationToken) {
                    try {
                        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)authentication;
                        GithubAuthenticationToken github = new GithubAuthenticationToken(token.getCredentials().toString(), GithubSecurityRealm.this.getGithubApiUri());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)github);
                        User user = User.getById((String)token.getName(), (boolean)false);
                        if (user != null) {
                            GithubSecretStorage.put(user, token.getCredentials().toString());
                        }
                        SecurityListener.fireAuthenticated((UserDetails)new GithubOAuthUserDetails(token.getName(), github.getAuthorities()));
                        return github;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        }, new UserDetailsService(){

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                return GithubSecurityRealm.this.loadUserByUsername(username);
            }
        });
    }

    protected GithubOAuthUserDetails authenticate(String username, String password) throws AuthenticationException {
        try {
            GithubAuthenticationToken github = new GithubAuthenticationToken(password, this.getGithubApiUri());
            if (username.equals(github.getPrincipal())) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)github);
                return github.getUserDetails(username);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new BadCredentialsException("Invalid GitHub username or personal access token: " + username);
    }

    public CliAuthenticator createCliAuthenticator(final CLICommand command) {
        return new CliAuthenticator(){
            @Option(name="--username", usage="GitHub username to authenticate yourself to Jenkins.")
            public String userName;
            @Option(name="--password", usage="GitHub personal access token. Note that passing a password in arguments is insecure.")
            public String password;
            @Option(name="--password-file", usage="File that contains the personal access token.")
            public String passwordFile;

            public Authentication authenticate() throws AuthenticationException, IOException, InterruptedException {
                if (this.userName == null) {
                    return command.getTransportAuthentication();
                }
                if (this.passwordFile != null) {
                    try {
                        this.password = new FilePath((VirtualChannel)command.channel, this.passwordFile).readToString().trim();
                    }
                    catch (IOException e) {
                        throw new BadCredentialsException("Failed to read " + this.passwordFile, (Throwable)e);
                    }
                }
                if (this.password == null) {
                    this.password = (String)command.channel.call((Callable)new InteractivelyAskForPassword());
                }
                if (this.password == null) {
                    throw new BadCredentialsException("No GitHub personal access token specified.");
                }
                GithubSecurityRealm.this.authenticate(this.userName, this.password);
                return new GithubAuthenticationToken(this.password, GithubSecurityRealm.this.getGithubApiUri());
            }
        };
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        Jenkins j = Jenkins.getInstance();
        assert (j != null);
        if (j.hasPermission(Jenkins.READ)) {
            return super.getPostLogOutUrl(req, auth);
        }
        return req.getContextPath() + "/" + "githubLogout";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if (username.indexOf("*") >= 0) {
            throw new UsernameNotFoundException("Using org*team format instead of username: " + username);
        }
        User localUser = User.getById((String)username, (boolean)false);
        Object token = SecurityContextHolder.getContext().getAuthentication();
        if (token == null) {
            if (localUser != null && GithubSecretStorage.contains(localUser)) {
                String accessToken = GithubSecretStorage.retrieve(localUser);
                try {
                    token = new GithubAuthenticationToken(accessToken, this.getGithubApiUri());
                }
                catch (IOException e) {
                    throw new UserMayOrMayNotExistException("Could not connect to GitHub API server, target URL = " + this.getGithubApiUri(), (Throwable)e);
                }
                SecurityContextHolder.getContext().setAuthentication(token);
            } else {
                throw new UserMayOrMayNotExistException("Could not get auth token.");
            }
        }
        if (!(token instanceof GithubAuthenticationToken)) {
            throw new UserMayOrMayNotExistException("Unexpected authentication type: " + token);
        }
        GithubAuthenticationToken authToken = (GithubAuthenticationToken)((Object)token);
        if (localUser != null) {
            return new GithubOAuthUserDetails(username, authToken);
        }
        try {
            GithubOAuthUserDetails userDetails = authToken.getUserDetails(username);
            if (userDetails == null) {
                throw new UsernameNotFoundException("Unknown user: " + username);
            }
            GHOrganization ghOrg = authToken.loadOrganization(username);
            if (ghOrg != null) {
                throw new UsernameNotFoundException("user(" + username + ") is also an organization");
            }
            return userDetails;
        }
        catch (IOException | Error e) {
            throw new DataRetrievalFailureException("loadUserByUsername (username=" + username + ")", e);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof GithubSecurityRealm) {
            GithubSecurityRealm obj = (GithubSecurityRealm)((Object)object);
            return this.getGithubWebUri().equals(obj.getGithubWebUri()) && this.getGithubApiUri().equals(obj.getGithubApiUri()) && this.getClientID().equals(obj.getClientID()) && this.getClientSecret().equals((Object)obj.getClientSecret()) && this.getOauthScopes().equals(obj.getOauthScopes());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getGithubWebUri()).append((Object)this.getGithubApiUri()).append((Object)this.getClientID()).append((Object)this.getClientSecret()).append((Object)this.getOauthScopes()).toHashCode();
    }

    public GroupDetails loadGroupByGroupname(String groupName) throws UsernameNotFoundException, DataAccessException {
        GithubAuthenticationToken authToken = (GithubAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        if (authToken == null) {
            throw new UsernameNotFoundException("No known group: " + groupName);
        }
        try {
            int idx = groupName.indexOf("*");
            if (idx > -1 && groupName.length() > idx + 1) {
                String orgName = groupName.substring(0, idx);
                String teamName = groupName.substring(idx + 1);
                LOGGER.config(String.format("Lookup for team %s in organization %s", teamName, orgName));
                GHTeam ghTeam = authToken.loadTeam(orgName, teamName);
                if (ghTeam == null) {
                    throw new UsernameNotFoundException("Unknown GitHub team: " + teamName + " in organization " + orgName);
                }
                return new GithubOAuthGroupDetails(ghTeam);
            }
            GHOrganization ghOrg = authToken.loadOrganization(groupName);
            if (ghOrg == null) {
                throw new UsernameNotFoundException("Unknown GitHub organization: " + groupName);
            }
            return new GithubOAuthGroupDetails(ghOrg);
        }
        catch (Error e) {
            throw new DataRetrievalFailureException("loadGroupByGroupname (groupname=" + groupName + ")", (Throwable)e);
        }
    }

    static Jenkins getJenkins() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        return jenkins;
    }

    private static class InteractivelyAskForPassword
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private InteractivelyAskForPassword() {
        }

        public String call() throws IOException {
            Console console = System.console();
            if (console == null) {
                return null;
            }
            char[] w = console.readPassword("GitHub Personal Access Token: ", new Object[0]);
            if (w == null) {
                return null;
            }
            return new String(w);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/github-oauth/help/help-security-realm.html";
        }

        public String getDisplayName() {
            return "Github Authentication Plugin";
        }

        public String getDefaultGithubWebUri() {
            return GithubSecurityRealm.DEFAULT_WEB_URI;
        }

        public String getDefaultGithubApiUri() {
            return GithubSecurityRealm.DEFAULT_API_URI;
        }

        public String getDefaultOauthScopes() {
            return GithubSecurityRealm.DEFAULT_OAUTH_SCOPES;
        }

        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == GithubSecurityRealm.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GithubSecurityRealm realm = (GithubSecurityRealm)((Object)source);
            writer.startNode("githubWebUri");
            writer.setValue(realm.getGithubWebUri());
            writer.endNode();
            writer.startNode("githubApiUri");
            writer.setValue(realm.getGithubApiUri());
            writer.endNode();
            writer.startNode("clientID");
            writer.setValue(realm.getClientID());
            writer.endNode();
            writer.startNode("clientSecret");
            writer.setValue(realm.getClientSecret().getEncryptedValue());
            writer.endNode();
            writer.startNode("oauthScopes");
            writer.setValue(realm.getOauthScopes());
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            GithubSecurityRealm realm = new GithubSecurityRealm();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String node = reader.getNodeName();
                String value = reader.getValue();
                this.setValue(realm, node, value);
                reader.moveUp();
            }
            if (realm.getGithubWebUri() == null) {
                realm.setGithubWebUri(GithubSecurityRealm.DEFAULT_WEB_URI);
            }
            if (realm.getGithubApiUri() == null) {
                realm.setGithubApiUri(GithubSecurityRealm.DEFAULT_API_URI);
            }
            return realm;
        }

        private void setValue(GithubSecurityRealm realm, String node, String value) {
            if (node.toLowerCase().equals("clientid")) {
                realm.setClientID(value);
            } else if (node.toLowerCase().equals("clientsecret")) {
                realm.setClientSecret(value);
            } else if (node.toLowerCase().equals("githubweburi")) {
                realm.setGithubWebUri(value);
            } else if (node.toLowerCase().equals("githuburi")) {
                realm.setGithubWebUri(value);
                String apiUrl = realm.determineApiUri(value);
                realm.setGithubApiUri(apiUrl);
            } else if (node.toLowerCase().equals("githubapiuri")) {
                realm.setGithubApiUri(value);
            } else if (node.toLowerCase().equals("oauthscopes")) {
                realm.setOauthScopes(value);
            } else {
                throw new ConversionException("Invalid node value = " + node);
            }
        }
    }
}

