/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.jenkinsci.plugins.GithubOAuthUserDetails;
import org.jenkinsci.plugins.GithubSecurityRealm;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.extras.OkHttpConnector;

public class GithubAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 2L;
    private final String accessToken;
    private final String githubServer;
    private final String userName;
    private transient GitHub gh;
    private transient GHMyself me;
    private transient GithubSecurityRealm myRealm = null;
    public static final TimeUnit CACHE_EXPIRY = TimeUnit.HOURS;
    private static final Cache<String, Set<String>> userOrganizationCache = CacheBuilder.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private static final Cache<String, Set<String>> repositoryCollaboratorsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private static final Cache<String, Set<String>> repositoriesByUserCache = CacheBuilder.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private static final Cache<String, Boolean> publicRepositoryCache = CacheBuilder.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private static final Cache<String, GithubUser> usersByIdCache = CacheBuilder.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private final List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    private static final GithubUser UNKNOWN_USER = new GithubUser(null);
    private static final Logger LOGGER = Logger.getLogger(GithubAuthenticationToken.class.getName());

    public GithubAuthenticationToken(String accessToken, String githubServer) throws IOException {
        super(new GrantedAuthority[0]);
        this.accessToken = accessToken;
        this.githubServer = githubServer;
        this.me = this.getGitHub().getMyself();
        assert (this.me != null);
        this.setAuthenticated(true);
        this.userName = this.me.getLogin();
        this.authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        if (jenkins.getSecurityRealm() instanceof GithubSecurityRealm) {
            if (this.myRealm == null) {
                this.myRealm = (GithubSecurityRealm)jenkins.getSecurityRealm();
            }
            if (this.myRealm.hasScope("read:org") || this.myRealm.hasScope("admin:org") || this.myRealm.hasScope("user") || this.myRealm.hasScope("repo")) {
                Map myOrgs = this.getGitHub().getMyOrganizations();
                Map myTeams = this.getGitHub().getMyTeams();
                for (String string : myOrgs.keySet()) {
                    if (myTeams.containsKey(string)) continue;
                    myTeams.put(string, Collections.emptySet());
                }
                for (Map.Entry entry : myTeams.entrySet()) {
                    String orgLogin = (String)entry.getKey();
                    LOGGER.log(Level.FINE, "Fetch teams for user " + this.userName + " in organization " + orgLogin);
                    this.authorities.add((GrantedAuthority)new GrantedAuthorityImpl(orgLogin));
                    for (GHTeam team : (Set)entry.getValue()) {
                        this.authorities.add((GrantedAuthority)new GrantedAuthorityImpl(orgLogin + "*" + team.getName()));
                    }
                }
            }
        }
    }

    public static void clearCaches() {
        userOrganizationCache.invalidateAll();
        repositoryCollaboratorsCache.invalidateAll();
        repositoriesByUserCache.invalidateAll();
        usersByIdCache.invalidateAll();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getGithubServer() {
        return this.githubServer;
    }

    public GitHub getGitHub() throws IOException {
        if (this.gh == null) {
            String host;
            try {
                host = new URL(this.githubServer).getHost();
            }
            catch (MalformedURLException e) {
                throw new IOException("Invalid GitHub API URL: " + this.githubServer, e);
            }
            OkHttpClient client = new OkHttpClient().setProxy(GithubAuthenticationToken.getProxy(host));
            this.gh = GitHubBuilder.fromEnvironment().withEndpoint(this.githubServer).withOAuthToken(this.accessToken).withRateLimitHandler(RateLimitHandler.FAIL).withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(client))).build();
        }
        return this.gh;
    }

    @Nonnull
    private static Proxy getProxy(@Nonnull String host) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        return jenkins.proxy.createProxy(host);
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities.toArray(new GrantedAuthority[this.authorities.size()]);
    }

    public Object getCredentials() {
        return "";
    }

    public String getPrincipal() {
        return this.userName;
    }

    public GHMyself getMyself() throws IOException {
        if (this.me == null) {
            this.me = this.getGitHub().getMyself();
        }
        return this.me;
    }

    public boolean hasOrganizationPermission(String candidateName, String organization) {
        try {
            Set v = (Set)userOrganizationCache.get((Object)candidateName, (Callable)new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    return GithubAuthenticationToken.this.getGitHub().getMyOrganizations().keySet();
                }
            });
            return v.contains(organization);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("authorization failed for user = " + candidateName, e);
        }
    }

    public boolean hasRepositoryPermission(String repositoryName) {
        return this.myRepositories().contains(repositoryName);
    }

    public Set<String> myRepositories() {
        try {
            return (Set)repositoriesByUserCache.get((Object)this.getName(), (Callable)new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    List userRepositoryList = GithubAuthenticationToken.this.getMyself().listRepositories().asList();
                    Set<String> repositoryNames = GithubAuthenticationToken.this.listToNames(userRepositoryList);
                    GHPersonSet organizations = GithubAuthenticationToken.this.getMyself().getAllOrganizations();
                    for (GHOrganization organization : organizations) {
                        List orgRepositoryList = organization.listRepositories().asList();
                        Set<String> orgRepositoryNames = GithubAuthenticationToken.this.listToNames(orgRepositoryList);
                        repositoryNames.addAll(orgRepositoryNames);
                    }
                    return repositoryNames;
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "an exception was thrown", e);
            throw new RuntimeException("authorization failed for user = " + this.getName(), e);
        }
    }

    public Set<String> listToNames(Collection<GHRepository> respositories) throws IOException {
        HashSet<String> names = new HashSet<String>();
        for (GHRepository repository : respositories) {
            String ownerName = repository.getOwner().getLogin();
            String repoName = repository.getName();
            names.add(ownerName + "/" + repoName);
        }
        return names;
    }

    public boolean isPublicRepository(final String repositoryName) {
        try {
            return (Boolean)publicRepositoryCache.get((Object)repositoryName, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    GHRepository repository = GithubAuthenticationToken.this.loadRepository(repositoryName);
                    return repository != null && !repository.isPrivate();
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "an exception was thrown", e);
            throw new RuntimeException("authorization failed for user = " + this.getName(), e);
        }
    }

    public GHUser loadUser(String username) throws IOException {
        GithubUser user;
        try {
            user = (GithubUser)usersByIdCache.getIfPresent((Object)username);
            if (this.gh != null && user == null && this.isAuthenticated()) {
                GHUser ghUser = this.getGitHub().getUser(username);
                user = new GithubUser(ghUser);
                usersByIdCache.put((Object)username, (Object)user);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
            user = UNKNOWN_USER;
            usersByIdCache.put((Object)username, (Object)UNKNOWN_USER);
        }
        return user != null ? user.user : null;
    }

    public GHOrganization loadOrganization(String organization) {
        try {
            if (this.gh != null && this.isAuthenticated()) {
                return this.getGitHub().getOrganization(organization);
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public GHRepository loadRepository(String repositoryName) {
        try {
            if (this.gh != null && this.isAuthenticated()) {
                return this.getGitHub().getRepository(repositoryName);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Looks like a bad GitHub URL OR the Jenkins user does not have access to the repository{0}", repositoryName);
        }
        return null;
    }

    public GHTeam loadTeam(String organization, String team) {
        try {
            GHOrganization org = this.loadOrganization(organization);
            if (org != null) {
                return org.getTeamByName(team);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public GithubOAuthUserDetails getUserDetails(String username) throws IOException {
        GHUser user = this.loadUser(username);
        if (user != null) {
            return new GithubOAuthUserDetails(user.getLogin(), this);
        }
        return null;
    }

    static class GithubUser {
        public final GHUser user;

        public GithubUser(GHUser user) {
            this.user = user;
        }
    }
}

