/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.kohsuke.stapler.export.Exported;

public class PullRequestSCMRevision
extends ChangeRequestSCMRevision<PullRequestSCMHead> {
    private static final long serialVersionUID = 1L;
    static final String NOT_MERGEABLE_HASH = "NOT_MERGEABLE";
    @NonNull
    private final String baseHash;
    @NonNull
    private final String pullHash;
    private final String mergeHash;

    public PullRequestSCMRevision(@NonNull PullRequestSCMHead head, @NonNull String baseHash, @NonNull String pullHash) {
        this(head, baseHash, pullHash, null);
    }

    PullRequestSCMRevision(@NonNull PullRequestSCMHead head, @NonNull String baseHash, @NonNull String pullHash, String mergeHash) {
        super((SCMHead)head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head.getTarget(), baseHash));
        this.baseHash = baseHash;
        this.pullHash = pullHash;
        this.mergeHash = mergeHash;
    }

    @SuppressFBWarnings(value={"SE_PRIVATE_READ_RESOLVE_NOT_INHERITED", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private Object readResolve() {
        if (this.getTarget() == null) {
            return new PullRequestSCMRevision((PullRequestSCMHead)this.getHead(), this.baseHash, this.pullHash);
        }
        return this;
    }

    @NonNull
    public String getBaseHash() {
        return this.baseHash;
    }

    @Exported
    @NonNull
    public String getPullHash() {
        return this.pullHash;
    }

    @CheckForNull
    public String getMergeHash() {
        return this.mergeHash;
    }

    void validateMergeHash() throws AbortException {
        if (this.mergeHash == NOT_MERGEABLE_HASH) {
            throw new AbortException("Pull request " + ((PullRequestSCMHead)this.getHead()).getNumber() + " : Not mergeable at " + this.toString());
        }
    }

    public boolean equivalent(ChangeRequestSCMRevision<?> o) {
        if (!(o instanceof PullRequestSCMRevision)) {
            return false;
        }
        PullRequestSCMRevision other = (PullRequestSCMRevision)o;
        return this.getHead().equals((Object)other.getHead()) && this.pullHash.equals(other.pullHash);
    }

    public int _hashCode() {
        return this.pullHash.hashCode();
    }

    public String toString() {
        String result = this.pullHash;
        if (this.getHead() instanceof PullRequestSCMHead && ((PullRequestSCMHead)this.getHead()).isMerge()) {
            result = result + "+" + this.baseHash + " (" + StringUtils.defaultIfBlank((String)this.mergeHash, (String)"UNKNOWN_MERGE_STATE") + ")";
        }
        return result;
    }
}

