/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.AbstractGitHubNotificationStrategy;
import org.jenkinsci.plugins.github_branch_source.DefaultGitHubNotificationStrategy;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceRequest;

public class GitHubSCMSourceContext
extends SCMSourceContext<GitHubSCMSourceContext, GitHubSCMSourceRequest> {
    private boolean wantBranches;
    private boolean wantTags;
    private boolean wantOriginPRs;
    private boolean wantForkPRs;
    @NonNull
    private Set<ChangeRequestCheckoutStrategy> originPRStrategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    @NonNull
    private Set<ChangeRequestCheckoutStrategy> forkPRStrategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    private boolean notificationsDisabled;
    private final List<AbstractGitHubNotificationStrategy> notificationStrategies = new ArrayList<AbstractGitHubNotificationStrategy>();

    public GitHubSCMSourceContext(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer) {
        super(criteria, observer);
    }

    public final boolean wantBranches() {
        return this.wantBranches;
    }

    public final boolean wantTags() {
        return this.wantTags;
    }

    public final boolean wantPRs() {
        return this.wantOriginPRs || this.wantForkPRs;
    }

    public final boolean wantOriginPRs() {
        return this.wantOriginPRs;
    }

    public final boolean wantForkPRs() {
        return this.wantForkPRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> originPRStrategies() {
        return this.originPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> forkPRStrategies() {
        return this.forkPRStrategies;
    }

    public final List<AbstractGitHubNotificationStrategy> notificationStrategies() {
        if (this.notificationStrategies.isEmpty()) {
            return Collections.singletonList(new DefaultGitHubNotificationStrategy());
        }
        return Collections.unmodifiableList(this.notificationStrategies);
    }

    public final boolean notificationsDisabled() {
        return this.notificationsDisabled;
    }

    @NonNull
    public GitHubSCMSourceContext wantBranches(boolean include) {
        this.wantBranches = this.wantBranches || include;
        return this;
    }

    @NonNull
    public GitHubSCMSourceContext wantTags(boolean include) {
        this.wantTags = this.wantTags || include;
        return this;
    }

    @NonNull
    public GitHubSCMSourceContext wantOriginPRs(boolean include) {
        this.wantOriginPRs = this.wantOriginPRs || include;
        return this;
    }

    @NonNull
    public GitHubSCMSourceContext wantForkPRs(boolean include) {
        this.wantForkPRs = this.wantForkPRs || include;
        return this;
    }

    @NonNull
    public GitHubSCMSourceContext withOriginPRStrategies(Set<ChangeRequestCheckoutStrategy> strategies) {
        this.originPRStrategies.addAll(strategies);
        return this;
    }

    @NonNull
    public GitHubSCMSourceContext withForkPRStrategies(Set<ChangeRequestCheckoutStrategy> strategies) {
        this.forkPRStrategies.addAll(strategies);
        return this;
    }

    @NonNull
    public final GitHubSCMSourceContext withNotificationStrategies(List<AbstractGitHubNotificationStrategy> strategies) {
        this.notificationStrategies.clear();
        for (AbstractGitHubNotificationStrategy strategy : strategies) {
            if (this.notificationStrategies.contains(strategy)) continue;
            this.notificationStrategies.add(strategy);
        }
        return this;
    }

    @NonNull
    public final GitHubSCMSourceContext withNotificationStrategy(AbstractGitHubNotificationStrategy strategy) {
        if (!this.notificationStrategies.contains(strategy)) {
            this.notificationStrategies.add(strategy);
        }
        return this;
    }

    @NonNull
    public final GitHubSCMSourceContext withNotificationsDisabled(boolean disabled) {
        this.notificationsDisabled = disabled;
        return this;
    }

    @NonNull
    public GitHubSCMSourceRequest newRequest(@NonNull SCMSource source, @CheckForNull TaskListener listener) {
        return new GitHubSCMSourceRequest(source, this, listener);
    }
}

