/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubWebHook;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCategory;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.UncategorizedSCMSourceCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.RegexSCMSourceFilterTrait;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.BranchDiscoveryTrait;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.jenkinsci.plugins.github_branch_source.ForkPullRequestDiscoveryTrait;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.jenkinsci.plugins.github_branch_source.GitHubConsoleNote;
import org.jenkinsci.plugins.github_branch_source.GitHubLink;
import org.jenkinsci.plugins.github_branch_source.GitHubOrgMetadataAction;
import org.jenkinsci.plugins.github_branch_source.GitHubOrgWebHook;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMBuilder;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigatorContext;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigatorRequest;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceBuilder;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceRequest;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.OriginPullRequestDiscoveryTrait;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.jenkinsci.plugins.github_branch_source.SSHCheckoutTrait;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitHubSCMNavigator
extends SCMNavigator {
    @NonNull
    private final String repoOwner;
    @CheckForNull
    private String apiUri;
    @CheckForNull
    private String credentialsId;
    @NonNull
    private List<SCMTrait<? extends SCMTrait<?>>> traits;
    @Deprecated
    private transient String scanCredentialsId;
    @Deprecated
    private transient String checkoutCredentialsId;
    @Deprecated
    private transient String pattern;
    @Deprecated
    private String includes;
    @Deprecated
    private String excludes;
    @Deprecated
    private transient Boolean buildOriginBranch;
    @Deprecated
    private transient Boolean buildOriginBranchWithPR;
    @Deprecated
    private transient Boolean buildOriginPRMerge;
    @Deprecated
    private transient Boolean buildOriginPRHead;
    @Deprecated
    private transient Boolean buildForkPRMerge;
    @Deprecated
    private transient Boolean buildForkPRHead;

    @DataBoundConstructor
    public GitHubSCMNavigator(String repoOwner) {
        this.repoOwner = StringUtils.defaultString((String)repoOwner);
        this.traits = new ArrayList();
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public GitHubSCMNavigator(String apiUri, String repoOwner, String scanCredentialsId, String checkoutCredentialsId) {
        this(repoOwner);
        this.setCredentialsId(scanCredentialsId);
        this.setApiUri(apiUri);
        this.traits = new ArrayList();
        this.traits.add((SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(true, true));
        this.traits.add((SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
        if (!"SAME".equals(checkoutCredentialsId)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new SSHCheckoutTrait(checkoutCredentialsId));
        }
    }

    @CheckForNull
    public String getApiUri() {
        return this.apiUri;
    }

    @DataBoundSetter
    public void setApiUri(String apiUri) {
        this.apiUri = "https://api.github.com".equals(apiUri = GitHubConfiguration.normalizeApiUri(Util.fixEmptyAndTrim((String)apiUri))) ? null : apiUri;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @NonNull
    public String getRepoOwner() {
        return this.repoOwner;
    }

    @NonNull
    public List<SCMTrait<? extends SCMTrait<?>>> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull SCMTrait[] traits) {
        this.traits = new ArrayList();
        if (traits != null) {
            for (SCMTrait trait : traits) {
                this.traits.add(trait);
            }
        }
    }

    public void setTraits(@CheckForNull List<SCMTrait<? extends SCMTrait<?>>> traits) {
        this.traits = traits != null ? new ArrayList(traits) : new ArrayList();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() {
        if (this.scanCredentialsId != null) {
            this.credentialsId = this.scanCredentialsId;
        }
        if (this.traits == null) {
            EnumSet<ChangeRequestCheckoutStrategy> s;
            boolean buildOriginBranch = this.buildOriginBranch == null || this.buildOriginBranch != false;
            boolean buildOriginBranchWithPR = this.buildOriginBranchWithPR == null || this.buildOriginBranchWithPR != false;
            boolean buildOriginPRMerge = this.buildOriginPRMerge != null && this.buildOriginPRMerge != false;
            boolean buildOriginPRHead = this.buildOriginPRHead != null && this.buildOriginPRHead != false;
            boolean buildForkPRMerge = this.buildForkPRMerge == null || this.buildForkPRMerge != false;
            boolean buildForkPRHead = this.buildForkPRHead != null && this.buildForkPRHead != false;
            ArrayList traits = new ArrayList();
            if (buildOriginBranch || buildOriginBranchWithPR) {
                traits.add((SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(buildOriginBranch, buildOriginBranchWithPR));
            }
            if (buildOriginPRMerge || buildOriginPRHead) {
                s = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
                if (buildOriginPRMerge) {
                    s.add(ChangeRequestCheckoutStrategy.MERGE);
                }
                if (buildOriginPRHead) {
                    s.add(ChangeRequestCheckoutStrategy.HEAD);
                }
                traits.add((SCMTrait<SCMTrait<?>>)new OriginPullRequestDiscoveryTrait(s));
            }
            if (buildForkPRMerge || buildForkPRHead) {
                s = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
                if (buildForkPRMerge) {
                    s.add(ChangeRequestCheckoutStrategy.MERGE);
                }
                if (buildForkPRHead) {
                    s.add(ChangeRequestCheckoutStrategy.HEAD);
                }
                traits.add((SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(s, (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
            }
            if (this.checkoutCredentialsId != null && !"SAME".equals(this.checkoutCredentialsId) && !this.checkoutCredentialsId.equals(this.scanCredentialsId)) {
                traits.add((SCMTrait<SCMTrait<?>>)new SSHCheckoutTrait(this.checkoutCredentialsId));
            }
            if (this.includes != null && !"*".equals(this.includes) || this.excludes != null && !"".equals(this.excludes)) {
                traits.add((SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(StringUtils.defaultIfBlank((String)this.includes, (String)"*"), StringUtils.defaultIfBlank((String)this.excludes, (String)"")));
            }
            if (this.pattern != null && !".*".equals(this.pattern)) {
                traits.add((SCMTrait<SCMTrait<?>>)new RegexSCMSourceFilterTrait(this.pattern));
            }
            this.traits = traits;
        }
        if (!StringUtils.equals((String)this.apiUri, (String)GitHubConfiguration.normalizeApiUri(this.apiUri))) {
            this.setApiUri(this.apiUri);
        }
        return this;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getScanCredentialsId() {
        return this.credentialsId;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setScanCredentialsId(@CheckForNull String scanCredentialsId) {
        this.credentialsId = scanCredentialsId;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getIncludes() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)sCMTrait).getIncludes();
        }
        return "*";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getExcludes() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)sCMTrait).getExcludes();
        }
        return "";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setIncludes(@NonNull String includes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(includes) && "".equals(existing.getExcludes())) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(includes, existing.getExcludes()));
            }
            return;
        }
        if (!"*".equals(includes)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(includes, ""));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setExcludes(@NonNull String excludes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(existing.getIncludes()) && "".equals(excludes)) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait(existing.getIncludes(), excludes));
            }
            return;
        }
        if (!"".equals(excludes)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new WildcardSCMHeadFilterTrait("*", excludes));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginBranch() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof BranchDiscoveryTrait)) continue;
            return ((BranchDiscoveryTrait)sCMTrait).isBuildBranch();
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginBranch(boolean buildOriginBranch) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof BranchDiscoveryTrait)) continue;
            BranchDiscoveryTrait previous = (BranchDiscoveryTrait)trait;
            if (buildOriginBranch || previous.isBuildBranchesWithPR()) {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(buildOriginBranch, previous.isBuildBranchesWithPR()));
            } else {
                this.traits.remove(i);
            }
            return;
        }
        if (buildOriginBranch) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(buildOriginBranch, false));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginBranchWithPR() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof BranchDiscoveryTrait)) continue;
            return ((BranchDiscoveryTrait)sCMTrait).isBuildBranchesWithPR();
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginBranchWithPR(boolean buildOriginBranchWithPR) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof BranchDiscoveryTrait)) continue;
            BranchDiscoveryTrait previous = (BranchDiscoveryTrait)trait;
            if (buildOriginBranchWithPR || previous.isBuildBranch()) {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(previous.isBuildBranch(), buildOriginBranchWithPR));
            } else {
                this.traits.remove(i);
            }
            return;
        }
        if (buildOriginBranchWithPR) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new BranchDiscoveryTrait(false, buildOriginBranchWithPR));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginPRMerge() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof OriginPullRequestDiscoveryTrait)) continue;
            return ((OriginPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.MERGE);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginPRMerge(boolean buildOriginPRMerge) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof OriginPullRequestDiscoveryTrait)) continue;
            Set<ChangeRequestCheckoutStrategy> s = ((OriginPullRequestDiscoveryTrait)trait).getStrategies();
            if (buildOriginPRMerge) {
                s.add(ChangeRequestCheckoutStrategy.MERGE);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.MERGE);
            }
            this.traits.set(i, (SCMTrait<SCMTrait<?>>)new OriginPullRequestDiscoveryTrait(s));
            return;
        }
        if (buildOriginPRMerge) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginPRHead() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof OriginPullRequestDiscoveryTrait)) continue;
            return ((OriginPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.HEAD);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginPRHead(boolean buildOriginPRHead) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof OriginPullRequestDiscoveryTrait)) continue;
            Set<ChangeRequestCheckoutStrategy> s = ((OriginPullRequestDiscoveryTrait)trait).getStrategies();
            if (buildOriginPRHead) {
                s.add(ChangeRequestCheckoutStrategy.HEAD);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.HEAD);
            }
            this.traits.set(i, (SCMTrait<SCMTrait<?>>)new OriginPullRequestDiscoveryTrait(s));
            return;
        }
        if (buildOriginPRHead) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD)));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildForkPRMerge() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof ForkPullRequestDiscoveryTrait)) continue;
            return ((ForkPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.MERGE);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildForkPRMerge(boolean buildForkPRMerge) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof ForkPullRequestDiscoveryTrait)) continue;
            ForkPullRequestDiscoveryTrait forkTrait = (ForkPullRequestDiscoveryTrait)trait;
            Set<ChangeRequestCheckoutStrategy> s = forkTrait.getStrategies();
            if (buildForkPRMerge) {
                s.add(ChangeRequestCheckoutStrategy.MERGE);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.MERGE);
            }
            this.traits.set(i, (SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(s, forkTrait.getTrust()));
            return;
        }
        if (buildForkPRMerge) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildForkPRHead() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof ForkPullRequestDiscoveryTrait)) continue;
            return ((ForkPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.HEAD);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildForkPRHead(boolean buildForkPRHead) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof ForkPullRequestDiscoveryTrait)) continue;
            ForkPullRequestDiscoveryTrait forkTrait = (ForkPullRequestDiscoveryTrait)trait;
            Set<ChangeRequestCheckoutStrategy> s = forkTrait.getStrategies();
            if (buildForkPRHead) {
                s.add(ChangeRequestCheckoutStrategy.HEAD);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.HEAD);
            }
            this.traits.set(i, (SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(s, forkTrait.getTrust()));
            return;
        }
        if (buildForkPRHead) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD), (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @CheckForNull
    @RestrictedSince(value="2.2.0")
    public String getCheckoutCredentialsId() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof SSHCheckoutTrait)) continue;
            return StringUtils.defaultString((String)((SSHCheckoutTrait)sCMTrait).getCredentialsId(), (String)"ANONYMOUS");
        }
        return "SAME";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public String getPattern() {
        for (SCMTrait<? extends SCMTrait<?>> sCMTrait : this.traits) {
            if (!(sCMTrait instanceof RegexSCMSourceFilterTrait)) continue;
            return ((RegexSCMSourceFilterTrait)sCMTrait).getRegex();
        }
        return ".*";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setPattern(String pattern) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait<? extends SCMTrait<?>> trait = this.traits.get(i);
            if (!(trait instanceof RegexSCMSourceFilterTrait)) continue;
            if (".*".equals(pattern)) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMTrait<SCMTrait<?>>)new RegexSCMSourceFilterTrait(pattern));
            }
            return;
        }
        if (!".*".equals(pattern)) {
            this.traits.add((SCMTrait<SCMTrait<?>>)new RegexSCMSourceFilterTrait(pattern));
        }
    }

    @NonNull
    protected String id() {
        return StringUtils.defaultIfBlank((String)this.apiUri, (String)"https://api.github.com") + "::" + this.repoOwner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitSources(SCMSourceObserver observer) throws IOException, InterruptedException {
        GHMyself myself;
        WitnessImpl witness;
        SourceFactory sourceFactory;
        GitHubSCMNavigatorRequest request;
        GitHub github;
        TaskListener listener;
        block31: {
            block30: {
                Set includes = observer.getIncludes();
                if (includes != null && includes.size() == 1) {
                    this.visitSource((String)includes.iterator().next(), observer);
                    return;
                }
                listener = observer.getListener();
                if (this.repoOwner.isEmpty()) {
                    throw new AbortException("Must specify user or organization");
                }
                StandardCredentials credentials = Connector.lookupScanCredentials((Item)observer.getContext(), this.apiUri, this.credentialsId);
                github = Connector.connect(this.apiUri, credentials);
                Connector.checkConnectionValidity(this.apiUri, listener, credentials, github);
                Connector.checkApiRateLimit(listener, github);
                if (credentials != null && !Connector.isCredentialValid(github)) {
                    String message = String.format("Invalid scan credentials %s to connect to %s, skipping", CredentialsNameProvider.name((Credentials)credentials), this.apiUri == null ? "https://api.github.com" : this.apiUri);
                    throw new AbortException(message);
                }
                request = ((GitHubSCMNavigatorContext)new GitHubSCMNavigatorContext().withTraits(this.traits)).newRequest(this, observer);
                sourceFactory = new SourceFactory(request);
                witness = new WitnessImpl(listener);
                if (github.isAnonymous()) break block30;
                try {
                    myself = github.getMyself();
                }
                catch (RateLimitExceededException rle) {
                    throw new AbortException(rle.getMessage());
                }
                if (myself != null && this.repoOwner.equalsIgnoreCase(myself.getLogin())) break block31;
            }
            GHOrganization org = null;
            try {
                org = github.getOrganization(this.repoOwner);
            }
            catch (RateLimitExceededException rle) {
                throw new AbortException(rle.getMessage());
            }
            catch (FileNotFoundException rle) {
                // empty catch block
            }
            if (org != null && this.repoOwner.equalsIgnoreCase(org.getLogin())) {
                listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("Looking up repositories of organization %s", this.repoOwner)));
                PagedIterator rle = org.listRepositories(100).iterator();
                while (true) {
                    if (!rle.hasNext()) {
                        listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed", witness.getCount())));
                        return;
                    }
                    GHRepository repo = (GHRepository)rle.next();
                    Connector.checkApiRateLimit(listener, github);
                    if (!request.process(repo.getName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) continue;
                    listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed (query completed)", witness.getCount())));
                }
            }
            GHUser user = null;
            try {
                user = github.getUser(this.repoOwner);
            }
            catch (RateLimitExceededException rle) {
                throw new AbortException(rle.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (user == null) throw new AbortException(this.repoOwner + " does not correspond to a known GitHub User Account or Organization");
            if (!this.repoOwner.equalsIgnoreCase(user.getLogin())) throw new AbortException(this.repoOwner + " does not correspond to a known GitHub User Account or Organization");
            listener.getLogger().format("Looking up repositories of user %s%n%n", this.repoOwner);
            Connector.checkApiRateLimit(listener, github);
            for (GHRepository repo : user.listRepositories(100)) {
                Connector.checkApiRateLimit(listener, github);
                if (!request.process(repo.getName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) continue;
                listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed (query completed)", witness.getCount())));
            }
            listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed", witness.getCount())));
            return;
            finally {
                request.close();
            }
            finally {
                Connector.release(github);
            }
        }
        listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("Looking up repositories of myself %s", this.repoOwner)));
        PagedIterator rle = myself.listRepositories(100).iterator();
        while (true) {
            if (!rle.hasNext()) {
                listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed", witness.getCount())));
                return;
            }
            GHRepository repo = (GHRepository)rle.next();
            Connector.checkApiRateLimit(listener, github);
            if (!repo.getOwnerName().equals(this.repoOwner) || !request.process(repo.getName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) continue;
            listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed (query completed)", witness.getCount())));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitSource(String sourceName, SCMSourceObserver observer) throws IOException, InterruptedException {
        TaskListener listener = observer.getListener();
        if (this.repoOwner.isEmpty()) {
            throw new AbortException("Must specify user or organization");
        }
        StandardCredentials credentials = Connector.lookupScanCredentials((Item)observer.getContext(), this.apiUri, this.credentialsId);
        GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            try {
                Connector.checkApiUrlValidity(github, credentials);
            }
            catch (HttpException e) {
                String message = String.format("It seems %s is unreachable", this.apiUri == null ? "https://api.github.com" : this.apiUri);
                throw new AbortException(message);
            }
            if (credentials != null && !Connector.isCredentialValid(github)) {
                String message = String.format("Invalid scan credentials %s to connect to %s, skipping", CredentialsNameProvider.name((Credentials)credentials), this.apiUri == null ? "https://api.github.com" : this.apiUri);
                throw new AbortException(message);
            }
            try (GitHubSCMNavigatorRequest request = ((GitHubSCMNavigatorContext)new GitHubSCMNavigatorContext().withTraits(this.traits)).newRequest(this, observer);){
                SourceFactory sourceFactory = new SourceFactory(request);
                WitnessImpl witness = new WitnessImpl(listener);
                if (!github.isAnonymous()) {
                    GHMyself myself;
                    listener.getLogger().format("Connecting to %s using %s%n", this.apiUri == null ? "https://api.github.com" : this.apiUri, CredentialsNameProvider.name((Credentials)credentials));
                    try {
                        myself = github.getMyself();
                    }
                    catch (RateLimitExceededException rle) {
                        throw new AbortException(rle.getMessage());
                    }
                    if (myself != null && this.repoOwner.equalsIgnoreCase(myself.getLogin())) {
                        listener.getLogger().format("Looking up %s repository of myself %s%n%n", sourceName, this.repoOwner);
                        GHRepository repo = myself.getRepository(sourceName);
                        if (repo != null && repo.getOwnerName().equals(this.repoOwner) && request.process(repo.getName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) {
                            listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed (query completed)", witness.getCount())));
                        }
                        listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed", witness.getCount())));
                        return;
                    }
                } else {
                    listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.apiUri == null ? "https://api.github.com" : this.apiUri);
                }
                GHOrganization org = null;
                try {
                    org = github.getOrganization(this.repoOwner);
                }
                catch (RateLimitExceededException rle) {
                    throw new AbortException(rle.getMessage());
                }
                catch (FileNotFoundException rle) {
                    // empty catch block
                }
                if (org != null && this.repoOwner.equalsIgnoreCase(org.getLogin())) {
                    listener.getLogger().format("Looking up %s repository of organization %s%n%n", sourceName, this.repoOwner);
                    GHRepository repo = org.getRepository(sourceName);
                    if (repo != null && request.process(repo.getName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) {
                        listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed (query completed)", witness.getCount())));
                    }
                    listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed", witness.getCount())));
                    return;
                }
                GHUser user = null;
                try {
                    user = github.getUser(this.repoOwner);
                }
                catch (RateLimitExceededException rle) {
                    throw new AbortException(rle.getMessage());
                }
                catch (FileNotFoundException rle) {
                    // empty catch block
                }
                if (user == null) throw new AbortException(this.repoOwner + " does not correspond to a known GitHub User Account or Organization");
                if (!this.repoOwner.equalsIgnoreCase(user.getLogin())) throw new AbortException(this.repoOwner + " does not correspond to a known GitHub User Account or Organization");
                listener.getLogger().format("Looking up %s repository of user %s%n%n", sourceName, this.repoOwner);
                GHRepository repo = user.getRepository(sourceName);
                if (repo != null && request.process(repo.getName(), sourceFactory, null, new SCMNavigatorRequest.Witness[]{witness})) {
                    listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed (query completed)", witness.getCount())));
                }
                listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("%d repositories were processed", witness.getCount())));
                return;
            }
        }
        finally {
            Connector.release(github);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, @CheckForNull SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().printf("Looking up details of %s...%n", this.getRepoOwner());
        ArrayList<Action> result = new ArrayList<Action>();
        StandardCredentials credentials = Connector.lookupScanCredentials((Item)owner, this.getApiUri(), this.credentialsId);
        GitHub hub = Connector.connect(this.getApiUri(), credentials);
        try {
            Connector.checkApiRateLimit(listener, hub);
            GHUser u = hub.getUser(this.getRepoOwner());
            String objectUrl = u.getHtmlUrl() == null ? null : u.getHtmlUrl().toExternalForm();
            result.add((Action)new ObjectMetadataAction(Util.fixEmpty((String)u.getName()), null, objectUrl));
            result.add((Action)new GitHubOrgMetadataAction(u));
            result.add(new GitHubLink("icon-github-logo", u.getHtmlUrl()));
            if (objectUrl == null) {
                listener.getLogger().println("Organization URL: unspecified");
            } else {
                listener.getLogger().printf("Organization URL: %s%n", HyperlinkNote.encodeTo((String)objectUrl, (String)StringUtils.defaultIfBlank((String)u.getName(), (String)objectUrl)));
            }
            ArrayList<Action> arrayList = result;
            return arrayList;
        }
        finally {
            Connector.release(hub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSave(@NonNull SCMNavigatorOwner owner) {
        GitHubWebHook.get().registerHookFor((Item)owner);
        try {
            StandardCredentials credentials = Connector.lookupScanCredentials((Item)owner, this.getApiUri(), this.credentialsId);
            GitHub hub = Connector.connect(this.getApiUri(), credentials);
            try {
                GitHubOrgWebHook.register(hub, this.repoOwner);
            }
            finally {
                Connector.release(hub);
            }
        }
        catch (IOException e) {
            DescriptorImpl.LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private class SourceFactory
    implements SCMNavigatorRequest.SourceLambda {
        private final GitHubSCMNavigatorRequest request;

        public SourceFactory(GitHubSCMNavigatorRequest request) {
            this.request = request;
        }

        @NonNull
        public SCMSource create(@NonNull String name) {
            return ((GitHubSCMSourceBuilder)new GitHubSCMSourceBuilder(GitHubSCMNavigator.this.getId() + "::" + name, GitHubSCMNavigator.this.apiUri, GitHubSCMNavigator.this.credentialsId, GitHubSCMNavigator.this.repoOwner, name).withRequest(this.request)).build();
        }
    }

    private static class WitnessImpl
    implements SCMNavigatorRequest.Witness {
        @GuardedBy(value="this")
        private int count;
        @NonNull
        private final TaskListener listener;

        public WitnessImpl(@NonNull TaskListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(@NonNull String name, boolean isMatch) {
            if (isMatch) {
                this.listener.getLogger().format("Proposing %s%n", name);
                WitnessImpl witnessImpl = this;
                synchronized (witnessImpl) {
                    ++this.count;
                }
            } else {
                this.listener.getLogger().format("Ignoring %s%n", name);
            }
        }

        public synchronized int getCount() {
            return this.count;
        }
    }

    @Symbol(value={"github"})
    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor
    implements IconSpec {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final String defaultIncludes = "*";
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final String defaultExcludes = "";
        public static final String SAME = "SAME";
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginBranch = true;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginBranchWithPR = true;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginPRMerge = false;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginPRHead = false;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildForkPRMerge = false;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildForkPRHead = false;
        @Inject
        private GitHubSCMSource.DescriptorImpl delegate;

        public String getPronoun() {
            return Messages.GitHubSCMNavigator_Pronoun();
        }

        public String getDisplayName() {
            return Messages.GitHubSCMNavigator_DisplayName();
        }

        public String getDescription() {
            return Messages.GitHubSCMNavigator_Description();
        }

        public String getIconFilePathPattern() {
            return "plugin/github-branch-source/images/:size/github-scmnavigator.png";
        }

        public String getIconClassName() {
            return "icon-github-scm-navigator";
        }

        public SCMNavigator newInstance(String name) {
            GitHubSCMNavigator navigator = new GitHubSCMNavigator(name);
            navigator.setTraits(this.getTraitsDefaults());
            return navigator;
        }

        @NonNull
        protected SCMSourceCategory[] createCategories() {
            return new SCMSourceCategory[]{new UncategorizedSCMSourceCategory(Messages._GitHubSCMNavigator_UncategorizedCategory())};
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            return Connector.checkScanCredentials(context, apiUri, credentialsId);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            if (context == null ? !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return Connector.listScanCredentials(context, apiUri);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillApiUriItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("GitHub", defaultExcludes);
            for (Endpoint e : GitHubConfiguration.get().getEndpoints()) {
                result.add(e.getName() == null ? e.getApiUri() : e.getName() + " (" + e.getApiUri() + ")", e.getApiUri());
            }
            return result;
        }

        public boolean isApiUriSelectable() {
            return !GitHubConfiguration.get().getEndpoints().isEmpty();
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            GitHubSCMSource.DescriptorImpl sourceDescriptor = (GitHubSCMSource.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(GitHubSCMSource.DescriptorImpl.class);
            ArrayList all = new ArrayList();
            all.addAll(SCMNavigatorTrait._for((SCMNavigatorDescriptor)this, GitHubSCMNavigatorContext.class, GitHubSCMSourceBuilder.class));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, GitHubSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, null, GitHubSCMBuilder.class));
            HashSet<SCMTraitDescriptor> dedup = new HashSet<SCMTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMTraitDescriptor d = (SCMTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList result = new ArrayList();
            NamedArrayList.select(all, (String)"Repositories", (NamedArrayList.Predicate)new NamedArrayList.Predicate<SCMTraitDescriptor<?>>(){

                public boolean test(SCMTraitDescriptor<?> scmTraitDescriptor) {
                    return scmTraitDescriptor instanceof SCMNavigatorTraitDescriptor;
                }
            }, (boolean)true, result);
            NamedArrayList.select(all, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select(all, (String)"General", null, (boolean)true, result);
            return result;
        }

        public List<SCMTrait<? extends SCMTrait<?>>> getTraitsDefaults() {
            ArrayList result = new ArrayList();
            result.addAll(this.delegate.getTraitsDefaults());
            return result;
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-github-scm-navigator icon-sm", "plugin/github-branch-source/images/16x16/github-scmnavigator.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-github-scm-navigator icon-md", "plugin/github-branch-source/images/24x24/github-scmnavigator.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-github-scm-navigator icon-lg", "plugin/github-branch-source/images/32x32/github-scmnavigator.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-github-scm-navigator icon-xlg", "plugin/github-branch-source/images/48x48/github-scmnavigator.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-github-logo icon-sm", "plugin/github-branch-source/images/16x16/github-logo.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-github-logo icon-md", "plugin/github-branch-source/images/24x24/github-logo.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-github-logo icon-lg", "plugin/github-branch-source/images/32x32/github-logo.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-github-logo icon-xlg", "plugin/github-branch-source/images/48x48/github-logo.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-github-repo icon-sm", "plugin/github-branch-source/images/16x16/github-repo.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-github-repo icon-md", "plugin/github-branch-source/images/24x24/github-repo.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-github-repo icon-lg", "plugin/github-branch-source/images/32x32/github-repo.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-github-repo icon-xlg", "plugin/github-branch-source/images/48x48/github-repo.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-github-branch icon-sm", "plugin/github-branch-source/images/16x16/github-branch.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-github-branch icon-md", "plugin/github-branch-source/images/24x24/github-branch.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-github-branch icon-lg", "plugin/github-branch-source/images/32x32/github-branch.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-github-branch icon-xlg", "plugin/github-branch-source/images/48x48/github-branch.png", "width: 48px; height: 48px;"));
        }
    }
}

