/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class GitHubConsoleNote
extends ConsoleNote {
    private static final Logger LOGGER = Logger.getLogger(GitHubConsoleNote.class.getName());
    private static final long serialVersionUID = 1L;
    private final long timestamp;

    public GitHubConsoleNote(long timestamp) {
        this.timestamp = timestamp;
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        text.addMarkup(0, text.length(), String.format("<span class='greyed'><small>%tT</small> ", this.timestamp), "</span>");
        return null;
    }

    public static String create(long timestamp, String text) {
        try {
            return new GitHubConsoleNote(timestamp).encode() + text;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize " + GitHubConsoleNote.class, e);
            return text;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        public String getDisplayName() {
            return "GitHub API Usage";
        }
    }
}

