/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.trait.SCMSourceBuilder;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

public class GitHubSCMSourceBuilder
extends SCMSourceBuilder<GitHubSCMSourceBuilder, GitHubSCMSource> {
    @CheckForNull
    private final String id;
    @CheckForNull
    private final String apiUri;
    @CheckForNull
    private final String credentialsId;
    @NonNull
    private final String repoOwner;

    public GitHubSCMSourceBuilder(@CheckForNull String id, @CheckForNull String apiUri, @CheckForNull String credentialsId, @NonNull String repoOwner, @NonNull String repoName) {
        super(GitHubSCMSource.class, repoName);
        this.id = id;
        this.apiUri = apiUri;
        this.repoOwner = repoOwner;
        this.credentialsId = credentialsId;
    }

    public final String id() {
        return this.id;
    }

    @CheckForNull
    public final String apiUri() {
        return this.apiUri;
    }

    @CheckForNull
    public final String credentialsId() {
        return this.credentialsId;
    }

    @NonNull
    public final String repoOwner() {
        return this.repoOwner;
    }

    @NonNull
    public GitHubSCMSource build() {
        GitHubSCMSource result = new GitHubSCMSource(this.repoOwner, this.projectName());
        result.setId(this.id());
        result.setApiUri(this.apiUri());
        result.setCredentialsId(this.credentialsId());
        result.setTraits(this.traits());
        return result;
    }
}

