/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.TagSCMHead;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.springframework.security.core.Authentication;

public abstract class GitSCMTelescope
extends SCMFileSystem.Builder {
    @CheckForNull
    public static GitSCMTelescope of(@NonNull GitSCM source) {
        for (SCMFileSystem.Builder b : ExtensionList.lookup(SCMFileSystem.Builder.class)) {
            if (b instanceof GitSCMTelescope) {
                GitSCMTelescope telescope = (GitSCMTelescope)b;
                if (b.supports((SCM)source)) {
                    return telescope;
                }
            }
            if (!(b instanceof GitSCMFileSystem.BuilderImpl)) continue;
            break;
        }
        return null;
    }

    @CheckForNull
    public static GitSCMTelescope of(@NonNull AbstractGitSCMSource source) {
        for (SCMFileSystem.Builder b : ExtensionList.lookup(SCMFileSystem.Builder.class)) {
            if (b instanceof GitSCMTelescope) {
                GitSCMTelescope telescope = (GitSCMTelescope)b;
                if (b.supports((SCMSource)source)) {
                    return telescope;
                }
            }
            if (!GitSCMFileSystem.BuilderImpl.class.equals(b.getClass())) continue;
            break;
        }
        return null;
    }

    public abstract boolean supports(@NonNull String var1);

    public abstract void validate(@NonNull String var1, @CheckForNull StandardCredentials var2) throws IOException, InterruptedException;

    public final boolean supports(@NonNull SCM source) {
        if (source instanceof GitSCM) {
            GitSCM git = (GitSCM)source;
            List<UserRemoteConfig> configs = git.getUserRemoteConfigs();
            List<BranchSpec> branches = git.getBranches();
            if (configs.size() == 1) {
                String remote = configs.get(0).getUrl();
                return remote != null && this.supports(remote) && branches.size() == 1 && !branches.get(0).getName().contains("*");
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean supports(@NonNull SCMSource source) {
        if (!(source instanceof AbstractGitSCMSource)) return false;
        AbstractGitSCMSource agscms = (AbstractGitSCMSource)source;
        if (source.getOwner() == null) return false;
        if (!this.supports(agscms.getRemote())) return false;
        return true;
    }

    public final SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        SCMSourceOwner owner = source.getOwner();
        if (source instanceof AbstractGitSCMSource) {
            AbstractGitSCMSource git = (AbstractGitSCMSource)source;
            if (owner != null && this.supports(git.getRemote())) {
                String remote = git.getRemote();
                StandardUsernameCredentials credentials = git.getCredentials();
                this.validate(remote, (StandardCredentials)credentials);
                return this.build(remote, (StandardCredentials)credentials, head, rev);
            }
        }
        return null;
    }

    public final SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, SCMRevision rev) throws IOException, InterruptedException {
        if (scm instanceof GitSCM) {
            UserRemoteConfig config;
            String remote;
            GitSCM git = (GitSCM)scm;
            List<UserRemoteConfig> configs = git.getUserRemoteConfigs();
            List<BranchSpec> branches = git.getBranches();
            if (configs.size() == 1 && (remote = (config = configs.get(0)).getUrl()) != null && this.supports(remote) && branches.size() == 1 && !branches.get(0).getName().contains("*")) {
                String name;
                StandardUsernameCredentials credentials;
                String credentialsId = config.getCredentialsId();
                if (credentialsId != null) {
                    Authentication authentication;
                    if (owner instanceof Queue.Task) {
                        Queue.Task t = (Queue.Task)owner;
                        authentication = Tasks.getAuthenticationOf2((Queue.Task)t);
                    } else {
                        authentication = ACL.SYSTEM2;
                    }
                    StandardUsernameCredentials credential = (StandardUsernameCredentials)CredentialsProvider.findCredentialByIdInItem((String)credentialsId, StandardUsernameCredentials.class, (Item)owner, (Authentication)authentication, (List)URIRequirementBuilder.fromUri((String)remote).build());
                    credentials = credential != null && GitClient.CREDENTIALS_MATCHER.matches((Credentials)credential) ? credential : null;
                } else {
                    credentials = null;
                }
                this.validate(remote, (StandardCredentials)credentials);
                SCMHead head = rev == null ? ((name = branches.get(0).getName()).startsWith("refs/tags/") ? new GitTagSCMHead(name.substring("refs/tags/".length()), this.getTimestamp(remote, (StandardCredentials)credentials, name)) : (name.startsWith("refs/heads/") ? new GitBranchSCMHead(name.substring("refs/heads/".length())) : (name.startsWith(config.getName() + "/") ? new GitBranchSCMHead(name.substring(config.getName().length() + 1)) : new GitBranchSCMHead(name)))) : rev.getHead();
                return this.build(remote, (StandardCredentials)credentials, head, rev);
            }
        }
        return null;
    }

    @CheckForNull
    protected abstract SCMFileSystem build(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull SCMHead var3, @CheckForNull SCMRevision var4) throws IOException, InterruptedException;

    public abstract long getTimestamp(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull String var3) throws IOException, InterruptedException;

    @CheckForNull
    public abstract SCMRevision getRevision(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull String var3) throws IOException, InterruptedException;

    public long getTimestamp(@NonNull String remote, @CheckForNull StandardCredentials credentials, @NonNull SCMHead head) throws IOException, InterruptedException {
        if (head instanceof TagSCMHead) {
            return this.getTimestamp(remote, credentials, "refs/tags/" + head.getName());
        }
        return this.getTimestamp(remote, credentials, "refs/heads/" + head.getName());
    }

    @CheckForNull
    public SCMRevision getRevision(@NonNull String remote, @CheckForNull StandardCredentials credentials, @NonNull SCMHead head) throws IOException, InterruptedException {
        if (head instanceof TagSCMHead) {
            return this.getRevision(remote, credentials, "refs/tags/" + head.getName());
        }
        return this.getRevision(remote, credentials, "refs/heads/" + head.getName());
    }

    public final Iterable<SCMRevision> getRevisions(@NonNull String remote, @CheckForNull StandardCredentials credentials) throws IOException, InterruptedException {
        return this.getRevisions(remote, credentials, EnumSet.allOf(ReferenceType.class));
    }

    public abstract Iterable<SCMRevision> getRevisions(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull Set<ReferenceType> var3) throws IOException, InterruptedException;

    public abstract String getDefaultTarget(@NonNull String var1, @CheckForNull StandardCredentials var2) throws IOException, InterruptedException;

    public static enum ReferenceType {
        HEAD,
        TAG;

    }
}

