/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class PruneStaleTag
extends GitSCMExtension {
    private static final String TAG_REF = "refs/tags/";
    private final boolean pruneTags;

    @DataBoundConstructor
    public PruneStaleTag(boolean pruneTags) {
        this.pruneTags = pruneTags;
    }

    public boolean getPruneTags() {
        return this.pruneTags;
    }

    @Override
    public void decorateFetchCommand(GitSCM scm, @CheckForNull Run<?, ?> run, GitClient git, TaskListener listener, FetchCommand cmd) throws IOException, InterruptedException, GitException {
        if (!this.pruneTags) {
            return;
        }
        listener.getLogger().println("Pruning obsolete local tags that do not exist on remotes");
        HashMap localTags = new HashMap();
        git.getTags().forEach(t -> localTags.put(t.getName(), t.getSHA1()));
        if (localTags.isEmpty()) {
            return;
        }
        List<RemoteConfig> remoteRepos = run == null ? scm.getRepositories() : scm.getParamExpandedRepos(run, listener);
        for (RemoteConfig remote : remoteRepos) {
            for (URIish url : remote.getURIs()) {
                Map refs = git.getRemoteReferences(url.toASCIIString(), null, false, true);
                for (Map.Entry ref : refs.entrySet()) {
                    String remoteTagName = (String)ref.getKey();
                    if (remoteTagName.startsWith(TAG_REF)) {
                        remoteTagName = remoteTagName.substring(TAG_REF.length());
                    }
                    ObjectId remoteTagId = (ObjectId)ref.getValue();
                    if (!localTags.containsKey(remoteTagName) || !((ObjectId)localTags.get(remoteTagName)).equals((AnyObjectId)remoteTagId)) continue;
                    localTags.remove(remoteTagName);
                }
            }
        }
        for (String localTag : localTags.keySet()) {
            git.deleteTag(localTag);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PruneStaleTag that = (PruneStaleTag)((Object)o);
        return this.pruneTags == that.pruneTags;
    }

    public int hashCode() {
        return Objects.hashCode(this.pruneTags);
    }

    public String toString() {
        return "PruneStaleTag { " + this.pruneTags + " }";
    }

    @Symbol(value={"pruneTags"})
    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public GitSCMExtension newInstance(@NonNull StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            return new PruneStaleTag(true);
        }

        public String getDisplayName() {
            return "Prune stale tags";
        }
    }
}

