/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gittagmessage;

import hudson.EnvVars;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtilsTest;
import org.eclipse.jgit.util.SystemReader;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public abstract class AbstractGitTagMessageExtensionTest<J extends Job<J, R>, R extends Run<J, R>> {
    @Rule
    public final JenkinsRule r = new JenkinsRule();
    @Rule
    public final TemporaryFolder repoDir = new TemporaryFolder();
    private GitClient repo;

    protected abstract J configureGitTagMessageJob(String var1, String var2, boolean var3) throws Exception;

    private J configureGitTagMessageJob() throws Exception {
        return this.configureGitTagMessageJob("", "**", false);
    }

    protected abstract void assertBuildEnvironment(R var1, String var2, String var3) throws Exception;

    @Before
    public void setUp() throws Exception {
        SystemReader.getInstance().getUserConfig().clear();
        this.repo = Git.with((TaskListener)this.r.createTaskListener(), (EnvVars)GitUtilsTest.getConfigNoSystemEnvsVars()).in(this.repoDir.getRoot()).getClient();
        this.repo.init();
    }

    @Before
    public void allowNonRemoteCheckout() {
        GitSCM.ALLOW_LOCAL_CHECKOUT = true;
    }

    @After
    public void disallowNonRemoteCheckout() {
        GitSCM.ALLOW_LOCAL_CHECKOUT = false;
    }

    @Test
    public void commitWithoutTagShouldNotExportMessage() throws Exception {
        this.repo.commit("commit 1");
        J job = this.configureGitTagMessageJob();
        R build = this.buildJobAndAssertSuccess(job);
        this.assertBuildEnvironment(build, null, null);
    }

    @Test
    public void commitWithEmptyTagMessageShouldNotExportMessage() throws Exception {
        this.repo.commit("commit 1");
        this.repo.tag("release-1.0", null);
        J job = this.configureGitTagMessageJob();
        R run = this.buildJobAndAssertSuccess(job);
        this.assertBuildEnvironment(run, "release-1.0", null);
    }

    @Test
    public void commitWithTagShouldExportMessage() throws Exception {
        this.repo.commit("commit 1");
        this.repo.tag("release-1.0", "This is the first release. ");
        J job = this.configureGitTagMessageJob();
        R run = this.buildJobAndAssertSuccess(job);
        this.assertBuildEnvironment(run, "release-1.0", "This is the first release.");
    }

    @Test
    public void commitWithMultipleTagsShouldExportMessage() throws Exception {
        this.repo.commit("commit 1");
        this.repo.tag("release-candidate-1.0", "This is the first release candidate.");
        this.repo.tag("release-1.0", "This is the first release.");
        J job = this.configureGitTagMessageJob();
        R run = this.buildJobAndAssertSuccess(job);
        this.assertBuildEnvironment(run, "release-1.0", "This is the first release.");
    }

    @Test
    public void jobWithMatchingTagShouldExportThatTagMessage() throws Exception {
        this.repo.commit("commit 1");
        this.repo.tag("alpha/1", "Alpha #1");
        this.repo.tag("beta/1", "Beta #1");
        this.repo.tag("gamma/1", "Gamma #1");
        J job = this.configureGitTagMessageJob("+refs/tags/beta/*:refs/remotes/origin/tags/beta/*", "*/tags/beta/*", false);
        R run = this.buildJobAndAssertSuccess(job);
        this.assertBuildEnvironment(run, "beta/1", "Beta #1");
    }

    @Test
    public void commitWithTagOnPreviousCommitWithConfigurationOptInShouldExportThatTagMessage() throws Exception {
        this.repo.commit("commit 1");
        this.repo.tag("release-1.0", "This is the first release");
        this.repo.commit("commit 2");
        J job = this.configureGitTagMessageJob("", "**", true);
        R run = this.buildJobAndAssertSuccess(job);
        this.assertBuildEnvironment(run, "release-1.0", "This is the first release");
    }

    @Test
    public void commitWithMultipleTagsOnPreviousCommitWithConfigurationOptInShouldExportThatTagMessage() throws Exception {
        this.repo.commit("commit 1");
        this.repo.tag("release-candidate-1.0", "This is the first release candidate.");
        this.repo.tag("release-1.0", "This is the first release.");
        this.repo.commit("commit 2");
        J job = this.configureGitTagMessageJob("", "**", true);
        R run = this.buildJobAndAssertSuccess(job);
        this.assertBuildEnvironment(run, "release-1.0", "This is the first release.");
    }

    private R buildJobAndAssertSuccess(J job) throws Exception {
        Run build = this.r.buildAndAssertSuccess(job);
        Assert.assertNotNull((Object)build.getAction(BuildData.class));
        return (R)build;
    }
}

