/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.TagDiscoveryTrait;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.TestJGitAPIImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class AbstractGitSCMSourceWantTagsTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @ClassRule
    public static GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    private GitSCMSource source;
    private final TaskListener LISTENER = StreamTaskListener.fromStderr();
    private static final String LIGHTWEIGHT_TAG_NAME = "lightweight-tag";
    private static final String ANNOTATED_TAG_NAME = "annotated-tag";
    private static final String BRANCH_NAME = "dev";
    private static final boolean ORIGINAL_IGNORE_TAG_DISCOVERY_TRAIT = GitSCMSource.IGNORE_TAG_DISCOVERY_TRAIT;
    static boolean tagsFetched;

    @BeforeClass
    public static void fillSampleRepo() throws Exception {
        sampleRepo.init();
        sampleRepo.git("checkout", "-b", BRANCH_NAME);
        sampleRepo.write("file", "modified");
        sampleRepo.git("commit", "--all", "--message=dev-commit-1");
        sampleRepo.git("tag", LIGHTWEIGHT_TAG_NAME);
        sampleRepo.write("file", "modified2");
        sampleRepo.git("commit", "--all", "--message=dev-commit-2");
        sampleRepo.git("tag", "-a", ANNOTATED_TAG_NAME, "-m", "annotated-tag-message");
        sampleRepo.write("file", "modified3");
        sampleRepo.git("commit", "--all", "--message=dev-commit-3");
    }

    @Before
    public void setGitSCMSource() {
        this.source = new GitSCMSource(sampleRepo.toString());
    }

    @Before
    public void setMockGitClient() {
        System.setProperty(Git.class.getName() + ".mockClient", MockGitClientForTags.class.getName());
    }

    @After
    public void clearMockGitClient() {
        System.clearProperty(Git.class.getName() + ".mockClient");
    }

    @After
    public void resetIgnoreTagDiscoveryTrait() {
        GitSCMSource.IGNORE_TAG_DISCOVERY_TRAIT = ORIGINAL_IGNORE_TAG_DISCOVERY_TRAIT;
    }

    @Test
    public void indexingHasNoTrait() throws Exception {
        Set noHeads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat((Object)noHeads, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertFalse((boolean)tagsFetched);
    }

    @Test
    public void indexingHasNoTraitIgnoreTagDiscoveryTrait() throws Exception {
        GitSCMSource.IGNORE_TAG_DISCOVERY_TRAIT = true;
        Set noHeads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat((Object)noHeads, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertTrue((boolean)tagsFetched);
    }

    @Test
    public void indexingHasTagDiscoveryTrait() throws Exception {
        this.source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        Set taggedHeads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat(taggedHeads.stream().map(p -> p.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{LIGHTWEIGHT_TAG_NAME, ANNOTATED_TAG_NAME}));
        Assert.assertTrue((boolean)tagsFetched);
    }

    @Test
    public void indexingHasTagDiscoveryTraitIgnoreTagDiscoveryTrait() throws Exception {
        GitSCMSource.IGNORE_TAG_DISCOVERY_TRAIT = true;
        this.source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        Set taggedHeads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat(taggedHeads.stream().map(p -> p.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{LIGHTWEIGHT_TAG_NAME, ANNOTATED_TAG_NAME}));
        Assert.assertTrue((boolean)tagsFetched);
    }

    @Test
    public void indexingHasBranchDiscoveryTrait() throws Exception {
        this.source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Set branchHeads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat(branchHeads.stream().map(p -> p.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{BRANCH_NAME, "master"}));
        Assert.assertFalse((boolean)tagsFetched);
    }

    @Test
    public void indexingHasBranchDiscoveryTraitIgnoreTagDiscoveryTrait() throws Exception {
        GitSCMSource.IGNORE_TAG_DISCOVERY_TRAIT = true;
        this.source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Set branchHeads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat(branchHeads.stream().map(p -> p.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{BRANCH_NAME, "master"}));
        Assert.assertTrue((boolean)tagsFetched);
    }

    @Test
    public void indexingHasBranchAndTagDiscoveryTrait() throws Exception {
        this.source.setTraits(List.of(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Set heads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat(heads.stream().map(p -> p.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{BRANCH_NAME, "master", LIGHTWEIGHT_TAG_NAME, ANNOTATED_TAG_NAME}));
        Assert.assertTrue((boolean)tagsFetched);
    }

    @Test
    public void indexingHasBranchAndTagDiscoveryTraitIgnoreTagDiscoveryTrait() throws Exception {
        GitSCMSource.IGNORE_TAG_DISCOVERY_TRAIT = true;
        this.source.setTraits(List.of(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Set heads = this.source.fetch(this.LISTENER);
        MatcherAssert.assertThat(heads.stream().map(p -> p.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{BRANCH_NAME, "master", LIGHTWEIGHT_TAG_NAME, ANNOTATED_TAG_NAME}));
        Assert.assertTrue((boolean)tagsFetched);
    }

    public static class MockGitClientForTags
    extends TestJGitAPIImpl {
        public MockGitClientForTags(String exe, EnvVars env, File workspace, TaskListener listener) {
            super(workspace, listener);
        }

        public FetchCommand fetch_() {
            tagsFetched = true;
            final FetchCommand fetchCommand = super.fetch_();
            return new FetchCommand(){

                public FetchCommand from(URIish urIish, List<RefSpec> list) {
                    fetchCommand.from(urIish, list);
                    return this;
                }

                @Deprecated
                public FetchCommand prune() {
                    fetchCommand.prune(true);
                    return this;
                }

                public FetchCommand prune(boolean b) {
                    fetchCommand.prune(b);
                    return this;
                }

                public FetchCommand shallow(boolean b) {
                    fetchCommand.shallow(b);
                    return this;
                }

                public FetchCommand timeout(Integer integer) {
                    fetchCommand.timeout(integer);
                    return this;
                }

                public FetchCommand tags(boolean b) {
                    fetchCommand.tags(b);
                    tagsFetched = b;
                    return this;
                }

                public FetchCommand depth(Integer integer) {
                    fetchCommand.depth(integer);
                    return this;
                }

                public void execute() throws GitException, InterruptedException {
                    fetchCommand.execute();
                }
            };
        }
    }
}

