/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.properties.FolderCredentialsProvider;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.FreeStyleBuild;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.scm.SCMRevisionState;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitRefSCMHead;
import jenkins.plugins.git.GitRemoteHeadRefAction;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSCMSourceDefaults;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.plugins.git.RandomOrder;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.DiscoverOtherRefsTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.PruneStaleBranchTrait;
import jenkins.plugins.git.traits.TagDiscoveryTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.TestJGitAPIImpl;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Stopwatch;
import org.junit.rules.TestName;
import org.junit.runner.OrderWith;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@OrderWith(value=RandomOrder.class)
public class AbstractGitSCMSourceTest {
    static final String GitBranchSCMHead_DEV_MASTER = "[GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
    static final String GitBranchSCMHead_DEV_DEV2_MASTER = "[GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, GitBranchSCMHead{name='dev2', ref='refs/heads/dev2'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    @Rule
    public GitSampleRepoRule sampleRepo2 = new GitSampleRepoRule();
    @ClassRule
    public static Stopwatch stopwatch = new Stopwatch();
    @Rule
    public TestName testName = new TestName();
    private static final int MAX_SECONDS_FOR_THESE_TESTS = 210;
    private int wsCount;
    static GitSampleRepoRule sharedSampleRepo;

    private boolean isTimeAvailable() {
        String env = System.getenv("CI");
        if (env == null || !Boolean.parseBoolean(env)) {
            return true;
        }
        return stopwatch.runtime(TimeUnit.SECONDS) <= 210L;
    }

    @Test
    @Deprecated
    public void retrieveHeads() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsRequiresBranchDiscovery() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsSupportsTagDiscovery_ignoreTagsWithoutTagDiscoveryTrait() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsSupportsTagDiscovery_findTagsWithTagDiscoveryTrait() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev-commit-message", "--no-verify");
        long beforeLightweightTag = System.currentTimeMillis();
        this.sampleRepo.git("tag", "lightweight");
        long afterLightweightTag = System.currentTimeMillis();
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2-commit-message", "--no-verify");
        long beforeAnnotatedTag = System.currentTimeMillis();
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        long afterAnnotatedTag = System.currentTimeMillis();
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3-commit-message", "--no-verify");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Set scmHeadSet = source.fetch((TaskListener)listener);
        long now = System.currentTimeMillis();
        block8: for (SCMHead scmHead : scmHeadSet) {
            if (!(scmHead instanceof GitTagSCMHead)) continue;
            GitTagSCMHead tagHead = (GitTagSCMHead)scmHead;
            long fileTimeStampFuzz = this.isWindows() ? 2000L : 1000L;
            fileTimeStampFuzz = 12L * fileTimeStampFuzz / 10L;
            switch (scmHead.getName()) {
                case "lightweight": {
                    long timeStampDelta = afterLightweightTag - tagHead.getTimestamp();
                    MatcherAssert.assertThat((Object)timeStampDelta, (Matcher)Matchers.is((Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(afterLightweightTag - beforeLightweightTag + fileTimeStampFuzz)))));
                    continue block8;
                }
                case "annotated": {
                    long timeStampDelta = afterAnnotatedTag - tagHead.getTimestamp();
                    MatcherAssert.assertThat((Object)timeStampDelta, (Matcher)Matchers.is((Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(afterAnnotatedTag - beforeAnnotatedTag + fileTimeStampFuzz)))));
                    continue block8;
                }
            }
            Assert.fail((String)("Unexpected tag head '" + scmHead.getName() + "'"));
        }
        String expected = "[SCMHead{'annotated'}, GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, SCMHead{'lightweight'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
        Assert.assertEquals((Object)expected, (Object)scmHeadSet.toString());
        Assert.assertEquals((Object)expected, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        expected = "[SCMHead{'annotated'}, GitBranchSCMHead{name='dev', ref='refs/heads/dev'}, GitBranchSCMHead{name='dev2', ref='refs/heads/dev2'}, SCMHead{'lightweight'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]";
        Assert.assertEquals((Object)expected, (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveHeadsSupportsTagDiscovery_onlyTagsWithoutBranchDiscoveryTrait() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[]", (Object)source.fetch((TaskListener)listener).toString());
        source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        Assert.assertEquals((Object)"[SCMHead{'annotated'}, SCMHead{'lightweight'}]", (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)"[SCMHead{'annotated'}, SCMHead{'lightweight'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrieveRevisions() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "annotated", "-m", "annotated");
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        MatcherAssert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsCollectionWithSize.hasSize((int)0));
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        MatcherAssert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"dev", "master"}));
        source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        MatcherAssert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"annotated", "lightweight"}));
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        MatcherAssert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"dev", "master", "annotated", "lightweight"}));
    }

    @Test
    public void retrieveTags_folderScopedCredentials() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "lightweight");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Folder f = (Folder)this.r.jenkins.createProject(Folder.class, "test");
        Iterable stores = CredentialsProvider.lookupStores((ModelObject)f);
        CredentialsStore folderStore = null;
        for (CredentialsStore s : stores) {
            if (!(s.getProvider() instanceof FolderCredentialsProvider) || s.getContext() != f) continue;
            folderStore = s;
            break;
        }
        assert (folderStore != null);
        String fCredentialsId = "fcreds";
        UsernamePasswordCredentialsImpl fCredentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, fCredentialsId, "fcreds", "user", "password-longer-than-14");
        folderStore.addCredentials(Domain.global(), (Credentials)fCredentials);
        folderStore.save();
        WorkflowJob p = (WorkflowJob)f.createProject(WorkflowJob.class, "wjob");
        source.setTraits(new ArrayList());
        source.setCredentialsId(fCredentialsId);
        Git git = (Git)Mockito.mock(Git.class, (Answer)Mockito.CALLS_REAL_METHODS);
        GitClient gitClient = (GitClient)Mockito.spy((Object)git.getClient());
        try (MockedStatic gitMock = Mockito.mockStatic(Git.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            gitMock.when(() -> Git.with((TaskListener)((TaskListener)ArgumentMatchers.any()), (EnvVars)((EnvVars)ArgumentMatchers.any()))).thenReturn((Object)git);
            ((Git)Mockito.doReturn((Object)gitClient).when((Object)git)).getClient();
            String className = "jenkins.plugins.git.AbstractGitSCMSourceTest";
            String testName = "retrieveTags_folderScopedCredentials";
            String flag = className + "." + testName + ".enabled";
            String defaultValue = "The source.fetch() unexpectedly modifies the git remote.origin.url in the working repo";
            if (!System.getProperty(flag, defaultValue).equals(defaultValue)) {
                SCMRevision rev = source.fetch("lightweight", (TaskListener)listener, (Item)p);
                MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((Object)rev.getHead().toString(), (Matcher)Matchers.equalTo((Object)"SCMHead{'lightweight'}"));
                ((GitClient)Mockito.verify((Object)gitClient, (VerificationMode)Mockito.times((int)0))).addDefaultCredentials(null);
                ((GitClient)Mockito.verify((Object)gitClient, (VerificationMode)Mockito.atLeastOnce())).addDefaultCredentials((StandardCredentials)fCredentials);
            }
        }
    }

    @Test
    public void retrieveByName() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        String masterHash = this.sampleRepo.head();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        this.sampleRepo.git("tag", "v1");
        String v1Hash = this.sampleRepo.head();
        this.sampleRepo.write("file", "modified2");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        this.sampleRepo.git("tag", "-a", "v2", "-m", "annotated");
        String v2Hash = this.sampleRepo.head();
        this.sampleRepo.write("file", "modified3");
        this.sampleRepo.git("commit", "--all", "--message=dev3");
        String devHash = this.sampleRepo.head();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(new ArrayList());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        listener.getLogger().println("\n=== fetch('master') ===\n");
        SCMRevision rev = source.fetch("master", (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)masterHash));
        listener.getLogger().println("\n=== fetch('dev') ===\n");
        rev = source.fetch("dev", (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)devHash));
        listener.getLogger().println("\n=== fetch('v1') ===\n");
        rev = source.fetch("v1", (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(GitTagSCMRevision.class));
        MatcherAssert.assertThat((Object)((GitTagSCMRevision)rev).getHash(), (Matcher)Matchers.is((Object)v1Hash));
        listener.getLogger().println("\n=== fetch('v2') ===\n");
        rev = source.fetch("v2", (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(GitTagSCMRevision.class));
        MatcherAssert.assertThat((Object)((GitTagSCMRevision)rev).getHash(), (Matcher)Matchers.is((Object)v2Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", masterHash);
        rev = source.fetch(masterHash, (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)masterHash));
        MatcherAssert.assertThat((Object)rev.getHead().getName(), (Matcher)Matchers.is((Object)"master"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", masterHash.substring(0, 10));
        rev = source.fetch(masterHash.substring(0, 10), (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)masterHash));
        MatcherAssert.assertThat((Object)rev.getHead().getName(), (Matcher)Matchers.is((Object)"master"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", devHash);
        rev = source.fetch(devHash, (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)devHash));
        MatcherAssert.assertThat((Object)rev.getHead().getName(), (Matcher)Matchers.is((Object)"dev"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", devHash.substring(0, 10));
        rev = source.fetch(devHash.substring(0, 10), (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)devHash));
        MatcherAssert.assertThat((Object)rev.getHead().getName(), (Matcher)Matchers.is((Object)"dev"));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v1Hash);
        rev = source.fetch(v1Hash, (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)v1Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v1Hash.substring(0, 10));
        rev = source.fetch(v1Hash.substring(0, 10), (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)v1Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v2Hash);
        rev = source.fetch(v2Hash, (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)v2Hash));
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v2Hash.substring(0, 10));
        rev = source.fetch(v2Hash.substring(0, 10), (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)v2Hash));
        String v2Tag = "refs/tags/v2";
        listener.getLogger().printf("%n=== fetch('%s') ===%n%n", v2Tag);
        rev = source.fetch(v2Tag, (TaskListener)listener, null);
        MatcherAssert.assertThat((Object)rev, (Matcher)Matchers.instanceOf(AbstractGitSCMSource.SCMRevisionImpl.class));
        MatcherAssert.assertThat((Object)((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash(), (Matcher)Matchers.is((Object)v2Hash));
    }

    @Test
    @Deprecated
    public void retrievePrimaryHead_NotDuplicated() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.retrievePrimaryHead(false);
    }

    @Test
    @Deprecated
    public void retrievePrimaryHead_Duplicated() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.retrievePrimaryHead(true);
    }

    @Deprecated
    private void retrievePrimaryHead(boolean duplicatePrimary) throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file.txt", "");
        this.sampleRepo.git("add", "file.txt");
        this.sampleRepo.git("commit", "--all", "--message=add-empty-file");
        this.sampleRepo.git("checkout", "-b", "new-primary");
        this.sampleRepo.write("file.txt", "content");
        this.sampleRepo.git("add", "file.txt");
        this.sampleRepo.git("commit", "--all", "--message=add-file");
        if (duplicatePrimary) {
            this.sampleRepo.git("checkout", "-b", "new-primary-duplicate", "new-primary");
        }
        this.sampleRepo.git("checkout", "master");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.git("symbolic-ref", "HEAD", "refs/heads/new-primary");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        ActionableSCMSourceOwner owner = (ActionableSCMSourceOwner)((Object)Mockito.mock(ActionableSCMSourceOwner.class));
        Mockito.when((Object)owner.getSCMSource(source.getId())).thenReturn((Object)source);
        Mockito.when((Object)owner.getSCMSources()).thenReturn(Collections.singletonList(source));
        source.setOwner((SCMSourceOwner)owner);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        TreeMap<String, SCMHead> headByName = new TreeMap<String, SCMHead>();
        for (SCMHead h : source.fetch((TaskListener)listener)) {
            headByName.put(h.getName(), h);
        }
        if (duplicatePrimary) {
            MatcherAssert.assertThat(headByName.keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"master", "dev", "new-primary", "new-primary-duplicate"}));
        } else {
            MatcherAssert.assertThat(headByName.keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"master", "dev", "new-primary"}));
        }
        List actions = source.fetchActions(null, (TaskListener)listener);
        GitRemoteHeadRefAction refAction = null;
        for (Action a : actions) {
            GitRemoteHeadRefAction action;
            if (!(a instanceof GitRemoteHeadRefAction)) continue;
            refAction = action = (GitRemoteHeadRefAction)a;
            break;
        }
        MatcherAssert.assertThat(refAction, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)refAction.getName(), (Matcher)Matchers.is((Object)"new-primary"));
        Mockito.when((Object)((GitRemoteHeadRefAction)owner.getAction(GitRemoteHeadRefAction.class))).thenReturn((Object)refAction);
        Mockito.when((Object)owner.getActions(GitRemoteHeadRefAction.class)).thenReturn(Collections.singletonList(refAction));
        actions = source.fetchActions((SCMHead)headByName.get("new-primary"), null, (TaskListener)listener);
        PrimaryInstanceMetadataAction primary = null;
        for (Action a : actions) {
            PrimaryInstanceMetadataAction action;
            if (!(a instanceof PrimaryInstanceMetadataAction)) continue;
            primary = action = (PrimaryInstanceMetadataAction)a;
            break;
        }
        MatcherAssert.assertThat(primary, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void retrieveRevision() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v2", (Object)this.fileAt("master", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v3", (Object)this.fileAt("dev", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt("v1", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt(v1, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt(v1.substring(0, 7), (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("nonexistent", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("1234567", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("\n", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        MatcherAssert.assertThat((Object)source.fetchRevisions((TaskListener)listener, null), (Matcher)Matchers.hasItems((Object[])new String[]{"master", "dev", "v1"}));
    }

    @Test
    public void retrieveRevision_nonHead() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_nonAdvertised() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
    }

    @Test
    public void retrieveRevision_customRef() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/foo", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("refs/custom/foo")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_customRef_descendant() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        String v2 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        this.sampleRepo.git("update-ref", "refs/custom/foo", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD~2");
        String dev = this.sampleRepo.head();
        Assert.assertNotEquals((Object)dev, (Object)v3);
        Assert.assertEquals((Object)dev, (Object)v2);
        this.sampleRepo.write("file", "v5");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("refs/custom/*")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_customRef_abbrev_sha1() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/foo", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("refs/custom/foo")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt(v3.substring(0, 7), (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_pr_refspec() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/pull-requests/1/from", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("pull-requests/*/from")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt("pull-requests/1/from", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    @Test
    public void retrieveRevision_pr_local_refspec() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/pull-requests/1/from", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("/pull-requests/*/from", "pr/@{1}")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v3", (Object)this.fileAt("pr/1", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
    }

    private String fileAt(String revision, Run<?, ?> run, SCMSource source, TaskListener listener) throws Exception {
        SCMRevision rev = source.fetch(revision, listener, null);
        if (rev == null) {
            return null;
        }
        FilePath ws = new FilePath(run.getRootDir()).child("ws" + ++this.wsCount);
        source.build(rev.getHead(), rev).checkout(run, (Launcher)new Launcher.LocalLauncher(listener), ws, listener, null, SCMRevisionState.NONE);
        return ws.child("file").readToString();
    }

    @Test
    public void fetchOtherRef() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/1", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("custom/*")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        SCMHeadObserver.Collector collector = (SCMHeadObserver.Collector)source.fetch((SCMSourceCriteria & Serializable)(probe, listener1) -> true, (SCMHeadObserver)new SCMHeadObserver.Collector(), (TaskListener)listener);
        Map result = collector.result();
        MatcherAssert.assertThat(result.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasKey((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(GitRefSCMHead.class), (Matcher)HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"custom-1")))));
    }

    @Test
    public void fetchOtherRevisions() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        String v3 = this.sampleRepo.head();
        this.sampleRepo.git("update-ref", "refs/custom/1", v3);
        this.sampleRepo.git("reset", "--hard", "HEAD^");
        this.sampleRepo.write("file", "v4");
        this.sampleRepo.git("commit", "--all", "--message=v4");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait(), new DiscoverOtherRefsTrait("custom/*")));
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Set revisions = source.fetchRevisions((TaskListener)listener, null);
        MatcherAssert.assertThat((Object)revisions, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat((Object)revisions, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)"custom-1"), Matchers.equalTo((Object)"v1"), Matchers.equalTo((Object)"dev"), Matchers.equalTo((Object)"master")}));
    }

    @Test
    @Deprecated
    public void pruneRemovesDeletedBranches() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("master-file", "master-content-" + String.valueOf(UUID.randomUUID()));
        this.sampleRepo.git("add", "master-file");
        this.sampleRepo.git("commit", "--message=master-branch-commit-message");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("dev-file", "dev-content-" + String.valueOf(UUID.randomUUID()));
        this.sampleRepo.git("add", "dev-file");
        this.sampleRepo.git("commit", "--message=dev-branch-commit-message");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2", "master");
        this.sampleRepo.write("dev2-file", "dev2-content-" + String.valueOf(UUID.randomUUID()));
        this.sampleRepo.git("add", "dev2-file");
        this.sampleRepo.git("commit", "--message=dev2-branch-commit-message");
        Assert.assertEquals((Object)GitBranchSCMHead_DEV_DEV2_MASTER, (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("branch", "-D", "dev");
        Assert.assertEquals((Object)"[GitBranchSCMHead{name='dev2', ref='refs/heads/dev2'}, GitBranchSCMHead{name='master', ref='refs/heads/master'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    @Deprecated
    public void testSpecificRevisionBuildChooser() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("master-file", "master-content-" + String.valueOf(UUID.randomUUID()));
        this.sampleRepo.git("add", "master-file");
        this.sampleRepo.git("commit", "--message=master-branch-commit-message");
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Collections.singletonList(new IgnoreOnPushNotificationTrait()));
        ArrayList<Object> extensions = new ArrayList<Object>();
        MatcherAssert.assertThat((Object)source.getExtensions(), (Matcher)Matchers.is((Matcher)IsEmptyCollection.empty()));
        LocalBranch localBranchExtension = new LocalBranch("**");
        extensions.add(localBranchExtension);
        source.setExtensions(extensions);
        MatcherAssert.assertThat((Object)source.getExtensions(), (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)HasPropertyWithValue.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**")))));
        SCMHead head = new SCMHead("master");
        AbstractGitSCMSource.SCMRevisionImpl revision = new AbstractGitSCMSource.SCMRevisionImpl(head, "beaded4deed2bed4feed2deaf78933d0f97a5a34");
        extensions.add(new IgnoreNotifyCommit());
        GitSCM scm = (GitSCM)source.build(head);
        MatcherAssert.assertThat((Object)scm.getExtensions(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)HasPropertyWithValue.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**"))), Matchers.instanceOf(IgnoreNotifyCommit.class), Matchers.instanceOf(GitSCMSourceDefaults.class)}));
        GitSCM scmRevision = (GitSCM)source.build(head, (SCMRevision)revision);
        MatcherAssert.assertThat((Object)scmRevision.getExtensions(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(LocalBranch.class), (Matcher)HasPropertyWithValue.hasProperty((String)"localBranch", (Matcher)Matchers.is((Object)"**"))), Matchers.instanceOf(BuildChooserSetting.class), Matchers.instanceOf(IgnoreNotifyCommit.class), Matchers.instanceOf(GitSCMSourceDefaults.class)}));
    }

    @Test
    @Deprecated
    public void testCustomRemoteName() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "upstream", null, "*", "", true);
        SCMHead head = new SCMHead("master");
        GitSCM scm = (GitSCM)source.build(head);
        List configs = scm.getUserRemoteConfigs();
        Assert.assertEquals((long)1L, (long)configs.size());
        UserRemoteConfig config = (UserRemoteConfig)configs.get(0);
        Assert.assertEquals((Object)"upstream", (Object)config.getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/upstream/*", (Object)config.getRefspec());
    }

    @Test
    @Deprecated
    public void testCustomRefSpecs() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", null, "+refs/heads/*:refs/remotes/origin/*          +refs/merge-requests/*/head:refs/remotes/origin/merge-requests/*", "*", "", true);
        SCMHead head = new SCMHead("master");
        GitSCM scm = (GitSCM)source.build(head);
        List configs = scm.getUserRemoteConfigs();
        Assert.assertEquals((long)1L, (long)configs.size());
        UserRemoteConfig config = (UserRemoteConfig)configs.get(0);
        Assert.assertEquals((Object)"origin", (Object)config.getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/origin/* +refs/merge-requests/*/head:refs/remotes/origin/merge-requests/*", (Object)config.getRefspec());
    }

    private boolean isPruneOnFetchEnabled() throws Exception {
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        boolean checkForErrors = false;
        String[] pruneOnFetch = gitCmd.run(checkForErrors, "config", "--get", "fetch.prune");
        return pruneOnFetch.length > 0 && Boolean.valueOf(pruneOnFetch[0]) != false;
    }

    @Test
    public void refLockEncounteredIfPruneTraitNotPresentOnNotFoundRetrieval() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        if (this.isPruneOnFetchEnabled()) {
            return;
        }
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> AbstractGitSCMSourceTest.lambda$refLockEncounteredIfPruneTraitNotPresentOnNotFoundRetrieval$1(source, (TaskListener)listener));
        Assert.assertFalse((boolean)e.getMessage().contains("--prune"));
    }

    @Test
    public void refLockEncounteredIfPruneTraitNotPresentOnTagRetrieval() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        if (this.isPruneOnFetchEnabled()) {
            return;
        }
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> AbstractGitSCMSourceTest.lambda$refLockEncounteredIfPruneTraitNotPresentOnTagRetrieval$2(source, (TaskListener)listener));
        Assert.assertFalse((boolean)e.getMessage().contains("--prune"));
    }

    @Test
    public void refLockAvoidedIfPruneTraitPresentOnNotFoundRetrieval() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new TagDiscoveryTrait(), new PruneStaleBranchTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        source.fetch("v1.2", (TaskListener)listener, null);
        Assert.assertEquals((Object)"[SCMHead{'v1.2'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void refLockAvoidedIfPruneTraitPresentOnTagRetrieval() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
        source.setTraits(Arrays.asList(new TagDiscoveryTrait(), new PruneStaleBranchTrait()));
        this.createRefLockEnvironment((TaskListener)listener, source);
        source.fetch("v1.2", (TaskListener)listener, null);
        Assert.assertEquals((Object)"[SCMHead{'v1.2'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    private void createRefLockEnvironment(TaskListener listener, GitSCMSource source) throws Exception {
        String branch = "prune";
        String branchRefLock = "prune/prune";
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", branch);
        this.sampleRepo.git("push", "--set-upstream", source.getRemote(), branch);
        source.fetch("v1.2", listener, null);
        this.sampleRepo.git("checkout", "master");
        this.sampleRepo.git("push", source.getRemote(), "--delete", branch);
        this.sampleRepo.git("checkout", "-b", branchRefLock);
        this.sampleRepo.git("push", "--set-upstream", source.getRemote(), branchRefLock);
        this.sampleRepo.git("tag", "v1.2");
        this.sampleRepo.git("push", source.getRemote(), "v1.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void when_commits_added_during_discovery_we_do_not_crash() throws Exception {
        Assume.assumeTrue((String)"Test class max time 210 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        System.setProperty(Git.class.getName() + ".mockClient", MockGitClient.class.getName());
        sharedSampleRepo = this.sampleRepo;
        try {
            GitSCMSource source = new GitSCMSource(this.sampleRepo.toString());
            source.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
            StreamTaskListener listener = StreamTaskListener.fromStderr();
            SCMHeadObserver.Collector c = (SCMHeadObserver.Collector)source.fetch((SCMSourceCriteria & Serializable)(probe, listener1) -> true, (SCMHeadObserver)new SCMHeadObserver.Collector(), (TaskListener)listener);
            MatcherAssert.assertThat(c.result().keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"master")), HasPropertyWithValue.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"dev"))}));
        }
        catch (MissingObjectException me) {
            Assert.fail((String)"Not supposed to get MissingObjectException");
        }
        finally {
            System.clearProperty(Git.class.getName() + ".mockClient");
            sharedSampleRepo = null;
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private static /* synthetic */ void lambda$refLockEncounteredIfPruneTraitNotPresentOnTagRetrieval$2(GitSCMSource source, TaskListener listener) throws Throwable {
        source.fetch("v1.2", listener, null);
    }

    private static /* synthetic */ void lambda$refLockEncounteredIfPruneTraitNotPresentOnNotFoundRetrieval$1(GitSCMSource source, TaskListener listener) throws Throwable {
        source.fetch("v1.2", listener, null);
    }

    public static abstract class ActionableSCMSourceOwner
    extends Actionable
    implements SCMSourceOwner {
    }

    public static class MockGitClient
    extends TestJGitAPIImpl {
        final String exe;
        final EnvVars env;

        public MockGitClient(String exe, EnvVars env, File workspace, TaskListener listener) {
            super(workspace, listener);
            this.exe = exe;
            this.env = env;
        }

        public Map<String, ObjectId> getRemoteReferences(String url, String pattern, boolean headsOnly, boolean tagsOnly) throws GitException, InterruptedException {
            Map remoteReferences = super.getRemoteReferences(url, pattern, headsOnly, tagsOnly);
            try {
                sharedSampleRepo.write("file2", "New");
                sharedSampleRepo.git("add", "file2");
                sharedSampleRepo.git("commit", "--all", "--message=inbetween");
            }
            catch (Exception e) {
                throw new GitException("Sneaking in something didn't work", (Throwable)e);
            }
            return remoteReferences;
        }

        public FetchCommand fetch_() {
            final FetchCommand fetchCommand = super.fetch_();
            return new FetchCommand(){

                public FetchCommand from(URIish urIish, List<RefSpec> list) {
                    fetchCommand.from(urIish, list);
                    return this;
                }

                @Deprecated
                public FetchCommand prune() {
                    fetchCommand.prune(true);
                    return this;
                }

                public FetchCommand prune(boolean b) {
                    fetchCommand.prune(b);
                    return this;
                }

                public FetchCommand shallow(boolean b) {
                    fetchCommand.shallow(b);
                    return this;
                }

                public FetchCommand timeout(Integer integer) {
                    fetchCommand.timeout(integer);
                    return this;
                }

                public FetchCommand tags(boolean b) {
                    fetchCommand.tags(b);
                    return this;
                }

                public FetchCommand depth(Integer integer) {
                    fetchCommand.depth(integer);
                    return this;
                }

                public void execute() throws GitException, InterruptedException {
                    fetchCommand.execute();
                    try {
                        sharedSampleRepo.write("file3", "New");
                        sharedSampleRepo.git("add", "file3");
                        sharedSampleRepo.git("commit", "--all", "--message=inbetween");
                    }
                    catch (Exception e) {
                        throw new GitException((Throwable)e);
                    }
                }
            };
        }
    }
}

