/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.StringParameterDefinition;
import hudson.plugins.git.AbstractGitTestCase;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.scm.SCM;
import hudson.tasks.BatchFile;
import hudson.tasks.Builder;
import hudson.tasks.Shell;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CloneOptionHonorRefSpecTest
extends AbstractGitTestCase {
    private final String refSpecName;
    private static final Random random = new Random();
    private FreeStyleProject project;
    private String refSpecExpectedValue;

    public CloneOptionHonorRefSpecTest(String refSpecName) {
        this.refSpecName = refSpecName;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection permuteRefSpecVariable() {
        String[] keys;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String refSpecName : keys = new String[]{"JOB_NAME", CloneOptionHonorRefSpecTest.isWindows() ? "USERNAME" : "USER", "USER_SELECTED_BRANCH_NAME"}) {
            Object[] combination = new Object[]{refSpecName};
            values.add(combination);
        }
        return values;
    }

    private static Builder createEnvEchoBuilder(String envVarName) {
        if (CloneOptionHonorRefSpecTest.isWindows()) {
            return new BatchFile("echo %s=%%%s%%".formatted(envVarName, envVarName));
        }
        return new Shell("echo \"%s=${%s}\"".formatted(envVarName, envVarName));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.project = this.createFreeStyleProject();
        this.project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("USER_SELECTED_BRANCH_NAME", "user_branch")}));
        this.project.getBuildersList().add((Object)CloneOptionHonorRefSpecTest.createEnvEchoBuilder(this.refSpecName));
        FreeStyleBuild b = this.r.buildAndAssertSuccess(this.project);
        List logs = b.getLog(50);
        for (String line : logs) {
            if (!line.startsWith(this.refSpecName + "=")) continue;
            this.refSpecExpectedValue = line.substring(this.refSpecName.length() + 1, line.length());
        }
        if (this.refSpecExpectedValue == null) {
            throw new Exception("Could not obtain env var expected value");
        }
    }

    @Test
    public void testRefSpecWithExpandedVariables() throws Exception {
        if (this.refSpecExpectedValue == null || this.refSpecExpectedValue.isEmpty()) {
            System.out.println("*** testRefSpecWithExpandedVariables empty expected value for '" + this.refSpecName + "' ***");
            return;
        }
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master branch");
        this.git.checkout().ref("master").branch(this.refSpecExpectedValue).execute();
        this.commit("commitFile1", this.johnDoe, "Commit in '" + this.refSpecExpectedValue + "' branch");
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "+refs/heads/${" + this.refSpecName + "}:refs/remotes/origin/${" + this.refSpecName + "}", null));
        Object branchName = random.nextBoolean() ? "${" + this.refSpecName + "}" : this.refSpecExpectedValue;
        GitSCM scm = new GitSCM(repos, Collections.singletonList(new BranchSpec((String)branchName)), Boolean.valueOf(false), Collections.emptyList(), null, random.nextBoolean() ? "jgit" : null, Collections.emptyList());
        this.project.setScm((SCM)scm);
        CloneOption cloneOption = new CloneOption(false, null, null);
        cloneOption.setHonorRefspec(true);
        scm.getExtensions().add((Object)cloneOption);
        FreeStyleBuild b = this.build(this.project, Result.SUCCESS, "commitFile1");
        List buildLog = b.getLog(50);
        MatcherAssert.assertThat((Object)buildLog, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)("${" + this.refSpecName + "}")))));
    }

    private static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

