/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.View;
import hudson.plugins.git.AbstractGitTestCase;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatusTest;
import hudson.plugins.git.extensions.impl.BuildSingleRevisionOnly;
import hudson.util.RunList;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BuildSingleRevisionOnlyTest
extends AbstractGitTestCase {
    @After
    public void waitForAllJobsToComplete() {
        if (!this.isWindows() || this.r == null || this.r.jenkins == null) {
            return;
        }
        View allView = this.r.jenkins.getView("All");
        if (allView == null) {
            return;
        }
        RunList runList = allView.getBuilds();
        if (runList == null) {
            return;
        }
        runList.forEach(run -> {
            try {
                Logger.getLogger(GitStatusTest.class.getName()).log(Level.INFO, "Waiting for {0}", run);
                this.r.waitForCompletion(run);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(GitStatusTest.class.getName()).log(Level.SEVERE, "Interrupted waiting for GitStatusTest job", ex);
            }
        });
    }

    @Test
    public void testSingleRevision() throws Exception {
        ArrayList<BranchSpec> branchSpec = new ArrayList<BranchSpec>();
        branchSpec.add(new BranchSpec("master"));
        branchSpec.add(new BranchSpec("foo"));
        branchSpec.add(new BranchSpec("bar"));
        FreeStyleProject project = this.setupProject(branchSpec, false, "", "", "", "", false, "");
        ((GitSCM)project.getScm()).getExtensions().add((Object)new BuildSingleRevisionOnly());
        String commitFile = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Initial commit in master");
        this.git.branch("foo");
        this.git.branch("bar");
        this.git.checkoutBranch("foo", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.git.checkoutBranch("bar", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in bar");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.r.assertBuildStatusSuccess((Run)build);
        boolean result = build.getLog(100).contains("Scheduling another build to catch up with %s".formatted(project.getName()));
        Assert.assertFalse((String)"Single revision scheduling did not prevent a build of a different revision", (boolean)result);
    }

    @Test
    public void testMultiRevision() throws Exception {
        ArrayList<BranchSpec> branchSpec = new ArrayList<BranchSpec>();
        branchSpec.add(new BranchSpec("master"));
        branchSpec.add(new BranchSpec("foo"));
        branchSpec.add(new BranchSpec("bar"));
        FreeStyleProject project = this.setupProject(branchSpec, false, "", "", "", "", false, "");
        String commitFile = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Initial commit in master");
        this.git.branch("foo");
        this.git.branch("bar");
        this.git.checkoutBranch("foo", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.git.checkoutBranch("bar", "master");
        this.commit("commitFile1", this.johnDoe, "Commit in bar");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.r.assertBuildStatusSuccess((Run)build);
        this.r.waitForMessage("Scheduling another build to catch up with %s".formatted(project.getName()), (Run)build);
        Random random = new Random();
        Thread.sleep(500L + (long)random.nextInt(300));
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

