/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.GitStatus;
import java.util.ArrayList;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitStatusSimpleTest {
    private GitStatus gitStatus;

    @Before
    public void setUp() throws Exception {
        this.gitStatus = new GitStatus();
    }

    @Test
    public void testGetDisplayName() {
        Assert.assertEquals((Object)"Git", (Object)this.gitStatus.getDisplayName());
    }

    @Test
    public void testGetIconFileName() {
        Assert.assertNull((Object)this.gitStatus.getIconFileName());
    }

    @Test
    public void testGetUrlName() {
        Assert.assertEquals((Object)"git", (Object)this.gitStatus.getUrlName());
    }

    @Test
    public void testAllowNotifyCommitParametersDisabled() {
        Assert.assertFalse((String)"SECURITY-275: ignore arbitrary notifyCommit parameters", (boolean)GitStatus.ALLOW_NOTIFY_COMMIT_PARAMETERS);
    }

    @Test
    public void testSafeParametersEmpty() {
        Assert.assertEquals((String)"SECURITY-275: Safe notifyCommit parameters", (Object)"", (Object)GitStatus.SAFE_PARAMETERS);
    }

    @Test
    public void testLooselyMatches() throws Exception {
        String[] equivalentRepoURLs = new String[]{"https://example.com/jenkinsci/git-plugin", "https://example.com/jenkinsci/git-plugin/", "https://example.com/jenkinsci/git-plugin.git", "https://example.com/jenkinsci/git-plugin.git/", "https://someone@example.com/jenkinsci/git-plugin.git", "https://someone:somepassword@example.com/jenkinsci/git-plugin/", "git://example.com/jenkinsci/git-plugin", "git://example.com/jenkinsci/git-plugin/", "git://example.com/jenkinsci/git-plugin.git", "git://example.com/jenkinsci/git-plugin.git/", "ssh://git@example.com/jenkinsci/git-plugin", "ssh://example.com/jenkinsci/git-plugin.git", "git@example.com:jenkinsci/git-plugin/", "git@example.com:jenkinsci/git-plugin.git", "git@example.com:jenkinsci/git-plugin.git/"};
        ArrayList<URIish> uris = new ArrayList<URIish>();
        for (String testURL : equivalentRepoURLs) {
            uris.add(new URIish(testURL));
        }
        URIish badURLTrailingSlashes = new URIish(equivalentRepoURLs[0] + "///");
        URIish badURLHostname = new URIish(equivalentRepoURLs[0].replace("example.com", "bitbucket.org"));
        for (URIish lhs : uris) {
            Assert.assertFalse((String)(String.valueOf(lhs) + " matches trailing slashes " + String.valueOf(badURLTrailingSlashes)), (boolean)GitStatus.looselyMatches((URIish)lhs, (URIish)badURLTrailingSlashes));
            Assert.assertFalse((String)(String.valueOf(lhs) + " matches bad hostname " + String.valueOf(badURLHostname)), (boolean)GitStatus.looselyMatches((URIish)lhs, (URIish)badURLHostname));
            for (URIish rhs : uris) {
                Assert.assertTrue((String)(String.valueOf(lhs) + " and " + String.valueOf(rhs) + " didn't match"), (boolean)GitStatus.looselyMatches((URIish)lhs, (URIish)rhs));
            }
        }
    }
}

