/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitBranchSCMRevision;
import jenkins.plugins.git.GitSCMHeadMixin;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMRevision;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class GitBranchSCMHead
extends SCMHead
implements GitSCMHeadMixin {
    public GitBranchSCMHead(@NonNull String name) {
        super(name);
    }

    @Override
    public final String getRef() {
        return "refs/heads/" + this.getName();
    }

    public String toString() {
        return "GitBranchSCMHead{name='" + this.getName() + "', ref='" + this.getRef() + "'}";
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class SCMHeadMigrationImpl
    extends SCMHeadMigration<GitSCMSource, SCMHead, AbstractGitSCMSource.SCMRevisionImpl> {
        public SCMHeadMigrationImpl() {
            super(GitSCMSource.class, SCMHead.class, AbstractGitSCMSource.SCMRevisionImpl.class);
        }

        public SCMHead migrate(@NonNull GitSCMSource source, @NonNull SCMHead head) {
            return new GitBranchSCMHead(head.getName());
        }

        public SCMRevision migrate(@NonNull GitSCMSource source, @NonNull AbstractGitSCMSource.SCMRevisionImpl revision) {
            SCMHead revisionHead;
            SCMHead branchHead;
            if (revision.getHead().getClass() == SCMHead.class && (branchHead = this.migrate(source, revisionHead = revision.getHead())) != null) {
                GitBranchSCMHead gitBranchHead = (GitBranchSCMHead)branchHead;
                String revisionHash = revision.getHash();
                return new GitBranchSCMRevision(gitBranchHead, revisionHash);
            }
            return null;
        }
    }
}

