/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.git.ApiTokenPropertyConfiguration;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.GitTool;
import hudson.scm.SCMDescriptor;
import hudson.tools.CommandInstaller;
import hudson.tools.InstallSourceProperty;
import hudson.tools.ToolInstallation;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.AbstractGitSCMSourceTest;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitRemoteHeadRefAction;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSCMTelescope;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.TagDiscoveryTrait;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GitSCMSourceTest {
    public static final String REMOTE = "git@remote:test/project.git";
    @Rule
    public JenkinsRule r = new JenkinsRule();
    private GitStatus gitStatus;

    @Before
    public void setup() {
        this.gitStatus = new GitStatus();
    }

    @Test
    @Deprecated
    public void testSourceOwnerTriggeredByDoNotifyCommit() throws Exception {
        String notifyCommitApiToken = ApiTokenPropertyConfiguration.get().generateApiToken("test").getString("value");
        GitSCMSource gitSCMSource = new GitSCMSource("id", REMOTE, "", "*", "", false);
        GitSCMSourceOwner scmSourceOwner = this.setupGitSCMSourceOwner(gitSCMSource);
        this.r.getInstance().add((TopLevelItem)scmSourceOwner, "gitSourceOwner");
        this.gitStatus.doNotifyCommit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), REMOTE, "master", "", notifyCommitApiToken);
        SCMHeadEvent<?> event = ((SCMEventListenerImpl)((Object)this.r.getInstance().getExtensionList(SCMEventListener.class).get(SCMEventListenerImpl.class))).waitSCMHeadEvent(1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat(event, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(event.heads((SCMSource)gitSCMSource).keySet(), (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)new GitBranchSCMHead("master"))));
        ((GitSCMSourceOwner)Mockito.verify((Object)scmSourceOwner, (VerificationMode)Mockito.times((int)0))).onSCMSourceUpdated((SCMSource)gitSCMSource);
    }

    private GitSCMSourceOwner setupGitSCMSourceOwner(GitSCMSource gitSCMSource) {
        GitSCMSourceOwner owner = (GitSCMSourceOwner)Mockito.mock(GitSCMSourceOwner.class);
        Mockito.when((Object)owner.hasPermission(Item.READ)).thenReturn((Object)true, (Object[])new Boolean[]{true, true});
        Mockito.when((Object)owner.getSCMSources()).thenReturn(Collections.singletonList(gitSCMSource));
        return owner;
    }

    @Test
    public void telescopeFetch() throws Exception {
        GitSCMSource instance = new GitSCMSource("http://git.test/telescope.git");
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.nullValue());
        instance.setOwner((SCMSourceOwner)Mockito.mock(SCMSourceOwner.class));
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.notNullValue());
        instance.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Map result = ((SCMHeadObserver.Collector)instance.fetch((SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMRevision[]{new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("foo"), "6769413a79793e242c73d7377f0006c6aea95480"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("bar"), "3f0b897057d8b43d3b9ff55e3fdefbb021493470"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("manchu"), "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc"), new GitTagSCMRevision(new GitTagSCMHead("v1.0.0", 15086193840000L), "315fd8b5cae3363b29050f1aabfc27c985e22f7e")}));
        instance.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        result = ((SCMHeadObserver.Collector)instance.fetch((SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMRevision[]{new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("foo"), "6769413a79793e242c73d7377f0006c6aea95480"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("bar"), "3f0b897057d8b43d3b9ff55e3fdefbb021493470"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("manchu"), "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc")}));
        instance.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        result = ((SCMHeadObserver.Collector)instance.fetch((SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMRevision[]{new GitTagSCMRevision(new GitTagSCMHead("v1.0.0", 15086193840000L), "315fd8b5cae3363b29050f1aabfc27c985e22f7e")}));
    }

    @Test
    public void telescopeFetchWithCriteria() throws Exception {
        GitSCMSource instance = new GitSCMSource("http://git.test/telescope.git");
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.nullValue());
        instance.setOwner((SCMSourceOwner)Mockito.mock(SCMSourceOwner.class));
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.notNullValue());
        instance.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Map result = ((SCMHeadObserver.Collector)instance.fetch((SCMSourceCriteria)new MySCMSourceCriteria("Jenkinsfile"), (SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMRevision[]{new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("foo"), "6769413a79793e242c73d7377f0006c6aea95480"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("bar"), "3f0b897057d8b43d3b9ff55e3fdefbb021493470"), new GitTagSCMRevision(new GitTagSCMHead("v1.0.0", 15086193840000L), "315fd8b5cae3363b29050f1aabfc27c985e22f7e")}));
        result = ((SCMHeadObserver.Collector)instance.fetch((SCMSourceCriteria)new MySCMSourceCriteria("README.md"), (SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMRevision[]{new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("bar"), "3f0b897057d8b43d3b9ff55e3fdefbb021493470"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("manchu"), "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc")}));
        instance.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        result = ((SCMHeadObserver.Collector)instance.fetch((SCMSourceCriteria)new MySCMSourceCriteria("Jenkinsfile"), (SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMRevision[]{new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("foo"), "6769413a79793e242c73d7377f0006c6aea95480"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("bar"), "3f0b897057d8b43d3b9ff55e3fdefbb021493470")}));
        instance.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        result = ((SCMHeadObserver.Collector)instance.fetch((SCMSourceCriteria)new MySCMSourceCriteria("Jenkinsfile"), (SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        MatcherAssert.assertThat(result.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMRevision[]{new GitTagSCMRevision(new GitTagSCMHead("v1.0.0", 15086193840000L), "315fd8b5cae3363b29050f1aabfc27c985e22f7e")}));
    }

    @Test
    public void telescopeFetchRevisions() throws Exception {
        GitSCMSource instance = new GitSCMSource("http://git.test/telescope.git");
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.nullValue());
        instance.setOwner((SCMSourceOwner)Mockito.mock(SCMSourceOwner.class));
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.notNullValue());
        instance.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        Set result = instance.fetchRevisions(null, null);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar", "manchu", "v1.0.0"}));
        instance.setTraits(Collections.singletonList(new BranchDiscoveryTrait()));
        result = instance.fetchRevisions(null, null);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar", "manchu"}));
        instance.setTraits(Collections.singletonList(new TagDiscoveryTrait()));
        result = instance.fetchRevisions(null, null);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"v1.0.0"}));
    }

    @Test
    public void telescopeFetchRevision() throws Exception {
        GitSCMSource instance = new GitSCMSource("http://git.test/telescope.git");
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.nullValue());
        instance.setOwner((SCMSourceOwner)Mockito.mock(SCMSourceOwner.class));
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.notNullValue());
        instance.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        MatcherAssert.assertThat((Object)instance.fetch(new SCMHead("foo"), null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"6769413a79793e242c73d7377f0006c6aea95480")));
        MatcherAssert.assertThat((Object)instance.fetch((SCMHead)new GitBranchSCMHead("foo"), null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"6769413a79793e242c73d7377f0006c6aea95480")));
        MatcherAssert.assertThat((Object)instance.fetch(new SCMHead("bar"), null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"3f0b897057d8b43d3b9ff55e3fdefbb021493470")));
        MatcherAssert.assertThat((Object)instance.fetch(new SCMHead("manchu"), null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"a94782d8d90b56b7e0d277c04589bd2e6f70d2cc")));
        MatcherAssert.assertThat((Object)instance.fetch((SCMHead)new GitTagSCMHead("v1.0.0", 0L), null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"315fd8b5cae3363b29050f1aabfc27c985e22f7e")));
    }

    @Test
    public void telescopeFetchRevisionByName() throws Exception {
        GitSCMSource instance = new GitSCMSource("http://git.test/telescope.git");
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.nullValue());
        instance.setOwner((SCMSourceOwner)Mockito.mock(SCMSourceOwner.class));
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.notNullValue());
        instance.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        MatcherAssert.assertThat((Object)instance.fetch("foo", null, null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"6769413a79793e242c73d7377f0006c6aea95480")));
        MatcherAssert.assertThat((Object)instance.fetch("bar", null, null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"3f0b897057d8b43d3b9ff55e3fdefbb021493470")));
        MatcherAssert.assertThat((Object)instance.fetch("manchu", null, null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"a94782d8d90b56b7e0d277c04589bd2e6f70d2cc")));
        MatcherAssert.assertThat((Object)instance.fetch("v1.0.0", null, null), (Matcher)Matchers.hasProperty((String)"hash", (Matcher)Matchers.is((Object)"315fd8b5cae3363b29050f1aabfc27c985e22f7e")));
    }

    @Test
    public void telescopeFetchActions() throws Exception {
        GitSCMSource instance = new GitSCMSource("http://git.test/telescope.git");
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.nullValue());
        AbstractGitSCMSourceTest.ActionableSCMSourceOwner owner = (AbstractGitSCMSourceTest.ActionableSCMSourceOwner)((Object)Mockito.mock(AbstractGitSCMSourceTest.ActionableSCMSourceOwner.class));
        Mockito.when((Object)owner.getSCMSource(instance.getId())).thenReturn((Object)instance);
        Mockito.when((Object)owner.getSCMSources()).thenReturn(Collections.singletonList(instance));
        instance.setOwner((SCMSourceOwner)owner);
        MatcherAssert.assertThat((Object)GitSCMTelescope.of((AbstractGitSCMSource)instance), (Matcher)Matchers.notNullValue());
        instance.setTraits(Arrays.asList(new BranchDiscoveryTrait(), new TagDiscoveryTrait()));
        List actions = instance.fetchActions(null, null);
        MatcherAssert.assertThat((Object)actions, (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(GitRemoteHeadRefAction.class), (Matcher)Matchers.hasProperty((String)"remote", (Matcher)Matchers.is((Object)"http://git.test/telescope.git")), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"manchu")))));
        Mockito.when((Object)owner.getActions(GitRemoteHeadRefAction.class)).thenReturn(Collections.singletonList((GitRemoteHeadRefAction)actions.get(0)));
        MatcherAssert.assertThat((Object)instance.fetchActions(new SCMHead("foo"), null, null), (Matcher)Matchers.is(Collections.emptyList()));
        MatcherAssert.assertThat((Object)instance.fetchActions(new SCMHead("bar"), null, null), (Matcher)Matchers.is(Collections.emptyList()));
        MatcherAssert.assertThat((Object)instance.fetchActions(new SCMHead("manchu"), null, null), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(PrimaryInstanceMetadataAction.class)));
        MatcherAssert.assertThat((Object)instance.fetchActions((SCMHead)new GitTagSCMHead("v1.0.0", 0L), null, null), (Matcher)Matchers.is(Collections.emptyList()));
    }

    @Test
    public void gitSCMSourceShouldResolveToolsForMaster() throws Exception {
        if (this.isWindows()) {
            return;
        }
        StreamTaskListener log = StreamTaskListener.fromStdout();
        HelloToolInstaller inst = new HelloToolInstaller(this.r.jenkins.getSelfLabel().getName(), "echo Hello", "git");
        GitTool t = new GitTool("myGit", null, Collections.singletonList(new InstallSourceProperty(Collections.singletonList(inst))));
        t.getDescriptor().setInstallations((ToolInstallation[])new GitTool[]{t});
        GitTool defaultTool = GitTool.getDefaultInstallation();
        GitTool resolved = (GitTool)defaultTool.translate((Node)this.r.jenkins, new EnvVars(), TaskListener.NULL);
        MatcherAssert.assertThat((Object)resolved.getGitExe(), (Matcher)CoreMatchers.containsString((String)"git"));
        GitSCMSource instance = new GitSCMSource("http://git.test/telescope.git");
        instance.fetchRevisions((TaskListener)log, null);
        Assert.assertTrue((String)"Installer should be invoked", (boolean)inst.isInvoked());
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private static class MySCMSourceCriteria
    implements SCMSourceCriteria {
        private final String path;

        private MySCMSourceCriteria(String path) {
            this.path = path;
        }

        public boolean isHead(@NonNull SCMSourceCriteria.Probe probe, @NonNull TaskListener listener) throws IOException {
            return SCMFile.Type.REGULAR_FILE.equals((Object)probe.stat(this.path).getType());
        }
    }

    @TestExtension
    public static class MyGitSCMTelescope
    extends GitSCMTelescope {
        public boolean supports(@NonNull String remote) {
            return "http://git.test/telescope.git".equals(remote);
        }

        public boolean supportsDescriptor(SCMDescriptor descriptor) {
            return false;
        }

        public boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
            return false;
        }

        public void validate(@NonNull String remote, StandardCredentials credentials) throws IOException, InterruptedException {
        }

        protected SCMFileSystem build(@NonNull String remote, StandardCredentials credentials, @NonNull SCMHead head, SCMRevision rev) throws IOException, InterruptedException {
            String hash;
            if (rev instanceof AbstractGitSCMSource.SCMRevisionImpl) {
                hash = ((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash();
            } else {
                switch (head.getName()) {
                    case "foo": {
                        hash = "6769413a79793e242c73d7377f0006c6aea95480";
                        break;
                    }
                    case "bar": {
                        hash = "3f0b897057d8b43d3b9ff55e3fdefbb021493470";
                        break;
                    }
                    case "manchu": {
                        hash = "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc";
                        break;
                    }
                    case "v1.0.0": {
                        hash = "315fd8b5cae3363b29050f1aabfc27c985e22f7e";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            return new SCMFileSystem(rev){

                public long lastModified() throws IOException, InterruptedException {
                    switch (hash) {
                        case "6769413a79793e242c73d7377f0006c6aea95480": {
                            return 15086163840000L;
                        }
                        case "3f0b897057d8b43d3b9ff55e3fdefbb021493470": {
                            return 15086173840000L;
                        }
                        case "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc": {
                            return 15086183840000L;
                        }
                        case "315fd8b5cae3363b29050f1aabfc27c985e22f7e": {
                            return 15086193840000L;
                        }
                    }
                    return 0L;
                }

                @NonNull
                public SCMFile getRoot() {
                    return new MySCMFile(hash);
                }
            };
        }

        public long getTimestamp(@NonNull String remote, StandardCredentials credentials, @NonNull String refOrHash) throws IOException, InterruptedException {
            switch (refOrHash) {
                case "refs/heads/foo": {
                    refOrHash = "6769413a79793e242c73d7377f0006c6aea95480";
                    break;
                }
                case "refs/heads/bar": {
                    refOrHash = "3f0b897057d8b43d3b9ff55e3fdefbb021493470";
                    break;
                }
                case "refs/heads/manchu": {
                    refOrHash = "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc";
                    break;
                }
                case "refs/tags/v1.0.0": {
                    refOrHash = "315fd8b5cae3363b29050f1aabfc27c985e22f7e";
                }
            }
            switch (refOrHash) {
                case "6769413a79793e242c73d7377f0006c6aea95480": {
                    return 15086163840000L;
                }
                case "3f0b897057d8b43d3b9ff55e3fdefbb021493470": {
                    return 15086173840000L;
                }
                case "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc": {
                    return 15086183840000L;
                }
                case "315fd8b5cae3363b29050f1aabfc27c985e22f7e": {
                    return 15086193840000L;
                }
            }
            return 0L;
        }

        public SCMRevision getRevision(@NonNull String remote, StandardCredentials credentials, @NonNull String refOrHash) throws IOException, InterruptedException {
            switch (refOrHash) {
                case "refs/heads/foo": {
                    return new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("foo"), "6769413a79793e242c73d7377f0006c6aea95480");
                }
                case "refs/heads/bar": {
                    return new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("bar"), "3f0b897057d8b43d3b9ff55e3fdefbb021493470");
                }
                case "refs/heads/manchu": {
                    return new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("manchu"), "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc");
                }
                case "refs/tags/v1.0.0": {
                    return new GitTagSCMRevision(new GitTagSCMHead("v1.0.0", 15086193840000L), "315fd8b5cae3363b29050f1aabfc27c985e22f7e");
                }
            }
            return null;
        }

        public Iterable<SCMRevision> getRevisions(@NonNull String remote, StandardCredentials credentials, @NonNull Set<GitSCMTelescope.ReferenceType> referenceTypes) throws IOException, InterruptedException {
            return Arrays.asList(new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("foo"), "6769413a79793e242c73d7377f0006c6aea95480"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("bar"), "3f0b897057d8b43d3b9ff55e3fdefbb021493470"), new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("manchu"), "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc"), new GitTagSCMRevision(new GitTagSCMHead("v1.0.0", 15086193840000L), "315fd8b5cae3363b29050f1aabfc27c985e22f7e"));
        }

        public String getDefaultTarget(@NonNull String remote, StandardCredentials credentials) throws IOException, InterruptedException {
            return "manchu";
        }

        private static class MySCMFile
        extends SCMFile {
            private final String hash;
            private final SCMFile.Type type;

            public MySCMFile(String hash) {
                this.hash = hash;
                this.type = SCMFile.Type.DIRECTORY;
            }

            public MySCMFile(MySCMFile parent, String name, SCMFile.Type type) {
                super((SCMFile)parent, name);
                this.type = type;
                this.hash = parent.hash;
            }

            @NonNull
            protected SCMFile newChild(@NonNull String name, boolean assumeIsDirectory) {
                return new MySCMFile(this, name, assumeIsDirectory ? SCMFile.Type.DIRECTORY : SCMFile.Type.REGULAR_FILE);
            }

            @NonNull
            public Iterable<SCMFile> children() throws IOException, InterruptedException {
                if (this.parent().isRoot()) {
                    switch (this.hash) {
                        case "6769413a79793e242c73d7377f0006c6aea95480": {
                            return Collections.singleton(this.newChild("Jenkinsfile", false));
                        }
                        case "3f0b897057d8b43d3b9ff55e3fdefbb021493470": {
                            return Arrays.asList(this.newChild("Jenkinsfile", false), this.newChild("README.md", false));
                        }
                        case "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc": {
                            return Collections.singleton(this.newChild("README.md", false));
                        }
                        case "315fd8b5cae3363b29050f1aabfc27c985e22f7e": {
                            return Collections.singleton(this.newChild("Jenkinsfile", false));
                        }
                    }
                }
                return Collections.emptySet();
            }

            public long lastModified() throws IOException, InterruptedException {
                switch (this.hash) {
                    case "6769413a79793e242c73d7377f0006c6aea95480": {
                        return 15086163840000L;
                    }
                    case "3f0b897057d8b43d3b9ff55e3fdefbb021493470": {
                        return 15086173840000L;
                    }
                    case "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc": {
                        return 15086183840000L;
                    }
                    case "315fd8b5cae3363b29050f1aabfc27c985e22f7e": {
                        return 15086193840000L;
                    }
                }
                return 0L;
            }

            @NonNull
            protected SCMFile.Type type() throws IOException, InterruptedException {
                switch (this.hash) {
                    case "6769413a79793e242c73d7377f0006c6aea95480": {
                        switch (this.getPath()) {
                            case "Jenkinsfile": {
                                return SCMFile.Type.REGULAR_FILE;
                            }
                        }
                        break;
                    }
                    case "3f0b897057d8b43d3b9ff55e3fdefbb021493470": {
                        switch (this.getPath()) {
                            case "Jenkinsfile": {
                                return SCMFile.Type.REGULAR_FILE;
                            }
                            case "README.md": {
                                return SCMFile.Type.REGULAR_FILE;
                            }
                        }
                        break;
                    }
                    case "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc": {
                        switch (this.getPath()) {
                            case "README.md": {
                                return SCMFile.Type.REGULAR_FILE;
                            }
                        }
                        break;
                    }
                    case "315fd8b5cae3363b29050f1aabfc27c985e22f7e": {
                        switch (this.getPath()) {
                            case "Jenkinsfile": {
                                return SCMFile.Type.REGULAR_FILE;
                            }
                        }
                    }
                }
                return this.type == SCMFile.Type.DIRECTORY ? this.type : SCMFile.Type.NONEXISTENT;
            }

            @NonNull
            public InputStream content() throws IOException, InterruptedException {
                switch (this.hash) {
                    case "6769413a79793e242c73d7377f0006c6aea95480": {
                        switch (this.getPath()) {
                            case "Jenkinsfile": {
                                return new ByteArrayInputStream("pipeline{}".getBytes(StandardCharsets.UTF_8));
                            }
                        }
                        break;
                    }
                    case "3f0b897057d8b43d3b9ff55e3fdefbb021493470": {
                        switch (this.getPath()) {
                            case "Jenkinsfile": {
                                return new ByteArrayInputStream("pipeline{}".getBytes(StandardCharsets.UTF_8));
                            }
                            case "README.md": {
                                return new ByteArrayInputStream("Welcome".getBytes(StandardCharsets.UTF_8));
                            }
                        }
                        break;
                    }
                    case "a94782d8d90b56b7e0d277c04589bd2e6f70d2cc": {
                        switch (this.getPath()) {
                            case "README.md": {
                                return new ByteArrayInputStream("Welcome".getBytes(StandardCharsets.UTF_8));
                            }
                        }
                        break;
                    }
                    case "315fd8b5cae3363b29050f1aabfc27c985e22f7e": {
                        switch (this.getPath()) {
                            case "Jenkinsfile": {
                                return new ByteArrayInputStream("pipeline{}".getBytes(StandardCharsets.UTF_8));
                            }
                        }
                    }
                }
                throw new FileNotFoundException(this.getPath() + " does not exist");
            }
        }
    }

    private static class HelloToolInstaller
    extends CommandInstaller {
        private boolean invoked;

        public HelloToolInstaller(String label, String command, String toolHome) {
            super(label, command, toolHome);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public FilePath performInstallation(ToolInstallation toolInstallation, Node node, TaskListener taskListener) throws IOException, InterruptedException {
            taskListener.error("Hello, world!");
            this.invoked = true;
            return super.performInstallation(toolInstallation, node, taskListener);
        }
    }

    @TestExtension
    public static class SCMEventListenerImpl
    extends SCMEventListener {
        SCMHeadEvent<?> head = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSCMHeadEvent(SCMHeadEvent<?> event) {
            SCMEventListenerImpl sCMEventListenerImpl = this;
            synchronized (sCMEventListenerImpl) {
                this.head = event;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SCMHeadEvent<?> waitSCMHeadEvent(long timeout, TimeUnit units) throws TimeoutException, InterruptedException {
            long giveUp = System.currentTimeMillis() + units.toMillis(timeout);
            while (System.currentTimeMillis() < giveUp) {
                SCMEventListenerImpl sCMEventListenerImpl = this;
                synchronized (sCMEventListenerImpl) {
                    SCMHeadEvent<?> h = this.head;
                    if (h != null) {
                        this.head = null;
                        return h;
                    }
                    ((Object)((Object)this)).wait(Math.max(1L, giveUp - System.currentTimeMillis()));
                }
            }
            throw new TimeoutException();
        }
    }

    public static interface GitSCMSourceOwner
    extends TopLevelItem,
    SCMSourceOwner {
    }
}

