/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitChangeSetSample;
import hudson.plugins.git.browser.TFS2013GitRepositoryBrowser;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TFS2013GitRepositoryBrowserTest {
    private static final String repoUrl = "http://tfs/tfs/project/_git/repo";
    private static final GitChangeSetSample sample = new GitChangeSetSample(false);

    @BeforeClass
    public static void setUp() {
        GitSCM scm = new GitSCM(Collections.singletonList(new UserRemoteConfig(repoUrl, null, null, null)), new ArrayList(), null, "jgit", Collections.emptyList());
        AbstractProject project = (AbstractProject)Mockito.mock(AbstractProject.class);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)project.getScm()).thenReturn((Object)scm);
        Mockito.when((Object)build.getProject()).thenReturn((Object)project);
        Mockito.when((Object)build.getParent()).thenReturn((Object)project);
        TFS2013GitRepositoryBrowserTest.sample.changeSet.setParent(ChangeLogSet.createEmpty((Run)build));
    }

    @Test
    public void testResolveURLFromSCM() throws Exception {
        TFS2013GitRepositoryBrowser browser = new TFS2013GitRepositoryBrowser("");
        MatcherAssert.assertThat((Object)browser.getRepoUrl(TFS2013GitRepositoryBrowserTest.sample.changeSet).toString(), (Matcher)CoreMatchers.is((Object)"http://tfs/tfs/project/_git/repo/"));
    }

    @Test
    public void testResolveURLFromConfig() throws Exception {
        TFS2013GitRepositoryBrowser browser = new TFS2013GitRepositoryBrowser("http://url/repo");
        MatcherAssert.assertThat((Object)browser.getRepoUrl(TFS2013GitRepositoryBrowserTest.sample.changeSet).toString(), (Matcher)CoreMatchers.is((Object)"http://url/repo/"));
    }

    @Test
    public void testResolveURLFromConfigWithTrailingSlash() throws Exception {
        TFS2013GitRepositoryBrowser browser = new TFS2013GitRepositoryBrowser("http://url/repo/");
        MatcherAssert.assertThat((Object)browser.getRepoUrl(TFS2013GitRepositoryBrowserTest.sample.changeSet).toString(), (Matcher)CoreMatchers.is((Object)"http://url/repo/"));
    }

    @Test
    public void testGetChangeSetLink() throws Exception {
        URL result = new TFS2013GitRepositoryBrowser(repoUrl).getChangeSetLink(TFS2013GitRepositoryBrowserTest.sample.changeSet);
        MatcherAssert.assertThat((Object)result.toString(), (Matcher)CoreMatchers.is((Object)("http://tfs/tfs/project/_git/repo/commit/" + TFS2013GitRepositoryBrowserTest.sample.id)));
    }

    @Test
    public void testGetDiffLink() throws Exception {
        TFS2013GitRepositoryBrowser browser = new TFS2013GitRepositoryBrowser(repoUrl);
        for (GitChangeSet.Path path : TFS2013GitRepositoryBrowserTest.sample.changeSet.getPaths()) {
            URL diffLink = browser.getDiffLink(path);
            EditType editType = path.getEditType();
            URL expectedDiffLink = new URL("http://tfs/tfs/project/_git/repo/commit/" + TFS2013GitRepositoryBrowserTest.sample.id + "#path=" + path.getPath() + "&_a=compare");
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedDiffLink, (Object)diffLink);
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        TFS2013GitRepositoryBrowser browser = new TFS2013GitRepositoryBrowser(repoUrl);
        for (GitChangeSet.Path path : TFS2013GitRepositoryBrowserTest.sample.changeSet.getPaths()) {
            URL fileLink = browser.getFileLink(path);
            EditType editType = path.getEditType();
            URL expectedFileLink = new URL("http://tfs/tfs/project/_git/repo/commit/" + TFS2013GitRepositoryBrowserTest.sample.id + "#path=" + path.getPath() + "&_a=history");
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedFileLink, (Object)fileLink);
        }
    }
}

