/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class SubmoduleCombinatorTest {
    private SubmoduleCombinator combinator = null;

    @Before
    public void setUp() throws IOException, InterruptedException {
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        GitClient gitClient = Git.with((TaskListener)listener, (EnvVars)new EnvVars()).in(new File(".")).getClient();
        Collection cfg = null;
        this.combinator = new SubmoduleCombinator(gitClient, (TaskListener)listener, cfg);
    }

    @Test
    public void testDifferenceNulls() {
        HashMap item = new HashMap();
        ArrayList entries = new ArrayList();
        Assert.assertEquals((long)0L, (long)this.combinator.difference(item, entries));
    }

    @Test
    public void testDifferenceDifferentSize() {
        HashMap item = new HashMap();
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        Assert.assertTrue((boolean)entries.add(new IndexEntry("mode", "type", "object", "file")));
        Assert.assertEquals((long)0L, (long)this.combinator.difference(item, entries));
    }

    @Test
    public void testDifferenceNoDifference() {
        HashMap<IndexEntry, Revision> items = new HashMap<IndexEntry, Revision>();
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        ObjectId sha1 = ObjectId.fromString((String)"1c2a9e6194e6ede0805cda4c9ccc7e373e835414");
        IndexEntry indexEntry1 = new IndexEntry("mode-1", "type-1", sha1.getName(), "file-1");
        Assert.assertTrue((String)"Failed to add indexEntry1 to entries", (boolean)entries.add(indexEntry1));
        Revision revision = new Revision(sha1);
        Assert.assertNull((String)"items[indexEntry1] had existing value", (Object)items.put(indexEntry1, revision));
        Assert.assertEquals((String)"entries and items[entries] don't match", (long)0L, (long)this.combinator.difference(items, entries));
    }

    @Test
    public void testDifferenceOneDifference() {
        HashMap<IndexEntry, Revision> items = new HashMap<IndexEntry, Revision>();
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        ObjectId sha1 = ObjectId.fromString((String)"1c2a9e6194e6ede0805cda4c9ccc7e373e835414");
        String fileName = "fileName";
        IndexEntry indexEntry1 = new IndexEntry("mode-1", "type-1", sha1.getName(), fileName);
        Assert.assertTrue((String)"Failed to add indexEntry1 to entries", (boolean)entries.add(indexEntry1));
        ObjectId sha2 = ObjectId.fromString((String)"54094393c170c94d330b1ae52101922092b0abd2");
        Revision revision = new Revision(sha2);
        IndexEntry indexEntry2 = new IndexEntry("mode-2", "type-2", sha2.getName(), fileName);
        Assert.assertNull((String)"items[indexEntry2] had existing value", (Object)items.put(indexEntry2, revision));
        Assert.assertEquals((String)"entries and items[entries] wrong diff count", (long)0L, (long)this.combinator.difference(items, entries));
    }
}

