/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Random;
import jenkins.plugins.git.GitStep;
import org.jenkinsci.plugins.workflow.cps.SnippetizerTester;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitStepSnippetizerTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    private final Random random = new Random();
    private final SnippetizerTester tester = new SnippetizerTester(r);
    private final String url = "https://github.com/jenkinsci/git-plugin.git";
    private final GitStep gitStep = new GitStep("https://github.com/jenkinsci/git-plugin.git");

    private void addRandomDefaultValues(GitStep step, @NonNull String skipThese) {
        if (this.random.nextBoolean() && !skipThese.contains("poll")) {
            step.setPoll(true);
        }
        if (this.random.nextBoolean() && !skipThese.contains("changelog")) {
            step.setChangelog(true);
        }
        if (this.random.nextBoolean() && !skipThese.contains("branch")) {
            step.setBranch("master");
        }
        if (this.random.nextBoolean() && !skipThese.contains("credentialsId")) {
            step.setCredentialsId("");
        }
    }

    @Test
    public void gitSimplest() throws Exception {
        this.addRandomDefaultValues(this.gitStep, "");
        this.tester.assertRoundTrip((Step)this.gitStep, "git 'https://github.com/jenkinsci/git-plugin.git'");
    }

    @Test
    public void gitCredentials() throws Exception {
        String credentialsId = "my-credential";
        this.gitStep.setCredentialsId(credentialsId);
        this.addRandomDefaultValues(this.gitStep, "credentialsId");
        this.tester.assertRoundTrip((Step)this.gitStep, "git credentialsId: '" + credentialsId + "', url: 'https://github.com/jenkinsci/git-plugin.git'");
    }

    @Test
    public void gitBranch() throws Exception {
        String branch = "4.10.x";
        this.gitStep.setBranch(branch);
        this.addRandomDefaultValues(this.gitStep, "branch");
        this.tester.assertRoundTrip((Step)this.gitStep, "git branch: '" + branch + "', url: 'https://github.com/jenkinsci/git-plugin.git'");
    }

    @Test
    public void gitNoPoll() throws Exception {
        this.gitStep.setPoll(false);
        this.addRandomDefaultValues(this.gitStep, "poll");
        this.tester.assertRoundTrip((Step)this.gitStep, "git poll: false, url: 'https://github.com/jenkinsci/git-plugin.git'");
    }

    @Test
    public void gitNoChangelog() throws Exception {
        this.gitStep.setChangelog(false);
        this.addRandomDefaultValues(this.gitStep, "changelog");
        this.tester.assertRoundTrip((Step)this.gitStep, "git changelog: false, url: 'https://github.com/jenkinsci/git-plugin.git'");
    }
}

