/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.UserRemoteConfig;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.git.GitSampleRepoRule;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractGitRepository {
    protected File testGitDir;
    protected GitClient testGitClient;
    @Rule
    public GitSampleRepoRule repo = new GitSampleRepoRule();

    @Before
    public void createGitRepository() throws Exception {
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        this.repo.init();
        this.testGitDir = this.repo.getRoot();
        this.testGitClient = Git.with((TaskListener)listener, (EnvVars)new EnvVars()).in(this.testGitDir).getClient();
    }

    protected void commitNewFile(String fileName) throws GitException, InterruptedException {
        File newFile = new File(this.testGitDir, fileName);
        assert (!newFile.exists());
        try (PrintWriter writer = new PrintWriter(newFile, StandardCharsets.UTF_8);){
            writer.println("A file named " + fileName);
            writer.close();
            this.testGitClient.add(fileName);
            this.testGitClient.commit("Added a file named " + fileName);
        }
        catch (IOException notFound) {
            throw new GitException((Throwable)notFound);
        }
    }

    protected List<UserRemoteConfig> remoteConfigs() throws IOException {
        ArrayList<UserRemoteConfig> list = new ArrayList<UserRemoteConfig>();
        list.add(new UserRemoteConfig(this.testGitDir.getAbsolutePath(), "origin", "", null));
        return list;
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

