/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.plugins.git.AbstractGitRepository;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.CommitTimeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jgit.lib.Repository;
import org.junit.Assert;
import org.junit.Test;

public class CommitTimeComparatorTest
extends AbstractGitRepository {
    @Test
    public void testSort_OrderIsOldToNew() throws Exception {
        boolean first = true;
        for (int i = 0; i < 3; ++i) {
            if (first) {
                first = false;
            } else {
                Thread.sleep(1000L);
            }
            this.commitNewFile("file" + i);
            this.testGitClient.branch("branch" + i);
        }
        HashMap<Revision, Branch> branches = new HashMap<Revision, Branch>();
        ArrayList<Revision> revs = new ArrayList<Revision>();
        for (Branch b : this.testGitClient.getBranches()) {
            if (!b.getName().startsWith("branch")) continue;
            Revision r = new Revision(b.getSHA1());
            revs.add(r);
            branches.put(r, b);
        }
        Assert.assertEquals((long)3L, (long)revs.size());
        Repository testRepo = this.testGitClient.getRepository();
        for (int i = 0; i < 16; ++i) {
            Collections.shuffle(revs);
            Collections.sort(revs, new CommitTimeComparator(testRepo));
            for (int j = 0; j < 3; ++j) {
                Assert.assertEquals((Object)("branch" + j), (Object)((Branch)branches.get(revs.get(j))).getName());
            }
        }
    }
}

